/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.DivisionsCupResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicEventStandings;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.DivisionsCup80ScoringPolicy;
import org.ussamasters.aces.racedata.scoring.DivisionsCupScoringPolicy;
import org.ussamasters.aces.racedata.scoring.DivisionsCupSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;

public class DivisionsCupStandings
extends BasicEventStandings {
    protected static final StandingsOrganizationType DIVISIONS_CUP_ORGANIZATION_TYPE = DivisionsCupSeriesResultsOrganizer.ORGANIZATION_TYPE;

    public static DivisionsCupStandings computeStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        DivisionsCupStandings standings = new DivisionsCupStandings(eventShortName, raceSeries, registeredRacers);
        standings.computeStandings();
        return standings;
    }

    public static DivisionsCupStandings computeStandings80(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        DivisionsCupStandings standings = new DivisionsCupStandings(eventShortName, raceSeries, registeredRacers, new DivisionsCup80ScoringPolicy());
        standings.computeStandings();
        return standings;
    }

    public static SeriesStandings forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        throw new UnsupportedOperationException("Combined event short name is required");
    }

    public static DivisionsCupStandings forRaceSeries(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        if (organizationType != DIVISIONS_CUP_ORGANIZATION_TYPE) {
            throw new IllegalArgumentException("Invalid results organization: " + organizationType.name());
        }
        return new DivisionsCupStandings(eventShortName, raceSeries, registeredRacers);
    }

    public DivisionsCupStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers) {
        this(eventShortName, raceSeries, registeredRacers, new DivisionsCupScoringPolicy());
    }

    public DivisionsCupStandings(String eventShortName, RaceSeries raceSeries, RacerList registeredRacers, SeriesStandingsScoringPolicy scoringPolicy) {
        super(eventShortName, raceSeries, (BasicRaceSeriesResultsOrganizer)DivisionsCupSeriesResultsOrganizer.forRaceSeries(raceSeries, registeredRacers));
        this.setScoringPolicy(scoringPolicy);
    }

    @Override
    public void computeStandings(SeriesStandingsScoringPolicy scoringPolicy) {
        if (scoringPolicy != this.getScoringPolicySpecification()) {
            throw new UnsupportedOperationException("Only standard Divisions Cup standings computation is allowed");
        }
        super.computeStandings(scoringPolicy);
    }

    public List<DivisionsCupResult> getDivisionResults() {
        return ((DivisionsCupSeriesResultsOrganizer)this.getResultsData()).getDivisionResults();
    }
}

