/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.OrganizationScoringResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public class MedalCountsResult
extends OrganizationScoringResult {
    protected int nMen;
    protected int nWomen;
    protected int nMedalists;
    protected int[] medalCounts;

    public MedalCountsResult(RaceOrganization affiliation, int nRacers, int nMen, int nWomen, int numStarts, int nMedalists, int[] medalCounts) {
        super(affiliation, nRacers, numStarts);
        this.nMen = nMen;
        this.nWomen = nWomen;
        this.nMedalists = nMedalists;
        this.medalCounts = medalCounts;
        if (medalCounts.length != 4) {
            throw new IllegalArgumentException("Invalid medal counts (expected int[4]): " + medalCounts);
        }
    }

    protected int compare(int[] myValues, int[] otherValues) {
        int nValues = myValues.length;
        if (otherValues.length != nValues) {
            throw new IllegalArgumentException("Mismatched value arrays: " + myValues + ", " + otherValues);
        }
        for (int i = 0; i < nValues; ++i) {
            int mine = myValues[i];
            int other = otherValues[i];
            if (mine > other) {
                return -1;
            }
            if (mine >= other) continue;
            return 1;
        }
        return 0;
    }

    public int compareByMedalCounts(MedalCountsResult otherResult) {
        return this.compare(this.medalCounts, otherResult.medalCounts);
    }

    public int compareByParticipation(MedalCountsResult otherResult) {
        int[] myValues = new int[]{this.nRacers, this.numStarts};
        int[] otherValues = new int[]{otherResult.nRacers, otherResult.numStarts};
        return this.compare(myValues, otherValues);
    }

    public int compareTo(MedalCountsResult otherResult) {
        int comparison = this.compareByMedalCounts(otherResult);
        if (comparison == 0) {
            comparison = this.compareByParticipation(otherResult);
        }
        return comparison;
    }

    public int getNumberOfMedalists() {
        return this.nMedalists;
    }

    public int getNumberOfMen() {
        return this.nMen;
    }

    public int getNumberOfWomen() {
        return this.nWomen;
    }

    public int getTotalMedals() {
        return this.medalCounts[0];
    }

    public int getTotalMedals(int position) {
        return this.medalCounts[position];
    }

    public boolean isQualified() {
        return this.getTotalMedals() > 0;
    }

    public String toMedalsDescriptionString() {
        ArrayList<String> counts = new ArrayList<String>();
        int count = this.medalCounts[1];
        if (count > 0) {
            counts.add("" + count + " gold");
        }
        if ((count = this.medalCounts[2]) > 0) {
            counts.add("" + count + " silver");
        }
        if ((count = this.medalCounts[3]) > 0) {
            counts.add("" + count + " bronze");
        }
        count = this.getTotalMedals();
        return String.format("%s %s%s", count, count == 1 ? "medal" : "medals", counts.size() == 0 ? "" : " (" + this.join(counts, ", ") + ")");
    }

    private String join(List<String> collection, String separator) {
        StringBuffer buf = new StringBuffer(256);
        boolean first = true;
        for (String value : collection) {
            if (!first) {
                buf.append(separator);
            } else {
                first = false;
            }
            buf.append(value);
        }
        return buf.toString();
    }

    public String toString() {
        return String.format("%s<%s - %s>", this.getClass().getSimpleName(), this.getAffiliation().name, this.toMedalsDescriptionString());
    }
}

