/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;

public class RacePointsCalculator {
    protected RaceType raceType;
    protected int fValue;
    protected RaceTime tWinner;

    public RacePointsCalculator(RaceType raceType, int fValue, RaceTime winningTime) {
        this.raceType = raceType.basicType;
        this.fValue = fValue;
        this.tWinner = winningTime;
    }

    public RacePoints computeRacePoints(RaceTime tCompetitor) {
        return RacePoints.computePoints(tCompetitor, this.tWinner, this.fValue);
    }

    protected int toHundredthsOfSeconds(RaceTime aTime) {
        return aTime.intValue() * 100 + aTime.hundredthsValue();
    }

    public String toDescriptionString() {
        return "Race points calculation - " + this.raceType.name + " (F=" + this.fValue + "; tWinner= " + this.tWinner + ")";
    }

    public String toString() {
        return String.format("%s{%s; F=%s; tWinner=%s}", this.getClass().getName(), this.raceType.name, this.fValue, this.tWinner);
    }
}

