/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.FISMastersGroup;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicRacerResultOrganizer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.RaceResultOrganizingPolicyAdaptor;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;

public class RaceResultOrganizer
extends BasicRacerResultOrganizer<RaceEntryResult, RaceEntryResult> {
    protected static Map<Class<? extends StandingsCategory>, RacerResultOrganizingPolicy<RaceEntryResult>> organizingPoliciesRegistry;
    private RaceResult raceResult;
    private int fValue;

    public static RaceResultOrganizer forRaceResult(RaceResult raceResult, StandingsOrganizationType organizationType) {
        return new RaceResultOrganizer(raceResult, RaceResultOrganizer.getOrganizingPolicy(organizationType));
    }

    public static RacerResultOrganizingPolicy<RaceEntryResult> getOrganizingPolicy(StandingsOrganizationType organizationType) {
        Class<? extends StandingsCategory> categoryClass = organizationType.categoryClass();
        RacerResultOrganizingPolicy<RaceEntryResult> organizingPolicy = organizingPoliciesRegistry.get(categoryClass);
        if (organizingPolicy == null) {
            throw new IllegalArgumentException(String.format("No results organizing policy for organization %s (by category %s)", organizationType.name(), categoryClass.getSimpleName()));
        }
        return organizingPolicy;
    }

    public RaceResultOrganizer(RaceResult raceResult, RacerResultOrganizingPolicy<RaceEntryResult> organizingPolicy) {
        super(organizingPolicy);
        this.raceResult = raceResult;
    }

    public List<RacerResult> concatenateCategoryLists() {
        ArrayList<RacerResult> orderedResultsList = new ArrayList<RacerResult>();
        for (StandingsCategory category : this.categoryValues()) {
            CategoryResultsList categoryResultsList = this.getCategoryResults(category);
            if (categoryResultsList == null) continue;
            orderedResultsList.addAll(categoryResultsList);
        }
        return orderedResultsList;
    }

    public int getFValue() {
        return this.fValue;
    }

    public RaceResult getRaceResult() {
        return this.raceResult;
    }

    @Override
    protected void performResultsOrganization() {
        this.processRaceResult(this.raceResult);
    }

    @Override
    protected void processRacerResult(RaceEntryResult racerResult) {
        RaceEntryResult entry = (RaceEntryResult)this.getOrganizingPolicy().getResult(racerResult);
        StandingsCategory category = this.getCategory(racerResult);
        this.storeResultEntry(category, entry);
    }

    public void setFValue(int fValue) {
        this.fValue = fValue;
    }

    static {
        RaceResultOrganizingPolicyAdaptor organizingPolicy;
        organizingPoliciesRegistry = new HashMap<Class<? extends StandingsCategory>, RacerResultOrganizingPolicy<RaceEntryResult>>();
        for (Class<RaceClass<?>> clazz : RaceClass.getAllRaceClasses()) {
            organizingPolicy = new RaceResultOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return racerResult.getRaceClass();
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : NationalClassGroup.getAllNationalGroupClasses()) {
            organizingPolicy = new RaceResultOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : NationalClassGroupYOW.getAllNationalGroupClasses()) {
            organizingPolicy = new RaceResultOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return NationalClassGroupYOW.getConstant((NationalClassGroup)racerResult.getRaceClass().getGroup());
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : FISMastersGroup.getAllFISMastersGroupClasses()) {
            organizingPolicy = new RaceResultOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        Class categoryClass = Gender.class;
        organizingPolicy = new RaceResultOrganizingPolicyAdaptor(categoryClass){

            @Override
            public StandingsCategory getCategory(RaceEntryResult racerResult) {
                return racerResult.getGender();
            }
        };
        organizingPoliciesRegistry.put(categoryClass, organizingPolicy);
        categoryClass = AllRacersCategory.class;
        organizingPolicy = new RaceResultOrganizingPolicyAdaptor(categoryClass){

            @Override
            public StandingsCategory getCategory(RaceEntryResult racerResult) {
                return AllRacersCategory.ALL_RACERS;
            }
        };
        organizingPoliciesRegistry.put(categoryClass, organizingPolicy);
    }
}

