/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.HashMap;
import java.util.Map;
import org.ussamasters.aces.racedata.models.AllRacersCategory;
import org.ussamasters.aces.racedata.models.FISMastersGroup;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.RacerResultOrganizingPolicy;
import org.ussamasters.aces.racedata.scoring.SeriesResultsOrganizingPolicyAdaptor;

public class SeriesResultsOrganizer
extends BasicRaceSeriesResultsOrganizer {
    protected static final Map<Class<? extends StandingsCategory>, RacerResultOrganizingPolicy<RaceStartResult>> organizingPoliciesRegistry;

    public static SeriesResultsOrganizer forRaceSeries(RaceSeries raceSeries, RacerList registeredRacers, StandingsOrganizationType organizationType) {
        return new SeriesResultsOrganizer(raceSeries, registeredRacers, SeriesResultsOrganizer.getOrganizingPolicy(organizationType));
    }

    public static RacerResultOrganizingPolicy<RaceStartResult> getOrganizingPolicy(StandingsOrganizationType organizationType) {
        Class<? extends StandingsCategory> categoryClass = organizationType.categoryClass();
        RacerResultOrganizingPolicy<RaceStartResult> organizingPolicy = organizingPoliciesRegistry.get(categoryClass);
        if (organizingPolicy == null) {
            throw new IllegalArgumentException(String.format("No results organizing policy for organization %s (by category %s)", organizationType.name(), categoryClass.getSimpleName()));
        }
        return organizingPolicy;
    }

    public SeriesResultsOrganizer(RaceSeries raceSeries, RacerList registeredRacers, RacerResultOrganizingPolicy<RaceStartResult> organizingPolicy) {
        super(raceSeries, registeredRacers, organizingPolicy);
    }

    static {
        SeriesResultsOrganizingPolicyAdaptor organizingPolicy;
        organizingPoliciesRegistry = new HashMap<Class<? extends StandingsCategory>, RacerResultOrganizingPolicy<RaceStartResult>>();
        for (Class<RaceClass<?>> clazz : RaceClass.getAllRaceClasses()) {
            organizingPolicy = new SeriesResultsOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return racerResult.getRaceClass();
                }

                @Override
                public boolean mayHaveMultiCategoryRacers() {
                    return RaceClass.hasAbilityGroupClasses(this.categoryClass());
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : NationalClassGroup.getAllNationalGroupClasses()) {
            organizingPolicy = new SeriesResultsOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : NationalClassGroupYOW.getAllNationalGroupClasses()) {
            organizingPolicy = new SeriesResultsOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return NationalClassGroupYOW.getConstant((NationalClassGroup)racerResult.getRaceClass().getGroup());
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        for (Class<ConstantValueWithDescription> clazz : FISMastersGroup.getAllFISMastersGroupClasses()) {
            organizingPolicy = new SeriesResultsOrganizingPolicyAdaptor(clazz){

                @Override
                public StandingsCategory getCategory(RaceEntryResult racerResult) {
                    return racerResult.getRaceClass().getGroup();
                }
            };
            organizingPoliciesRegistry.put(clazz, organizingPolicy);
        }
        Class categoryClass = Gender.class;
        organizingPolicy = new SeriesResultsOrganizingPolicyAdaptor(categoryClass){

            @Override
            public StandingsCategory getCategory(RaceEntryResult racerResult) {
                return racerResult.getGender();
            }
        };
        organizingPoliciesRegistry.put(categoryClass, organizingPolicy);
        categoryClass = AllRacersCategory.class;
        organizingPolicy = new SeriesResultsOrganizingPolicyAdaptor(categoryClass){

            @Override
            public StandingsCategory getCategory(RaceEntryResult racerResult) {
                return AllRacersCategory.ALL_RACERS;
            }
        };
        organizingPoliciesRegistry.put(categoryClass, organizingPolicy);
    }
}

