/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.models;

import com.glaivestone.javax.execution.ConstructorAction;
import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.ParameterType;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.foundation.models.BibNumberRange;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;

public class PBARacerListManagementPolicy
extends RacerListManagementPolicy {
    private static final Class<PBARacerListManagementPolicy> THIS_CLASS = PBARacerListManagementPolicy.class;
    public static final PolicyID POLICY_ID = PolicyID.defineConstant("permanentBibsRacerListManagementPolicy", "RacerListManagement", "permanent bib assignments (registered racers have permanent bib numbers)");
    public static final String PARM_BIB_ALLOCATION_ORGANIZATION = "bibAllocationOrganization";
    public static final String PARM_PERMANENT_BIBS = "permanentBibsRange";
    public static final String PARM_SERIES_TRACKING_BIBS = "seriesTempBibsRange";
    public static final RacerListManagementPolicySpecification DEFAULT_POLICY_SPEC;
    protected static final List<PolicyID> supportedPolicies;
    protected RaceOrganization bibAllocationOrganization;
    protected BibNumberRange[] permanentBibs;
    protected BibNumberRange[] seriesTrackingBibs;

    public static RacerListManagementPolicySpecification createPolicySpec(PolicyID policyID, RaceOrganization bibAllocationOrganization, BibNumberRange[] permanentBibsRange, BibNumberRange[] seriesTrackingBibsRange, Class<?> policyImplClass) {
        return PBARacerListManagementPolicy.createPolicySpec(policyID, bibAllocationOrganization, BibNumberRange.toSpecificationString(permanentBibsRange), BibNumberRange.toSpecificationString(seriesTrackingBibsRange), policyImplClass);
    }

    public static RacerListManagementPolicySpecification createPolicySpec(PolicyID policyID, RaceOrganization bibAllocationOrganization, String permanentBibsRangeSpec, String seriesTrackingBibsRangeSpec, Class<?> policyImplClass) {
        return new RacerListManagementPolicySpecification(policyID, new ParameterSpecification[]{RacerListManagementPolicySpecification.TRACK_RACERS_BY_BIB, PBARacerListManagementPolicy.createBibAllocationOrgParmSpec(bibAllocationOrganization), PBARacerListManagementPolicy.createPermanentBibsParmSpec(permanentBibsRangeSpec), PBARacerListManagementPolicy.createSeriesTrackingBibsParmSpec(seriesTrackingBibsRangeSpec)}, RacerListManagementPolicySpecification.createStandardConstructionAction(policyImplClass));
    }

    public static ParameterSpecification createBibAllocationOrgParmSpec(RaceOrganization bibAllocOrg) {
        return new ParameterSpecification(PARM_BIB_ALLOCATION_ORGANIZATION, "Bib allocation organization", "Organization which manages permanent bib assignments", ParameterType.STRING, false, bibAllocOrg.name);
    }

    public static ParameterSpecification createPermanentBibsParmSpec(String bibRangeSpecString) {
        return new ParameterSpecification(PARM_PERMANENT_BIBS, "Permanent bib range(s)", "Bib range(s) [m..n] permanently assigned to member competitors", ParameterType.STRING, true, bibRangeSpecString);
    }

    public static ParameterSpecification createSeriesTrackingBibsParmSpec(String bibRangeSpecString) {
        return new ParameterSpecification(PARM_SERIES_TRACKING_BIBS, "Tracking bib range(s)", "Bib range(s) [m..n] or nnn+ used solely for series racer tracking", ParameterType.STRING, true, bibRangeSpecString);
    }

    public static boolean isSupportedPolicy(PolicyID policyID) {
        return supportedPolicies.contains(policyID);
    }

    protected static void registerDefaultSpec(RacerListManagementPolicySpecification policySpec) {
        RacerListManagementPolicy.registerDefaultSpec(policySpec);
        supportedPolicies.add(policySpec.policyID);
    }

    public static RaceOrganization toOrganization(ParameterSpecification parmSpec) {
        return RaceOrganization.getConstant((String)parmSpec.value);
    }

    public static BibNumberRange[] toBibNumberRanges(ParameterSpecification parmSpec) {
        return BibNumberRange.parseBibRangeSpec((String)parmSpec.value);
    }

    public PBARacerListManagementPolicy(RaceOrganization bibAllocationOrganization, BibNumberRange[] permanentBibs, BibNumberRange[] seriesTrackingBibs) {
        super(POLICY_ID);
        this.bibAllocationOrganization = bibAllocationOrganization;
        this.permanentBibs = permanentBibs;
        this.seriesTrackingBibs = seriesTrackingBibs;
        if (this.bibAllocationOrganization == null) {
            throw new IllegalArgumentException("Division organization must be specified");
        }
        this.validateRangeCoverage();
    }

    public PBARacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        super(policySpec);
    }

    @Override
    protected int computeNextAvailableBibNumber() {
        return Math.max(super.computeNextAvailableBibNumber(), this.seriesTrackingBibs[0].firstNumber);
    }

    @Override
    public void configureOptions(RacerListManagementPolicySpecification policySpec) {
        for (int i = 0; i < policySpec.getNumberOfParameters(); ++i) {
            ParameterSpecification parmSpec = policySpec.getParameterSpecification(i);
            if (!parmSpec.modifiable) continue;
            if (parmSpec.name.equals(PARM_BIB_ALLOCATION_ORGANIZATION)) {
                this.bibAllocationOrganization = PBARacerListManagementPolicy.toOrganization(parmSpec);
            }
            if (parmSpec.name.equals(PARM_PERMANENT_BIBS)) {
                this.permanentBibs = PBARacerListManagementPolicy.toBibNumberRanges(parmSpec);
            }
            if (!parmSpec.name.equals(PARM_SERIES_TRACKING_BIBS)) continue;
            this.seriesTrackingBibs = PBARacerListManagementPolicy.toBibNumberRanges(parmSpec);
        }
        this.validateConfiguration(policySpec);
    }

    @Override
    public RacerListManagementPolicy copy() {
        Class[] parmTypes = new Class[]{RaceOrganization.class, BibNumberRange.ARRAY_TYPE, BibNumberRange.ARRAY_TYPE};
        Object[] args = new Object[]{this.bibAllocationOrganization, this.permanentBibs, this.seriesTrackingBibs};
        return (RacerListManagementPolicy)ConstructorAction.create(this.getClass(), parmTypes, args).evaluate();
    }

    public boolean isPermanentBibNumber(int bibNumber) {
        return BibNumberRange.contains(bibNumber, this.permanentBibs);
    }

    @Override
    public boolean isRaceTempBibNumber(int bibNumber) {
        return !this.isPermanentBibNumber(bibNumber) && !this.isSeriesTrackingBibNumber(bibNumber);
    }

    public boolean isSeriesTrackingBibNumber(int bibNumber) {
        return BibNumberRange.contains(bibNumber, this.seriesTrackingBibs);
    }

    @Override
    public void setRacerList(RacerList racerList) {
        super.setRacerList(racerList);
    }

    public String toString() {
        return String.format("%s<%s, permanent bibs %s, series tracking bibs %s>", this.getClass().getSimpleName(), this.bibAllocationOrganization.name, BibNumberRange.toDescriptionString(this.permanentBibs), BibNumberRange.toDescriptionString(this.seriesTrackingBibs));
    }

    @Override
    public void validateBibNumber(int bibNumber, RaceOrganization affiliation, String racerName, ValidationResolver validationResolver, ValidationResult validationResult) {
        if (affiliation == this.bibAllocationOrganization) {
            if (this.isPermanentBibNumber(bibNumber)) {
                return;
            }
            if (this.isSeriesTrackingBibNumber(bibNumber)) {
                String confirmationMessage = this.bibAllocationOrganization.description + " members usually have a permanent bib number assignment " + BibNumberRange.toDescriptionString(this.permanentBibs) + ".\n\nDo you really want to register " + racerName + " under bib number " + bibNumber + "?";
                if (!validationResolver.confirm("bibNumber", confirmationMessage)) {
                    validationResult.reportProblem("bibNumber", "Bib number should be in the range " + BibNumberRange.toDescriptionString(this.permanentBibs) + " for " + this.bibAllocationOrganization.description + " member racers.");
                    return;
                }
                return;
            }
            validationResult.reportProblem("bibNumber", "Bib number should be either a permanent bib number " + BibNumberRange.toDescriptionString(this.permanentBibs) + " or a series tracking number " + BibNumberRange.toDescriptionString(this.seriesTrackingBibs));
            return;
        }
        if (affiliation.isRecognizedOrganization()) {
            if (this.isSeriesTrackingBibNumber(bibNumber)) {
                return;
            }
            if (this.isPermanentBibNumber(bibNumber)) {
                String confirmationMessage = "An out-of-division racer should usually be recorded with a series tracking bib number " + BibNumberRange.toDescriptionString(this.seriesTrackingBibs) + ", not with permanent bib number " + BibNumberRange.toDescriptionString(this.permanentBibs) + " assigned to " + this.bibAllocationOrganization.description + " members.\n\nDo you really want to register " + racerName + " under bib number " + bibNumber + "?";
                if (!validationResolver.confirm("bibNumber", confirmationMessage)) {
                    validationResult.reportProblem("bibNumber", "Bib number should be " + BibNumberRange.toDescriptionString(this.seriesTrackingBibs) + " for racers who are not " + this.bibAllocationOrganization.description + " members.");
                    return;
                }
                return;
            }
            validationResult.reportProblem("bibNumber", "Bib number should be either a permanent bib number " + BibNumberRange.toDescriptionString(this.permanentBibs) + " or a series tracking number " + BibNumberRange.toDescriptionString(this.seriesTrackingBibs));
            return;
        }
        if (!this.isSeriesTrackingBibNumber(bibNumber)) {
            validationResult.reportProblem("bibNumber", "Bib number assigned for series standings tracking must be " + BibNumberRange.toDescriptionString(this.seriesTrackingBibs) + " for a temporary racer.");
            return;
        }
    }

    protected void validateConfiguration(RacerListManagementPolicySpecification policySpec) {
        if (!PBARacerListManagementPolicy.isSupportedPolicy(policySpec.policyID)) {
            throw new IllegalArgumentException("Invalid policy ID: " + policySpec);
        }
        if (this.bibAllocationOrganization == null || this.bibAllocationOrganization == RaceOrganization.UNKNOWN) {
            throw new IllegalArgumentException("Division organization must be specified");
        }
        this.validateRangeCoverage();
    }

    protected void validateRangeCoverage() {
        if (BibNumberRange.hasOverlap(this.permanentBibs, this.seriesTrackingBibs)) {
            throw new IllegalStateException("Series tracking bib numbers " + BibNumberRange.toDescriptionString(this.seriesTrackingBibs) + " may not overlap permanent bibs range " + BibNumberRange.toDescriptionString(this.permanentBibs));
        }
    }

    static {
        supportedPolicies = new ArrayList<PolicyID>();
        DEFAULT_POLICY_SPEC = PBARacerListManagementPolicy.createPolicySpec(POLICY_ID, RaceOrganization.UNKNOWN, "0..899", "1000+", THIS_CLASS);
        PBARacerListManagementPolicy.registerDefaultSpec(DEFAULT_POLICY_SPEC);
    }
}

