/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.processors;

import com.glaivestone.javax.execution.ClassReference;
import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.execution.StaticMethodAction;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.javax.io.SystemIOStreams;
import com.glaivestone.javax.util.PropagatedException;
import com.glaivestone.mv.UISessionManager;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.SettingsSectionHolder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ussamasters.aces.tools.foundation.settings.LoggingConfigurationSettings;

public class ConfigurationSettingsProcessor
extends SettingsSectionHolder {
    public static final String SESSION_LOG_WINDOW_OPEN_METHOD = "createWindow";
    public static final Class<?>[] SESSION_LOG_WINDOW_OPEN_PARM_TYPES = new Class[]{String.class};
    public static final String DEFAULT_SESSION_LOG_WINDOW_CLASS = "com.glaivestone.toolbox.textui.TextLogWindow";
    protected File logFileDirectory;

    public ConfigurationSettingsProcessor(SettingsSection settings, SettingsFileHolder fileHolder) {
        this(settings, fileHolder, new File("-r-../log"));
    }

    public ConfigurationSettingsProcessor(SettingsSection settings, SettingsFileHolder fileHolder, File logFileDirectory) {
        super(settings, fileHolder);
        this.logFileDirectory = logFileDirectory;
    }

    public Object createCompositeLog(Collection<Object> logs) {
        throw new UnsupportedOperationException("PrintTargetCollection not yet reinvented");
    }

    protected Object createFileLog(String logFileName, boolean appendToExistingContents) throws IOException {
        File logFile = new File(this.getLogFileDirectory(), logFileName);
        FileSystemServices.getCurrent().realizeDirectory(this.getLogFileDirectory());
        throw new UnsupportedOperationException("NEED TO REINVENT THIS");
    }

    protected Object createLog(Class<?> logClass, String createSelector, Class<?>[] parmTypes, Object[] args) {
        return StaticMethodAction.create(logClass, createSelector, parmTypes).evaluate(args);
    }

    protected Object createWindowLog(String windowTitle) {
        String logWindowClassName = (String)SessionManager.current.getOption("sessionLogWindow", DEFAULT_SESSION_LOG_WINDOW_CLASS);
        String createSelector = (String)SessionManager.current.getOption("sessionLogWindowCreateSelector", SESSION_LOG_WINDOW_OPEN_METHOD);
        return this.createLog(this.getLogWindowClass(logWindowClassName), createSelector, SESSION_LOG_WINDOW_OPEN_PARM_TYPES, new Object[]{windowTitle});
    }

    public File getLogFileDirectory() {
        return this.logFileDirectory;
    }

    protected Class<?> getLogWindowClass(String logWindowClassName) {
        Class<?> logWindowClass;
        try {
            logWindowClass = Class.forName(logWindowClassName);
        }
        catch (ClassNotFoundException ex) {
            logWindowClass = this.loadClass(DEFAULT_SESSION_LOG_WINDOW_CLASS, "Default log window class");
            System.err.println("The log window class " + logWindowClassName + " specified in the settings not found ; using the default log window class: " + DEFAULT_SESSION_LOG_WINDOW_CLASS);
        }
        return logWindowClass;
    }

    protected String getSectionName() {
        return this.getSettingsSection().getQualifiedName();
    }

    public void installLog(Object log, boolean setSysOut, boolean setSysErr) {
        if (!(log instanceof PrintStream)) {
            return;
        }
        PrintStream logTarget = (PrintStream)log;
        if (setSysOut && setSysErr) {
            SystemIOStreams.setSystemOutputStreams(logTarget);
            return;
        }
        if (setSysOut) {
            SystemIOStreams.setSysOut(logTarget);
        }
        if (setSysErr) {
            SystemIOStreams.setSysErr(logTarget);
        }
    }

    protected Class<?> loadClass(String aClassName, String description) {
        return ClassReference.resolve(aClassName, description);
    }

    public void processClassLoadList() {
        String propertyName = "classLoadList";
        List<String> classLoadList = this.getSettings().getStringValueList(propertyName);
        int index = 0;
        for (String className : classLoadList) {
            String description = String.format("%s.%s[%s]", this.getSectionName(), propertyName, index);
            this.loadClass(className, description);
            ++index;
        }
    }

    protected void processInitAction(String initAction, String description) {
        String separator = "::";
        int ixSeparator = initAction.indexOf(separator);
        String className = initAction.substring(0, ixSeparator);
        String selector = initAction.substring(ixSeparator + 2, initAction.length());
        Class<?> aClass = ClassReference.resolve(className, description);
        try {
            StaticMethodAction.create(aClass, selector).evaluate();
        }
        catch (PropagatedException ex) {
            System.err.println("FATAL ERROR: Unable to perform initAction " + className + "::" + selector + ": " + ex.getCause());
            SessionManager.current.shutdown();
        }
    }

    protected void processInitActions() {
        String propertyName = "initActions";
        List<String> initActions = this.getSettings().getStringValueList(propertyName);
        int index = 0;
        for (String initAction : initActions) {
            String description = String.format("%s.%s[%s]", this.getSectionName(), propertyName, index);
            this.processInitAction(initAction, description);
            ++index;
        }
    }

    protected Object processLogDestinationSettings(LoggingConfigurationSettings loggingSettings) {
        String logFileName;
        ArrayList<Object> logs = new ArrayList<Object>();
        String windowTitle = loggingSettings.getLogWindowName();
        if (windowTitle != null) {
            logs.add(this.createWindowLog(windowTitle));
        }
        if ((logFileName = loggingSettings.getLogFileName()) != null) {
            boolean append = loggingSettings.getLogFileAppend(true);
            try {
                logs.add(this.createFileLog(logFileName, append));
            }
            catch (IOException e) {
                System.out.println("Unable to create log file '" + logFileName + "' as configured in settings file " + this.getFileHolder().getFile().getAbsolutePath());
            }
        }
        if (logs.isEmpty()) {
            return null;
        }
        Object systemLog = logs.size() == 1 ? logs.get(0) : this.createCompositeLog(logs);
        this.installLog(systemLog, true, true);
        return systemLog;
    }

    public void processLoggingSettings() {
        LoggingConfigurationSettings loggingSettings = new LoggingConfigurationSettings(this.getSettingsSection());
        Object systemLog = this.processLogDestinationSettings(loggingSettings);
    }

    public void processSessionControlOptions() {
        this.processSessionManagerSetting();
        this.processSessionDefaultWindowIconSetting();
        this.processSessionOptions();
        this.processLoggingSettings();
    }

    public void processSessionDefaultWindowIconSetting() {
        String iconReference = this.getStringValueOrNull("defaultWindowIcon");
        if (iconReference != null) {
            UISessionManager.current.setDefaultWindowIconReference(iconReference);
        }
    }

    public void processSessionManagerSetting() {
        String propertyName = "sessionManager";
        String aClassName = this.getStringValueOrNull(propertyName);
        if (aClassName == null) {
            return;
        }
        Class<?> sessionManagerClass = this.loadClass(aClassName, propertyName);
    }

    public void processSessionOptions() {
        List<Object> sessionOptions = this.getSettings().getValueList("sessionOptions");
        for (Object option : sessionOptions) {
            this.processSessionOptionSetting((String)option);
        }
    }

    protected void processSessionOptionSetting(String optionSetting) {
        String separator = "=";
        int indexSeparator = optionSetting.indexOf(separator);
        String name = optionSetting.substring(0, indexSeparator).trim();
        Object value = this.normalizeValue(optionSetting.substring(indexSeparator + 1, optionSetting.length()).trim());
        SessionManager.current.registerOption(name, value);
    }

    public void setLogFileDirectory(File aDirectory) {
        this.logFileDirectory = aDirectory;
    }
}

