/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.processors;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.execution.ClassReference;
import com.glaivestone.toolbox.settings.SettingsFileHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import java.io.File;
import java.util.List;
import javax.swing.ImageIcon;
import org.ussamasters.aces.tools.foundation.models.RaceScoringSessionManager;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.processors.InstallationConfigurationSettingsProcessor;
import org.ussamasters.aces.tools.foundation.settings.ToolConfigurationSettings;

public class ToolSessionSettingsProcessor
extends InstallationConfigurationSettingsProcessor {
    protected RaceScoringSessionManager toolSessionManager;
    protected SettingsSection toolSettings;

    public ToolSessionSettingsProcessor(RaceScoringSessionManager toolSessionManager, SettingsFileHolder rootSettings) {
        super(rootSettings);
        this.toolSessionManager = toolSessionManager;
    }

    @Override
    protected File getBaseDirectory() {
        return this.toolSessionManager.getToolInstallationDirectory();
    }

    @Override
    protected SettingsSection getConfigSettings() {
        return this.toolSettings;
    }

    public void processConfigurationSpecifications() {
        this.processSystemSpecifications();
        this.processToolSpecifications();
    }

    protected void processToolSpecifications() {
        this.processToolSpecifications(this.getRootSettings().getSection("Tools"));
    }

    protected void processToolEntry(String toolName, String description) {
        SettingsSection toolConfigSettings = ToolConfigurationSettings.current.getSection(toolName);
        if (toolConfigSettings == null) {
            throw new RuntimeException(String.format("Invalid tool: %s configuration not found (%s)", toolName, description));
        }
        String propertyName = "toolClass";
        String toolClassName = toolConfigSettings.getStringValue(propertyName);
        String classReferenceDescription = String.format("%s -> [%s].%s", description, toolName, propertyName);
        Class<?> toolClass = ClassReference.resolve(toolClassName, classReferenceDescription);
        ToolID toolID = ToolID.getConstant(toolName);
        ToolInfo toolInfo = new ToolInfo(toolID, toolClass, toolConfigSettings);
        this.toolSessionManager.registerTool(toolInfo);
        toolInfo.installTool();
    }

    protected void processToolSpecifications(SettingsSection toolsSection) {
        String propertyName = "tools";
        List<String> configuredTools = toolsSection.getStringValueList(propertyName);
        int index = 0;
        for (String toolName : configuredTools) {
            String description = String.format("%s.%s[%s]", "Tools", propertyName, index);
            this.processToolEntry(toolName, description);
            ++index;
        }
    }

    @Override
    protected ImageIcon resolveSplashScreenReference(String splashScreenFileRef) {
        return this.loadImageFile(splashScreenFileRef, this.toolSessionManager.getToolInstallationDirectory());
    }

    @Override
    protected void setRootSettings(SettingsFileHolder rootSettings) {
        super.setRootSettings(rootSettings);
        this.toolSettings = rootSettings.getSection("Tools");
        Assert.isTrue(this.toolSettings != null, "No <Tools> config specifications section in " + this.getRootSettings().getFile().getAbsolutePath());
    }

    public static void processConfigurationSpecifications(RaceScoringSessionManager toolSessionManager, SettingsFileHolder rootSettings) {
        ToolSessionSettingsProcessor settingsProcessor = new ToolSessionSettingsProcessor(toolSessionManager, rootSettings);
        settingsProcessor.processConfigurationSpecifications();
    }
}

