/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.javax.devx.Assert;
import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.io.FileSystemServices;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;
import org.ussamasters.aces.tools.foundation.settings.ToolConfigurationSettings;
import org.ussamasters.aces.tools.foundation.settings.UserSettings;

public class ToolSessionSettings
extends StandardSettingsFileHolder {
    public static ToolSessionSettings current = null;
    public static final String NAME = "ToolSessionSettings";
    public static final String FILE_NAME = FILE_TYPE.composeFileName("ToolSessionSettings");
    public static final String SECTION_TOOLS = "Tools";
    public static final String PROPERTY_CONFIGURED_TOOLS = "tools";

    public static ToolSessionSettings getCurrent() {
        return current;
    }

    protected static boolean isToolSessionDirectory(File aDirectory, String configSettingsFileName) {
        if (aDirectory == null || !aDirectory.isDirectory()) {
            return false;
        }
        return new File(aDirectory, configSettingsFileName).exists();
    }

    public static synchronized void loadCurrent(File aDirectory) {
        ToolSessionSettings.loadCurrent(aDirectory, FILE_NAME);
    }

    public static synchronized void loadCurrent(File aDirectory, String configSettingsFileName) {
        if (!ToolSessionSettings.isToolSessionDirectory(aDirectory, configSettingsFileName)) {
            File toolsSubdir = new File(aDirectory, SECTION_TOOLS);
            if (toolsSubdir.exists()) {
                ToolSessionSettings.loadCurrent(toolsSubdir, configSettingsFileName);
                return;
            }
            System.err.println("***FATAL INSTALLATION ERROR: no tool installation settings file " + configSettingsFileName + " found in " + aDirectory.getAbsolutePath() + ".");
            SessionManager.current.shutdown();
        }
        try {
            current = ToolSessionSettings.loadFromDirectory(aDirectory, configSettingsFileName);
        }
        catch (IOException ex) {
            System.err.println("***FATAL INSTALLATION ERROR: unable to load tool settings file " + configSettingsFileName + " in " + aDirectory.getAbsolutePath() + ".");
            System.err.println(ex);
            SessionManager.current.shutdown();
        }
    }

    public static synchronized ToolSessionSettings loadFromDirectory(File aDirectory, String configSettingsFileName) throws IOException {
        if (aDirectory == null || !aDirectory.isDirectory()) {
            Assert.shouldNotBe();
            return null;
        }
        if (!ToolSessionSettings.isToolSessionDirectory(aDirectory, configSettingsFileName)) {
            Assert.shouldNotBe();
            return null;
        }
        return new ToolSessionSettings(new File(aDirectory, configSettingsFileName));
    }

    public ToolSessionSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    public void bootstrapConfigurationSettingsDirectory(File userConfigFilesDirectory) {
        File defaultUserSettingsFile;
        this.copyAllFiles(new File(this.getDirectory(), "User"), userConfigFilesDirectory);
        File userSettingsFile = new File(userConfigFilesDirectory, UserSettings.FILE_NAME);
        if (!userSettingsFile.exists() && (defaultUserSettingsFile = new File(ToolConfigurationSettings.getDefaultsSubdirectory(SessionRootSettings.getCurrent().getSystemDirectory()), UserSettings.FILE_NAME)).exists()) {
            this.copyFile(defaultUserSettingsFile, userSettingsFile);
        }
    }

    protected void copyAllFiles(File sourceDirectory, File targetDirectory) {
        try {
            FileSystemServices.getCurrent().realizeDirectory(targetDirectory);
        }
        catch (IOException ex) {
            System.err.println("***I/O Error bootstrapping directory contents from " + sourceDirectory.getAbsolutePath());
            ex.printStackTrace(System.err);
            return;
        }
        File[] elements = sourceDirectory.listFiles();
        for (int i = 0; i < elements.length; ++i) {
            File fsElement = elements[i];
            File targetElement = new File(targetDirectory, fsElement.getName());
            if (fsElement.isFile()) {
                if (targetElement.exists()) continue;
                this.copyFile(fsElement, targetElement);
                continue;
            }
            this.copyAllFiles(fsElement, targetElement);
        }
    }

    protected void copyFile(File sourceFile, File targetFile) {
        try {
            FileSystemServices.getCurrent().copyFile(sourceFile, targetFile);
        }
        catch (IOException ex) {
            System.err.println("***I/O Error bootstrapping ConfigurationSettings -file " + sourceFile.getAbsolutePath());
            ex.printStackTrace(System.err);
        }
    }
}

