/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.tools.foundation.settings.SessionRootSettings;

public class UserSettings
extends StandardSettingsFileHolder {
    public static UserSettings current = null;
    public static final String NAME = "UserSettings";
    public static final String FILE_NAME = FILE_TYPE.composeFileName("UserSettings");
    private static final String PROPERTY_CURRENT_WORKING_SET_DIRECTORY = "currentRaceDataDirectory";
    private static final String DEFAULT_WORKING_SET_DIRECTORY_NAME = "Default";
    private static final String DEFAULT_WORKING_SET_DIRECTORY_REFERENCE = "-r-Default";
    protected File currentWorkingDirectory;

    protected static SettingsSection constructDefaultSettings() {
        SettingsSection defaultSettings = UserSettings.createSettings(NAME);
        SettingsSection defaultDebugSection = defaultSettings.createSection("Debug");
        defaultDebugSection.setBooleanValue("debugEnabled", false);
        defaultDebugSection.setStringValue("logWindow", "Masters Race Scoring Tools Session Log");
        defaultDebugSection.setStringValue("logFile", "ToolDebugLog.txt");
        defaultDebugSection.setBooleanValue("logFileAppend", false);
        return defaultSettings;
    }

    public static UserSettings getCurrent() {
        return current;
    }

    public static synchronized void loadCurrent() {
        UserSettings.loadCurrent(SessionRootSettings.getCurrent().getUserConfigurationDirectory(), FILE_NAME);
    }

    public static synchronized void loadCurrent(File aDirectory, String configSettingsFileName) {
        File configFile = new File(aDirectory, configSettingsFileName);
        UserSettings settings = null;
        if (configFile.exists()) {
            try {
                settings = new UserSettings(configFile);
            }
            catch (IOException ex) {
                System.err.println("***ERROR loading user settings (" + configFile.getAbsolutePath() + ")");
                ex.printStackTrace();
            }
        }
        if (settings == null) {
            System.err.println("NOTE: Installing default backstop user settings");
            settings = new UserSettings(UserSettings.constructDefaultSettings());
            settings.setFile(configFile);
            if (!configFile.exists()) {
                try {
                    settings.saveSettings();
                }
                catch (IOException ex) {
                    System.err.println("***Unable to save default backstop for user settings (" + configFile.getAbsolutePath() + ")");
                    ex.printStackTrace();
                }
            }
        }
        current = settings;
    }

    public UserSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    protected UserSettings(SettingsSection settings) {
        super(settings);
    }

    public File getCurrentWorkingDirectory() {
        if (this.currentWorkingDirectory == null) {
            this.initCurrentWorkingDirectory();
        }
        return this.currentWorkingDirectory;
    }

    protected void initCurrentWorkingDirectory() {
        File aDirectory;
        File workingSetsDirectory = SessionRootSettings.getCurrent().getUserDataDirectory();
        String dirSettingName = PROPERTY_CURRENT_WORKING_SET_DIRECTORY;
        String dirReference = this.getSettings().getStringValue(dirSettingName, null);
        boolean createIfNotThere = false;
        if (dirReference != null && (dirReference = dirReference.trim()).length() == 0) {
            dirReference = null;
        }
        if (dirReference == null) {
            dirReference = DEFAULT_WORKING_SET_DIRECTORY_REFERENCE;
            createIfNotThere = true;
        }
        if ((aDirectory = SettingsHolder.resolveDirectoryReference(dirReference, workingSetsDirectory, createIfNotThere)) == null || !aDirectory.exists()) {
            aDirectory = SettingsHolder.resolveDirectoryReference(DEFAULT_WORKING_SET_DIRECTORY_REFERENCE, workingSetsDirectory, true);
        }
        this.currentWorkingDirectory = aDirectory;
    }

    public void setCurrentWorkingDirectory(File aWorkingSetDirectory) {
        this.setFileValue(PROPERTY_CURRENT_WORKING_SET_DIRECTORY, aWorkingSetDirectory, SessionRootSettings.getCurrent().getUserDataDirectory());
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.currentWorkingDirectory = null;
    }
}

