/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.foundation.settings;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.lang.ClassX;
import com.glaivestone.javax.util.PropagatedException;
import com.glaivestone.toolbox.settings.Settings;
import com.glaivestone.toolbox.settings.SettingsHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsFileHolder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.racedata.reports.RaceDataReportOptions;
import org.ussamasters.aces.tools.foundation.models.PBARacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicySpecification;
import org.ussamasters.aces.tools.foundation.models.SeriesRacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolServices;

public class WorkingSetSettings
extends StandardSettingsFileHolder {
    public static final String NAME = "WorkingSetSettings";
    public static final String FILE_NAME = FILE_TYPE.composeFileName("WorkingSetSettings");
    public static final String POLICY_CATEGORY_RACER_LIST_MERGE = "RacerListMerge";
    public static final String RACER_LIST_MERGE_POLICY_NAME_SUFFIX = "RacerListMergePolicy";
    public static final PolicyID USER_RESOLUTION_RACER_LIST_MERGE_POLICY = PolicyID.defineConstant("userResolutionRacerListMergePolicy", "RacerListMerge", "Require user interaction before adding new/unrecognized racers");
    public static final PolicyID MAP_ON_DEFINITE_MATCH_RACER_LIST_MERGE_POLICY = PolicyID.defineConstant("mapOnDefiniteRacerMatchRacerListMergePolicy", "RacerListMerge", "Automatically map to existing racer if definite match identified.");
    public static final PolicyID DEFAULT_RACER_LIST_MERGE_POLICY = USER_RESOLUTION_RACER_LIST_MERGE_POLICY;
    public static final WorldCupPointsType DEFAULT_WORLD_CUP_POINTS = WorldCupPointsType.worldCupPoints15;
    private static final WorldCupPointsType DEFAULT_WORLD_CUP_POINTS_FW_2016 = WorldCupPointsType.worldCupPoints30;
    public static final String DEFAULT_TIMING_DATA_FILES_SOURCE_DIRECTORY_NAME = "TimingSystemFiles";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_DESCRIPTION = "description";
    private static final String PROPERTY_ORGANIZER = "organizer";
    private static final String PROPERTY_SEASON = "season";
    private static final String PROPERTY_RACE_CLASS = "raceClass";
    private static final String PROPERTY_WORLD_CUP_POINTS = "worldCupPoints";
    private static final String PROPERTY_STANDARD_COURSE_ARRANGEMENT = "standardCourseArrangement";
    private static final String PROPERTY_TIMING_DATA_FILES_SOURCE_DIRECTORY = "timingDataFilesSource";
    private static final String DEFAULT_TIMING_DATA_FILES_SOURCE_DIRECTORY = "-r-TimingSystemFiles";
    private static final String SECTION_RACER_LIST_SETTINGS = "RacerList";
    private static final String PROPERTY_RACER_LIST_MANAGEMENT_POLICY = "managementPolicy";
    private static final String PROPERTY_RACER_LIST_MANAGEMENT_ORGANIZATION = "managementPolicy-bibAllocationOrganization";
    private static final String PROPERTY_RACER_LIST_MANAGEMENT_PERMANENT_BIBS_RANGE = "managementPolicy-permanentBibsRange";
    private static final String PROPERTY_RACER_LIST_MANAGEMENT_SERIES_TEMP_BIB_RANGE = "managementPolicy-seriesTempBibsRange";
    private static final String PROPERTY_RACER_LIST_MERGE_POLICY = "mergePolicy";
    private static final String SECTION_REPORT_SETTINGS = "Report";
    private static final String SECTION_SEASON_SETTINGS = "Season";
    private static final String PROPERTY_SEASON_START_YEAR = "seasonStartYear";
    private static final String PROPERTY_SEASON_SCORING_BEST_N_COUNT = "seasonScoring-bestN";
    private static final String PROPERTY_SEASON_SCORING_BEST_N_DISCIPINE_COUNT = "seasonScoring-bestNDiscipline";
    private static final String PROPERTY_SEASON_SCORING_ABILITY_BONUS_AGE_CLASS_SCORE = "seasonScoring-abilityBonus-ageClassScore";
    private static final String PROPERTY_SEASON_SCORING_ABILITY_BONUS_INCLUDE_ABILITY_CLASSES = "seasonScoring-abilityBonus-includeAbilityClasses";
    private static final String PROPERTY_SEASON_SCORING_ALLOW_GENDER_STANDINGS_HACK = "seasonScoring-allowComputeGenderWithSeparateDCourse";
    private static final int DEFAULT_ABILITY_BONUS_AGE_CLASS_SCORE = 20;
    private static final boolean DEFAULT_ABILITY_BONUS_INCLUDE_ABILITY_CLASSES = true;
    private static final String SECTION_TOOL_OPTIONS = "ToolOptions";
    private static WorkingSetSettings current;
    private static List<PolicyID> racerListManagementPoliciesList;
    private static List<PolicyID> racerListMergePoliciesList;
    private StandingsType type;
    SeasonIdentifier season;
    private Class<? extends RaceClass<?>> raceClassClass;
    private RaceDataReportOptions reportOptions;
    private SettingsSection toolOptions;

    protected static void initStaticData() {
        List<PolicyID> policyList = RacerListManagementPolicy.getRegisteredPolicies();
        Collections.sort(policyList, ToolServices.BY_NAME_CONSTANT_SORTER);
        racerListManagementPoliciesList = Collections.unmodifiableList(policyList);
        policyList = new ArrayList<PolicyID>();
        policyList.add(USER_RESOLUTION_RACER_LIST_MERGE_POLICY);
        policyList.add(MAP_ON_DEFINITE_MATCH_RACER_LIST_MERGE_POLICY);
        racerListMergePoliciesList = Collections.unmodifiableList(policyList);
    }

    public static WorkingSetSettings createSettings(StandingsType standingsType, String description, SeasonIdentifier season, Class<? extends RaceClass<?>> raceClassClass, CourseArrangement standardCourseArrangement) {
        WorkingSetSettings wsSettings = new WorkingSetSettings(WorkingSetSettings.constructDefaultSettings());
        wsSettings.setType(standingsType);
        wsSettings.setDescription(description);
        wsSettings.setSeason(season);
        wsSettings.setRaceClassClass(raceClassClass);
        wsSettings.setStandardCourseArrangement(standardCourseArrangement);
        return wsSettings;
    }

    protected static SettingsSection constructDefaultSettings() {
        SettingsSection defaultSettings = WorkingSetSettings.createSettings(NAME);
        return defaultSettings;
    }

    public static WorkingSetSettings getCurrent() {
        return current;
    }

    public static List<PolicyID> getRacerListManagementPolicies() {
        return racerListManagementPoliciesList;
    }

    public static List<PolicyID> getRacerListMergePolicies() {
        return racerListMergePoliciesList;
    }

    public static boolean isWorkingSetDirectory(File aDirectory) {
        if (aDirectory == null || !aDirectory.isDirectory()) {
            return false;
        }
        return new File(aDirectory, FILE_NAME).exists();
    }

    public static synchronized void loadCurrent(File aDirectory) throws IOException {
        current = WorkingSetSettings.loadFromDirectory(aDirectory);
    }

    public static synchronized WorkingSetSettings loadFromDirectory(File aDirectory) throws IOException {
        return new WorkingSetSettings(new File(aDirectory, FILE_NAME));
    }

    public WorkingSetSettings(File backingFile) throws IOException {
        super(backingFile);
    }

    protected WorkingSetSettings(SettingsSection settings) {
        super(settings);
    }

    protected String composeToolOptionName(ToolID toolID, String option) {
        return toolID.name + "-" + option;
    }

    public RacerListManagementPolicy constructRacerListManagementPolicy() {
        return this.constructRacerListManagementPolicy(this.getRacerListManagementPolicySpec());
    }

    public RacerListManagementPolicy constructRacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        RacerListManagementPolicy managementPolicy;
        try {
            managementPolicy = policySpec.constructPolicy();
        }
        catch (PropagatedException ex) {
            throw new IllegalArgumentException("Unable to instantiate racer list management policy: " + policySpec);
        }
        return managementPolicy;
    }

    public PolicyID defaultRacerListManagementPolicy() {
        return RacerListManagementPolicy.getDefaultPolicy(this.getOrganizer());
    }

    public String getDescription() {
        return this.getStringValue(PROPERTY_DESCRIPTION);
    }

    public RaceOrganization getOrganizer() {
        String organizerName = this.getStringValueOrNull(PROPERTY_ORGANIZER);
        RaceOrganization organizer = RaceOrganization.getConstant(organizerName);
        return organizer != null ? organizer : RaceOrganization.UNKNOWN;
    }

    public WorldCupPointsFactory getPointsFactory() {
        return WorldCupPoints.getFactory(this.getWorldCupPointsType());
    }

    public WorldCupPointsType getWorldCupPointsType() {
        String scoringType = this.getStringValueOrNull(PROPERTY_WORLD_CUP_POINTS);
        if (scoringType == null) {
            scoringType = RaceDataIOServices.worldCupPointsTypeToLiteral(DEFAULT_WORLD_CUP_POINTS);
            this.getSettings().setStringValue(PROPERTY_WORLD_CUP_POINTS, scoringType);
        }
        return WorldCupPointsType.forFormula(scoringType);
    }

    public Class<? extends RaceClass<?>> getRaceClassClass() {
        return this.raceClassClass;
    }

    public PolicyID getRacerListManagementPolicy() {
        return this.getRacerListPolicyID(PROPERTY_RACER_LIST_MANAGEMENT_POLICY, "RacerListManagementPolicy", this.defaultRacerListManagementPolicy());
    }

    public PolicyID getRacerListMergePolicy() {
        return this.getRacerListPolicyID(PROPERTY_RACER_LIST_MERGE_POLICY, RACER_LIST_MERGE_POLICY_NAME_SUFFIX, DEFAULT_RACER_LIST_MERGE_POLICY);
    }

    protected PolicyID getRacerListPolicyID(String propertyName, String suffix, PolicyID defaultPolicy) {
        String policyName = this.getRacerListSettings().getStringValue(propertyName, null);
        if (policyName == null) {
            return defaultPolicy;
        }
        PolicyID policyID = PolicyID.getConstant(policyName + suffix);
        if (policyID == null) {
            DebugSupport.current().dump("***ERROR: unable to resolve working set racer list policy '" + policyName + "'");
            return defaultPolicy;
        }
        return policyID;
    }

    public RacerListManagementPolicySpecification getRacerListManagementPolicySpec() {
        return this.getRacerListManagementPolicySpec(this.getRacerListManagementPolicy());
    }

    public RacerListManagementPolicySpecification getRacerListManagementPolicySpec(PolicyID policyID) {
        RacerListManagementPolicySpecification policySpec = RacerListManagementPolicy.getDefaultPolicySpec(policyID);
        if (PBARacerListManagementPolicy.isSupportedPolicy(policySpec.policyID)) {
            SettingsSection racerListSettings = this.getRacerListSettings();
            policySpec = policySpec.copy();
            ParameterSpecification parmSpec = policySpec.getParameterSpecification("bibAllocationOrganization");
            if (parmSpec.modifiable) {
                String organizationName = null;
                if (racerListSettings != null) {
                    organizationName = racerListSettings.getStringValue(PROPERTY_RACER_LIST_MANAGEMENT_ORGANIZATION, null);
                }
                if (organizationName == null) {
                    organizationName = this.getOrganizer().name;
                }
                parmSpec.value = organizationName;
            }
            if (racerListSettings != null) {
                String pbSpecString = racerListSettings.getStringValue(PROPERTY_RACER_LIST_MANAGEMENT_PERMANENT_BIBS_RANGE, null);
                String stbSpecString = racerListSettings.getStringValue(PROPERTY_RACER_LIST_MANAGEMENT_SERIES_TEMP_BIB_RANGE, null);
                if (pbSpecString != null) {
                    parmSpec = policySpec.getParameterSpecification("permanentBibsRange");
                    parmSpec.value = pbSpecString;
                }
                if (stbSpecString != null) {
                    parmSpec = policySpec.getParameterSpecification("seriesTempBibsRange");
                    parmSpec.value = stbSpecString;
                }
            }
        } else if (policySpec.policyID == SeriesRacerListManagementPolicy.POLICY_ID) {
            policySpec = policySpec.copy();
            ParameterSpecification parmSpec = policySpec.getParameterSpecification("seriesOrganizer");
            parmSpec.value = this.getOrganizer().name;
        }
        return policySpec;
    }

    public SettingsSection getRacerListSettings() {
        return this.findOrCreateSection(SECTION_RACER_LIST_SETTINGS);
    }

    public RaceDataReportOptions getReportSettings() {
        if (this.reportOptions == null) {
            SettingsSection settings = this.getSettingsSection().getSection(SECTION_REPORT_SETTINGS);
            this.reportOptions = settings == null ? RaceDataReportOptions.defaultSettings() : new RaceDataReportOptions(settings);
        }
        return this.reportOptions;
    }

    public SettingsSection getSeasonSettings() {
        return this.getSettingsSection().getSection(SECTION_SEASON_SETTINGS);
    }

    public int getSeasonScoringAbilityBonusAgeClassScore() {
        return this.getSeasonScoringAbilityBonusAgeClassScore(20);
    }

    public int getSeasonScoringAbilityBonusAgeClassScore(int defaultValue) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            return defaultValue;
        }
        return seasonSettings.getIntValue(PROPERTY_SEASON_SCORING_ABILITY_BONUS_AGE_CLASS_SCORE, defaultValue);
    }

    public boolean getSeasonScoringAbilityBonusIncludeAbilityClasses() {
        return this.getSeasonScoringAbilityBonusIncludeAbilityClasses(true);
    }

    public boolean getSeasonScoringAbilityBonusIncludeAbilityClasses(boolean defaultValue) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            return defaultValue;
        }
        return seasonSettings.getBooleanValue(PROPERTY_SEASON_SCORING_ABILITY_BONUS_INCLUDE_ABILITY_CLASSES, defaultValue);
    }

    public boolean getSeasonScoringAllowGenderStandingsHACK() {
        return this.getSeasonScoringAllowGenderStandingsHACK(false);
    }

    public boolean getSeasonScoringAllowGenderStandingsHACK(boolean defaultValue) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            return defaultValue;
        }
        return seasonSettings.getBooleanValue(PROPERTY_SEASON_SCORING_ALLOW_GENDER_STANDINGS_HACK, defaultValue);
    }

    public int getSeasonScoringBestNDisciplineFinishesCount() {
        return this.getSeasonScoringBestNDisciplineFinishesCount(Integer.MAX_VALUE);
    }

    public int getSeasonScoringBestNDisciplineFinishesCount(int defaultValue) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            return defaultValue;
        }
        return seasonSettings.getIntValue(PROPERTY_SEASON_SCORING_BEST_N_DISCIPINE_COUNT, defaultValue);
    }

    public int getSeasonScoringBestNFinishesCount() {
        return this.getSeasonScoringBestNFinishesCount(Integer.MAX_VALUE);
    }

    public int getSeasonScoringBestNFinishesCount(int defaultValue) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            return defaultValue;
        }
        return seasonSettings.getIntValue(PROPERTY_SEASON_SCORING_BEST_N_COUNT, defaultValue);
    }

    public SeasonIdentifier getSeason() {
        return this.season;
    }

    public CourseArrangement getStandardCourseArrangement() {
        String name = this.getStringValueOrNull(PROPERTY_STANDARD_COURSE_ARRANGEMENT);
        return name == null ? CourseArrangement.UNKNOWN : CourseArrangement.getConstant(name);
    }

    public File getTimingSystemFilesSourceDirectory() {
        String fsReference = this.getSettings().getStringValue(PROPERTY_TIMING_DATA_FILES_SOURCE_DIRECTORY, DEFAULT_TIMING_DATA_FILES_SOURCE_DIRECTORY);
        return SettingsHolder.resolveDirectoryReference(fsReference, this.fileSystemReferenceDirectory(), false);
    }

    public String getToolOption(ToolID toolID, String option) {
        return this.getToolOptions().getStringValue(this.composeToolOptionName(toolID, option));
    }

    public String getToolOption(ToolID toolID, String option, String defaultValue) {
        return this.getToolOptions().getStringValue(this.composeToolOptionName(toolID, option), defaultValue);
    }

    protected SettingsSection getToolOptions() {
        if (this.toolOptions == null) {
            this.toolOptions = this.findOrCreateSection(SECTION_TOOL_OPTIONS);
        }
        return this.toolOptions;
    }

    public StandingsType getType() {
        return this.type;
    }

    protected SettingsSection initSeasonSettings() {
        SettingsSection seasonSettings = this.constructSettings(SECTION_SEASON_SETTINGS);
        this.getSettingsSection().addSection(seasonSettings);
        return seasonSettings;
    }

    public boolean isSeasonScoringSeries() {
        return this.getType() == StandingsType.SEASON;
    }

    public void prepareDefaultSettings() {
        this.setSeason(SeasonIdentifier.CURRENT);
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.type = StandingsType.getConstant(this.getStringValue(PROPERTY_TYPE).trim());
        String seasonLiteral = this.getStringValueOrNull(PROPERTY_SEASON);
        if (seasonLiteral != null) {
            try {
                this.season = RaceDataIOServices.seasonFromLiteral(seasonLiteral);
            }
            catch (RaceDataIOException ex) {
                ex.printStackTrace();
                this.season = SeasonIdentifier.UNKNOWN;
            }
        } else {
            SettingsSection seasonSettings = this.getSeasonSettings();
            if (seasonSettings != null) {
                int seasonStartYear = seasonSettings.getIntValue(PROPERTY_SEASON_START_YEAR, -1);
                if (seasonStartYear != -1) {
                    SeasonIdentifier originalSeason = SeasonIdentifier.forStartYear(seasonStartYear);
                    if (originalSeason == null) {
                        throw new RuntimeException(String.format("Invalid seasonStartYear '%s' in %s", seasonStartYear, this.backingFile.getAbsolutePath()));
                    }
                    this.setSeason(originalSeason);
                    seasonSettings.removeValue(PROPERTY_SEASON_START_YEAR);
                } else {
                    this.setSeason(SeasonIdentifier.CURRENT);
                }
            }
        }
        if (!this.getSettings().containsSetting(PROPERTY_WORLD_CUP_POINTS)) {
            WorldCupPointsType defaultScoringType = DEFAULT_WORLD_CUP_POINTS;
            int seasonYear = this.getSeason().getSeasonYear();
            if (seasonYear >= 2016 && this.getOrganizer() == RaceOrganization.FAR_WEST) {
                defaultScoringType = DEFAULT_WORLD_CUP_POINTS_FW_2016;
            }
            this.getSettings().setStringValue(PROPERTY_WORLD_CUP_POINTS, RaceDataIOServices.worldCupPointsTypeToLiteral(defaultScoringType));
        }
        this.raceClassClass = RaceDataIOServices.raceClassFromLiteral(this.getStringValue(PROPERTY_RACE_CLASS).trim(), this.getSeason());
    }

    public void setDescription(String description) {
        this.getSettings().setStringValue(PROPERTY_DESCRIPTION, description);
    }

    public void setOrganizer(RaceOrganization organizer) {
        this.getSettings().setStringValue(PROPERTY_ORGANIZER, organizer.name);
    }

    public void setRaceClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        if (!ClassX.isProperSubclass(raceClassClass, RaceClass.class)) {
            throw new IllegalArgumentException("Invalid race class type: " + raceClassClass);
        }
        this.raceClassClass = raceClassClass;
        this.getSettings().setStringValue(PROPERTY_RACE_CLASS, RaceDataIOServices.raceClassToLiteral(raceClassClass));
    }

    public void setRacerListManagementPolicy(PolicyID policyID) {
        this.setRacerListPolicy(PROPERTY_RACER_LIST_MANAGEMENT_POLICY, policyID, "RacerListManagementPolicy");
    }

    public void setRacerListManagementPolicy(RacerListManagementPolicySpecification policySpec) {
        SettingsSection racerListSettings = this.getRacerListSettings();
        this.setRacerListManagementPolicy(policySpec.policyID);
        if (PBARacerListManagementPolicy.isSupportedPolicy(policySpec.policyID)) {
            ParameterSpecification parmSpec = policySpec.getParameterSpecification("bibAllocationOrganization");
            if (parmSpec.modifiable) {
                racerListSettings.setStringValue(PROPERTY_RACER_LIST_MANAGEMENT_ORGANIZATION, (String)parmSpec.value);
            }
            parmSpec = policySpec.getParameterSpecification("permanentBibsRange");
            racerListSettings.setStringValue(PROPERTY_RACER_LIST_MANAGEMENT_PERMANENT_BIBS_RANGE, (String)parmSpec.value);
            parmSpec = policySpec.getParameterSpecification("seriesTempBibsRange");
            racerListSettings.setStringValue(PROPERTY_RACER_LIST_MANAGEMENT_SERIES_TEMP_BIB_RANGE, (String)parmSpec.value);
        } else {
            racerListSettings.removeValue(PROPERTY_RACER_LIST_MANAGEMENT_ORGANIZATION);
            racerListSettings.removeValue(PROPERTY_RACER_LIST_MANAGEMENT_PERMANENT_BIBS_RANGE);
            racerListSettings.removeValue(PROPERTY_RACER_LIST_MANAGEMENT_SERIES_TEMP_BIB_RANGE);
        }
    }

    public void setRacerListMergePolicy(PolicyID policyID) {
        this.setRacerListPolicy(PROPERTY_RACER_LIST_MERGE_POLICY, policyID, RACER_LIST_MERGE_POLICY_NAME_SUFFIX);
    }

    protected void setRacerListPolicy(String propertyName, PolicyID policyID, String suffix) {
        String policyName = policyID.name;
        policyName = policyName.substring(0, policyName.length() - suffix.length());
        this.getRacerListSettings().setStringValue(propertyName, policyName);
    }

    public void setSeason(SeasonIdentifier season) {
        this.getSettings().setStringValue(PROPERTY_SEASON, RaceDataIOServices.seasonToLiteral(season));
        this.season = season;
    }

    public void setSeasonScoringAbilityBonusAgeClassScore(int value) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            seasonSettings = this.initSeasonSettings();
        }
        seasonSettings.setIntValue(PROPERTY_SEASON_SCORING_ABILITY_BONUS_AGE_CLASS_SCORE, value);
    }

    public void setSeasonScoringAbilityBonusIncludeAbilityClasses(boolean value) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            seasonSettings = this.initSeasonSettings();
        }
        seasonSettings.setBooleanValue(PROPERTY_SEASON_SCORING_ABILITY_BONUS_INCLUDE_ABILITY_CLASSES, value);
    }

    public void setSeasonScoringBestNFinishesCount(int value) {
        SettingsSection seasonSettings = this.getSeasonSettings();
        if (seasonSettings == null) {
            seasonSettings = this.initSeasonSettings();
        }
        seasonSettings.setIntValue(PROPERTY_SEASON_SCORING_BEST_N_COUNT, value);
    }

    public void setStandardCourseArrangement(CourseArrangement standardCourseArrangement) {
        this.getSettings().setStringValue(PROPERTY_STANDARD_COURSE_ARRANGEMENT, standardCourseArrangement.name);
    }

    public void setToolOption(ToolID toolID, String option, String value) {
        this.getToolOptions().setStringValue(this.composeToolOptionName(toolID, option), value);
    }

    public void setType(StandingsType standingsType) {
        this.type = standingsType;
        this.getSettings().setStringValue(PROPERTY_TYPE, standingsType.name);
    }

    public void setWorldCupPointsType(WorldCupPointsType scoringType) {
        this.getSettings().setStringValue(PROPERTY_WORLD_CUP_POINTS, RaceDataIOServices.worldCupPointsTypeToLiteral(scoringType));
    }

    static {
        WorkingSetSettings.initStaticData();
    }
}

