/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.awt.Window;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.RaceDataDialog;
import org.ussamasters.aces.tools.ui.RaceIdentifierModel;

public class EditRaceIdentifierDialog
extends RaceDataDialog {
    public static final String QUALIFIER_COMPONENT_SPECIAL_CHARS = "-_(){}";
    public static final String PROPERTY_QUALIFIER = "qualifier";
    private static final String DIALOG_TITLE_EDIT = "Edit Race";
    private static final String DIALOG_TITLE_NEW = "New Race";
    protected final SeasonIdentifier season;
    protected RaceIdentifier newRaceID;
    protected RaceIdentifier raceID;
    protected RaceSeries raceSeries;
    protected RaceIdentifierModel raceIdentifierModel;

    public static RaceIdentifier openFor(RaceSeries raceSeries, Window aWindow) {
        EditRaceIdentifierDialog aDialog = new EditRaceIdentifierDialog(raceSeries.getSeason(), null, raceSeries, aWindow);
        aDialog.openWindow();
        return aDialog.getNewRaceIdentifier();
    }

    public static RaceIdentifier openOn(RaceIdentifier raceID, RaceSeries raceSeries, Window aWindow) {
        EditRaceIdentifierDialog aDialog = new EditRaceIdentifierDialog(raceID.getSeason(), raceID, raceSeries, aWindow);
        aDialog.openWindow();
        return aDialog.getNewRaceIdentifier();
    }

    public EditRaceIdentifierDialog(SeasonIdentifier season, RaceIdentifier raceID, RaceSeries raceSeries, Window aWindow) {
        this.season = season;
        this.raceID = raceID;
        this.raceSeries = raceSeries;
        this.initializeModels();
    }

    public void acceptChanges() {
        this.newRaceID = this.getRaceIdentifierModel().getRace();
    }

    @Override
    public void clearResult() {
        this.newRaceID = null;
    }

    public RaceIdentifier getNewRaceIdentifier() {
        return this.newRaceID;
    }

    public RaceIdentifierModel getRaceIdentifierModel() {
        return this.raceIdentifierModel;
    }

    public String getTitle() {
        return this.raceID == null ? DIALOG_TITLE_NEW : DIALOG_TITLE_EDIT;
    }

    public boolean hasChanges() {
        return this.raceID == null || !this.getRaceIdentifierModel().getRace().equals(this.raceID);
    }

    protected void initializeModels() {
        this.raceIdentifierModel = new RaceIdentifierModel(this.raceID == null ? RaceIdentifierModel.newRaceIdentifier(this.season) : this.raceID, true);
    }

    public ValidationResult validateChanges(ValidationResolver validationResolver) {
        String qualifier;
        String invalidChar;
        ValidationResult validationResult = new ValidationResult();
        RaceIdentifier newID = this.getRaceIdentifierModel().getRace();
        RaceDate newRaceDate = newID.getDate();
        RaceDate seasonStartDate = this.raceSeries.getSeason().getStartDate();
        RaceDate seasonEndDate = this.raceSeries.getSeason().getEndDate();
        if (newRaceDate.isBefore(seasonStartDate)) {
            validationResult.reportProblem("Race date may not be defined prior to the start of the race series season (" + seasonStartDate + ")");
            return validationResult;
        }
        if (newRaceDate.isAfter(seasonEndDate)) {
            validationResult.reportProblem("Race date may not be defined after the end of the race series season (" + seasonEndDate + ")");
            return validationResult;
        }
        if (this.raceSeries.contains(newID)) {
            validationResult.reportProblem("The race series already contains this race.");
            return validationResult;
        }
        if (newID.hasQualifier() && (invalidChar = this.validateFileNameComponent(qualifier = newID.getQualifier(), QUALIFIER_COMPONENT_SPECIAL_CHARS)) != null) {
            validationResult.reportProblem(PROPERTY_QUALIFIER, "The qualifier name you have specified for storing the race data is not valid - please remove the special character '" + invalidChar + "' (may cause problems when used in report file names).");
            return validationResult;
        }
        return validationResult;
    }
}

