/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.NoArgumentBlock;
import com.glaivestone.javax.io.FileType;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.BooleanHolder;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.io.CombinedResultTSVWriter;
import org.ussamasters.aces.racedata.io.DivisionsCupCSVWriter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.TripleCombinedCSVWriter;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.scoring.BernardCupScoringPolicy;
import org.ussamasters.aces.racedata.scoring.BestNFinishesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.DivisionsCup80ScoringPolicy;
import org.ussamasters.aces.racedata.scoring.DivisionsCupScoringPolicy;
import org.ussamasters.aces.racedata.scoring.DivisionsCupStandings;
import org.ussamasters.aces.racedata.scoring.EventStandings;
import org.ussamasters.aces.racedata.scoring.MedalCountsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.MedalCountsStandings;
import org.ussamasters.aces.racedata.scoring.MustFinishAllRacesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicyRegistry;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SiseCupScoringPolicy;
import org.ussamasters.aces.racedata.scoring.SiseCupStandings;
import org.ussamasters.aces.racedata.scoring.SportAgeScoringPolicy;
import org.ussamasters.aces.racedata.scoring.StandardSeriesScoringPolicy;
import org.ussamasters.aces.tools.foundation.models.EventScoringRaceSeries;
import org.ussamasters.aces.tools.foundation.models.EventScoringSpecification;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.SeriesScoringTool;

public class EventScoringTool
extends SeriesScoringTool {
    public static final ToolID TOOL_ID = new ToolID("EventScoringTool");
    public static final String SCORING_POLICY_CATEGORY = "EventScoring";
    public static final PolicyID SCORING_POLICY_WC_POINTS_COMBINED_ANY_STARTS_COUNT;
    public static final PolicyID SCORING_POLICY_WC_POINTS_COMBINED_MUST_START_ALL;
    public static final PolicyID SCORING_POLICY_WC_POINTS_COMBINED_MUST_FINISH_ALL;
    public static final PolicyID SCORING_POLICY_WC_POINTS_BEST_N_FINISHES;
    public static final PolicyID SCORING_POLICY_RACE_POINTS_COMBINED;
    public static final PolicyID SCORING_POLICY_TOTAL_TIME_COMBINED;
    public static final PolicyID SCORING_POLICY_BERNARD_CUP;
    public static final PolicyID SCORING_POLICY_SPORT_AGE;
    public static final PolicyID SCORING_POLICY_SISE_CUP;
    public static final PolicyID SCORING_POLICY_DIVISIONS_CUP;
    public static final PolicyID SCORING_POLICY_DIVISIONS_CUP_80;
    public static final PolicyID SCORING_POLICY_MEDAL_COUNTS;
    protected static final List<PolicyID> BEST_N_FINISHES_SCORING_POLICIES;
    public static final int DEFAULT_BEST_N_FINISHES_COUNT = 3;
    public static final int DEFAULT_SISE_CUP_FINISHES_COUNT = 10;
    protected static boolean generateHTMLReportsDefault;
    protected static boolean generateTextReportsDefault;
    protected static boolean generatePdfReportsDefault;
    private static final Class<EventScoringTool> THIS_CLASS;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION;
    protected static final StandingsOrganizationType[] SUPPORTED_ORGANIZATION_TYPES;
    protected static final ScoringPolicyRegistry scoringPolicyRegistry;
    protected static String APPLICATION_TITLE;
    protected static final String LAST_SELECTED_EVENT_TOOL_OPTION = "selectedEvent";
    protected String originalEventSelection;
    protected DefaultComboBoxModel<String> scoringEventNamesHolder;

    protected static StandingsOrganizationType[] constructSupportedOrganizationTypes() {
        List<StandingsOrganizationType> stdOrgs = EventStandings.STANDARD_ORGANIZATION_TYPES;
        int nStdOrgs = stdOrgs.size();
        StandingsOrganizationType[] orgTypes = new StandingsOrganizationType[nStdOrgs + 1];
        for (int i = 0; i < nStdOrgs; ++i) {
            StandingsOrganizationType standingsOrganizationType = stdOrgs.get(i);
            orgTypes[i] = standingsOrganizationType != StandardOrganizationType.BY_ALL_RACERS ? standingsOrganizationType : StandardOrganizationType.BY_AFFILIATION;
        }
        orgTypes[nStdOrgs] = StandardOrganizationType.BY_ALL_RACERS;
        return orgTypes;
    }

    public static ApplicationView findOrOpen() {
        ApplicationView aWindow = EventScoringTool.findWindow(TOOL_ID);
        if (aWindow != null) {
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
        } else {
            aWindow = EventScoringTool.open();
        }
        return aWindow;
    }

    public static void installTool(ToolInfo toolInfo) {
        String displayName = toolInfo.getDisplayName();
        if (displayName != null) {
            APPLICATION_TITLE = displayName;
        }
        generateHTMLReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generateHTMLReports", generateHTMLReportsDefault);
        generateTextReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generateTextReports", generateTextReportsDefault);
        generatePdfReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generatePdfReports", generatePdfReportsDefault);
    }

    public static ApplicationView open() {
        return EventScoringTool.openToolWindow(TOOL_ID, TOOL_CONSTRUCTION_ACTION);
    }

    public EventScoringTool() throws RaceDataIOException {
        super(TOOL_ID, APPLICATION_TITLE, SUPPORTED_ORGANIZATION_TYPES, scoringPolicyRegistry);
    }

    public void addScoringEvent(EventScoringRaceSeries newEvent) throws RaceDataIOException {
        String newEventName = newEvent.getName();
        this.getEventNamesHolder().addElement(newEventName);
    }

    @Override
    public void addRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getSessionManager().addEventScoringRace(this.getSelectedEventName(), raceID);
    }

    protected void clearEventScoringStuff() {
    }

    protected EventScoringRaceSeries constructBackstopScoringEvent() {
        return EventScoringRaceSeries.createEmptySeries("UNKNOWN", "Unknown", this.getSessionManager().getSeason(), this.getSessionManager().getRaceCalendar().getRaceClassClass(), WorkingSetSettings.getCurrent().getWorldCupPointsType());
    }

    protected DefaultComboBoxModel<String> constructScoringEventNamesHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(this.getSessionManager().getScoringEventNames());
    }

    @Override
    protected SeriesStandings createStandings(StandingsOrganizationType organizationType, ScoringPolicySpecification policySpec) {
        if (policySpec.policyID == SCORING_POLICY_MEDAL_COUNTS) {
            if (organizationType != StandardOrganizationType.BY_AFFILIATION) {
                return null;
            }
            return MedalCountsStandings.computeStandings(this.getEventScoringRaces().getShortName(), this.getRaceSeries(), this.getSessionManager().getRacerList());
        }
        if (policySpec.policyID == SCORING_POLICY_DIVISIONS_CUP) {
            if (organizationType != StandardOrganizationType.BY_AFFILIATION) {
                return null;
            }
            return DivisionsCupStandings.computeStandings(this.getEventScoringRaces().getShortName(), this.getRaceSeries(), this.getSessionManager().getRacerList());
        }
        if (policySpec.policyID == SCORING_POLICY_DIVISIONS_CUP_80) {
            if (organizationType != StandardOrganizationType.BY_AFFILIATION) {
                return null;
            }
            return DivisionsCupStandings.computeStandings80(this.getEventScoringRaces().getShortName(), this.getRaceSeries(), this.getSessionManager().getRacerList());
        }
        if (organizationType == StandardOrganizationType.BY_AFFILIATION) {
            return null;
        }
        if (policySpec.policyID == SCORING_POLICY_BERNARD_CUP && organizationType != StandardOrganizationType.BY_GENDER) {
            return null;
        }
        if (policySpec.policyID == SCORING_POLICY_SISE_CUP) {
            if (organizationType != StandardOrganizationType.BY_CLASS) {
                return null;
            }
            SiseCupStandings standings = SiseCupStandings.forRaceSeries(this.getEventScoringRaces().getShortName(), this.getRaceSeries(), this.getSessionManager().getRacerList());
            standings.computeStandings(this.getScoringPolicy(policySpec));
            return standings;
        }
        if (!EventStandings.isSupportedOrganization(organizationType, this.getRaceSeries())) {
            return null;
        }
        EventStandings standings = (EventStandings)EventStandings.forRaceSeries(this.getEventScoringRaces().getShortName(), this.getRaceSeries(), this.getSessionManager().getRacerList(), organizationType);
        standings.computeStandings(this.getScoringPolicy(policySpec));
        return standings;
    }

    public void deleteScoringEvent(String eventName) {
        this.getEventNamesHolder().removeElement(eventName);
        this.getSessionManager().deleteScoringEvent(eventName);
    }

    @Override
    public int generateStandingsReports(ScoringPolicySpecification policySpec) throws RaceDataIOException {
        int nReportsGenerated;
        EventStandings.allowGenderStandingsHACK = this.getEventSpecification().getAllowGenderStandingsHACK();
        try {
            nReportsGenerated = super.generateStandingsReports(policySpec);
        }
        finally {
            EventStandings.allowGenderStandingsHACK = false;
        }
        return nReportsGenerated;
    }

    public String getEventDescription() {
        return this.getRaceSeries() != null ? this.getEventScoringRaces().getDescription() : "";
    }

    public DefaultComboBoxModel<String> getEventNamesHolder() {
        return this.scoringEventNamesHolder;
    }

    protected EventScoringRaceSeries getEventScoringRaces() {
        return (EventScoringRaceSeries)this.getRaceSeries();
    }

    protected EventScoringRaceSeries getEventScoringRaces(String eventName) throws RaceDataIOException {
        EventScoringRaceSeries eventRaces = this.getSessionManager().getEventScoringRaces(eventName);
        if (eventRaces == null) {
            if (eventName != null) {
                throw new IllegalArgumentException("Should not be: no spec for scoring event '" + eventName + "'");
            }
            eventRaces = this.constructBackstopScoringEvent();
        }
        return eventRaces;
    }

    protected EventScoringSpecification getEventSpecification() {
        return (EventScoringSpecification)this.getEventScoringRaces().getSpecification();
    }

    @Override
    public File getReportsDirectory() {
        return this.getSessionManager().getEventReportsDirectory();
    }

    public String getSeasonName() {
        return this.getSessionManager().getRaceCalendar().getName();
    }

    public String getSelectedEventName() {
        return (String)this.scoringEventNamesHolder.getSelectedItem();
    }

    public File getSeriesDataDirectory() {
        return this.getSessionManager().getEventScoringDataDirectory();
    }

    @Override
    protected String getStandingsFileNamePrefix() {
        return EventStandings.rootReferenceName(this.getEventScoringRaces().getShortName());
    }

    @Override
    protected void initializeModels() {
        super.initializeModels();
        this.generateHTMLReportsHolder = new BooleanHolder(generateHTMLReportsDefault);
        this.generateTextReportsHolder = new BooleanHolder(generateTextReportsDefault);
        this.generatePdfReportsHolder = new BooleanHolder(generatePdfReportsDefault);
    }

    @Override
    protected void initializeWorkingSetDataModels() throws RaceDataIOException {
        EventScoringRaceSeries eventRaces;
        super.initializeWorkingSetDataModels();
        this.scoringEventNamesHolder = this.constructScoringEventNamesHolder();
        this.clearEventScoringStuff();
        String selectedEventName = this.getSessionManager().getToolOption(TOOL_ID, LAST_SELECTED_EVENT_TOOL_OPTION);
        if (selectedEventName != null && this.getEventNamesHolder().getIndexOf(selectedEventName) >= 0) {
            this.scoringEventNamesHolder.setSelectedItem(selectedEventName);
            this.originalEventSelection = selectedEventName;
        } else {
            selectedEventName = this.getSelectedEventName();
        }
        try {
            eventRaces = this.getEventScoringRaces(selectedEventName);
        }
        catch (RaceDataIOException ex) {
            ex.printStackTrace();
            System.out.println("****ERROR LOADING combined " + this.getSelectedEventName() + "***");
            System.out.println("Available combined specifications:");
            for (String eventName : this.getSessionManager().getScoringEventNames()) {
                System.out.println("'" + eventName + "'");
            }
            throw ex;
        }
        this.initRaceSeriesHolder(eventRaces);
        this.initScoringPolicySelection();
    }

    protected void initScoringPolicySelection() {
        String selectedPolicyName = this.getEventSpecification().getLastSelectedScoringPolicy();
        this.initScoringPolicySelection(selectedPolicyName);
    }

    @Override
    protected void loadScoringPolicyParms(ScoringPolicySpecification policySpec) {
        if (policySpec.hasConfigurableParameters()) {
            if (BEST_N_FINISHES_SCORING_POLICIES.contains(policySpec.policyID)) {
                String parmName = "maxFinishes";
                EventScoringSpecification scoringSpec = this.getEventSpecification();
                int bestNFinishesCount = scoringSpec.getBestNFinishesCount(3);
                policySpec.setParameter(parmName, bestNFinishesCount);
            } else if (policySpec.policyID == SCORING_POLICY_BERNARD_CUP) {
                String parmName = "formula";
                EventScoringSpecification scoringSpec = this.getEventSpecification();
                String formulaName = scoringSpec.getBernardCupFormula();
                if (formulaName != null) {
                    policySpec.setParameter(parmName, formulaName);
                }
            } else {
                throw new RuntimeException("OOPS: need to configure " + policySpec);
            }
        }
    }

    @Override
    public void removeRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getSessionManager().removeEventScoringRace(this.getSelectedEventName(), raceID);
    }

    @Override
    protected void saveScoringPolicyParms(ScoringPolicySpecification policySpec) {
        EventScoringSpecification scoringSpec = this.getEventSpecification();
        scoringSpec.setLastSelectedScoringPolicy(policySpec.getName());
        if (policySpec.hasConfigurableParameters()) {
            String parmName;
            if (BEST_N_FINISHES_SCORING_POLICIES.contains(policySpec.policyID)) {
                parmName = "maxFinishes";
                int maxRacesToCount = (Integer)policySpec.getParameter(parmName);
                scoringSpec.setBestNFinishesCount(maxRacesToCount);
            } else if (policySpec.policyID == SCORING_POLICY_BERNARD_CUP) {
                parmName = "formula";
                String formulaName = (String)policySpec.getParameter(parmName);
                if (!formulaName.equals("automatic")) {
                    scoringSpec.setBernardCupFormula(formulaName);
                }
            } else {
                throw new RuntimeException("OOPS: need to save policy config: " + policySpec);
            }
        }
        try {
            scoringSpec.saveSettings();
        }
        catch (IOException ex) {
            DebugSupport.current().dump("Unable to save event specification with scoring policy " + policySpec.getName() + " settings.");
            DebugSupport.current().dumpStack(ex);
        }
    }

    public void selectEvent(String selectedEventName) throws RaceDataIOException {
        this.clearEventScoringStuff();
        this.setRaceSeries(this.getEventScoringRaces(selectedEventName));
        this.initScoringPolicySelection();
    }

    public void setEventDescription(String description) throws IOException {
        if (this.getRaceSeries() == null) {
            return;
        }
        this.getEventScoringRaces().setDescription(description);
        this.getEventSpecification().saveSettings();
    }

    @Override
    protected void windowClosing(Window aWindow) {
        String selectedEventName = this.getSelectedEventName();
        if (selectedEventName != null && !selectedEventName.equals(this.originalEventSelection)) {
            this.getSessionManager().saveToolOption(TOOL_ID, LAST_SELECTED_EVENT_TOOL_OPTION, selectedEventName);
        }
        super.windowClosing(aWindow);
    }

    @Override
    protected void writeStandingsReports(SeriesStandings standings, List<FileType> reportTypes, boolean displayReports) throws RaceDataIOException {
        CombinedResultTSVWriter writer;
        super.writeStandingsReports(standings, reportTypes, displayReports);
        if (standings instanceof EventStandings && this.getEventScoringRaces().getEventSpecification().getGenerateByClassTSV() && (writer = TripleCombinedCSVWriter.forStandings(standings)) != null) {
            writer.writeFileIn(this.getReportsDirectory());
        }
        if (standings instanceof DivisionsCupStandings && this.getEventScoringRaces().getEventSpecification().getGenerateDivisionsCupTSV() && (writer = DivisionsCupCSVWriter.forStandings((DivisionsCupStandings)standings)) != null) {
            writer.writeFileIn(this.getReportsDirectory());
        }
    }

    public static void main(String[] args) {
        EventScoringTool.processCommandLineArgs(args);
        EventScoringTool.initiateSession();
        EventScoringTool.open();
    }

    static {
        generateHTMLReportsDefault = true;
        generateTextReportsDefault = false;
        generatePdfReportsDefault = false;
        THIS_CLASS = EventScoringTool.class;
        TOOL_CONSTRUCTION_ACTION = EventScoringTool.constructToolConstructionAction(THIS_CLASS);
        SUPPORTED_ORGANIZATION_TYPES = EventScoringTool.constructSupportedOrganizationTypes();
        APPLICATION_TITLE = "Event Scoring Tool";
        ScoringPolicyRegistry registry = new ScoringPolicyRegistry();
        SCORING_POLICY_WC_POINTS_COMBINED_ANY_STARTS_COUNT = PolicyID.defineConstant("WorldCupPointsCombined-AnyStartsCount", SCORING_POLICY_CATEGORY, "Total World Cup points (any finishes count; need not start all races to qualify in standings)");
        ScoringPolicySpecification spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_COMBINED_ANY_STARTS_COUNT, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES}, new NoArgumentBlock(THIS_CLASS, "ConstructScoringPolicy-" + EventScoringTool.SCORING_POLICY_WC_POINTS_COMBINED_ANY_STARTS_COUNT.name){

            @Override
            protected Object evaluateExpression() {
                return new StandardSeriesScoringPolicy(ScoringElement.POINTS, false, false){

                    @Override
                    public String name() {
                        return "WCPoints";
                    }
                };
            }
        }, "World Cup points total (any starts)", "WCPoints");
        registry.registerPolicy(spec);
        SCORING_POLICY_WC_POINTS_COMBINED_MUST_START_ALL = PolicyID.defineConstant("WorldCupPointsCombined-MustStartAll", SCORING_POLICY_CATEGORY, "Total World Cup points (any finishes count; must start all races to qualify in standings)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_COMBINED_MUST_START_ALL, new ParameterSpecification[]{ScoringPolicySpecification.MUST_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES}, new NoArgumentBlock(THIS_CLASS, "ConstructScoringPolicy-" + EventScoringTool.SCORING_POLICY_WC_POINTS_COMBINED_MUST_START_ALL.name){

            @Override
            protected Object evaluateExpression() {
                return new StandardSeriesScoringPolicy(ScoringElement.POINTS, true, false){

                    @Override
                    public String name() {
                        return "WCPointsMSAR";
                    }
                };
            }
        }, "World Cup points total (must start all)", "WCPointsMSAR");
        registry.registerPolicy(spec);
        SCORING_POLICY_WC_POINTS_COMBINED_MUST_FINISH_ALL = PolicyID.defineConstant("WorldCupPointsCombined-MustFinishAll", SCORING_POLICY_CATEGORY, "Total World Cup points (must finish all races to qualify in standings)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_COMBINED_MUST_FINISH_ALL, new ParameterSpecification[]{ScoringPolicySpecification.MUST_START_ALL_RACES, ScoringPolicySpecification.MUST_FINISH_ALL_RACES}, new NoArgumentBlock(THIS_CLASS, "ConstructScoringPolicy-" + EventScoringTool.SCORING_POLICY_WC_POINTS_COMBINED_MUST_FINISH_ALL.name){

            @Override
            protected Object evaluateExpression() {
                return new StandardSeriesScoringPolicy(ScoringElement.POINTS, true, true){

                    @Override
                    public String name() {
                        return "WCPointsMFAR";
                    }
                };
            }
        }, "World Cup points total (must finish all)", "WCPointsMFAR");
        registry.registerPolicy(spec);
        SCORING_POLICY_WC_POINTS_BEST_N_FINISHES = PolicyID.defineConstant("WorldCupPointsCombined-BestNFinishes", SCORING_POLICY_CATEGORY, "Total World Cup points (best N finishes count)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_BEST_N_FINISHES, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES, StandardSeriesScoringPolicy.createMaxFinishesParmSpec(3)}, ScoringPolicySpecification.createConstructionAction(BestNFinishesScoringPolicy.class, new Class[]{Integer.TYPE, ScoringElement.class}, new Object[]{new Integer(3), ScoringElement.POINTS}), "World Cup points total (best N finishes)", "BestNFinishes");
        registry.registerPolicy(spec);
        SCORING_POLICY_RACE_POINTS_COMBINED = PolicyID.defineConstant("RacePointsCombined", SCORING_POLICY_CATEGORY, "Total race points (must start and finish in all races to qualify in standings)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_RACE_POINTS_COMBINED, new ParameterSpecification[]{ScoringPolicySpecification.MUST_START_ALL_RACES, ScoringPolicySpecification.MUST_FINISH_ALL_RACES}, new NoArgumentBlock(THIS_CLASS, "ConstructScoringPolicy-" + EventScoringTool.SCORING_POLICY_RACE_POINTS_COMBINED.name){

            @Override
            protected Object evaluateExpression() {
                return new MustFinishAllRacesScoringPolicy(ScoringElement.RACE_POINTS){

                    @Override
                    public String name() {
                        return "RacePoints";
                    }
                };
            }
        }, "Race points total", "RacePoints");
        registry.registerPolicy(spec);
        SCORING_POLICY_TOTAL_TIME_COMBINED = PolicyID.defineConstant("TotalTimeCombined", SCORING_POLICY_CATEGORY, "Total time (must start and finish in all races to qualify in standings)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_TOTAL_TIME_COMBINED, new ParameterSpecification[]{ScoringPolicySpecification.MUST_START_ALL_RACES, ScoringPolicySpecification.MUST_FINISH_ALL_RACES}, new NoArgumentBlock(THIS_CLASS, "ConstructScoringPolicy-" + EventScoringTool.SCORING_POLICY_TOTAL_TIME_COMBINED.name){

            @Override
            protected Object evaluateExpression() {
                return new MustFinishAllRacesScoringPolicy(ScoringElement.TIME){

                    @Override
                    public String name() {
                        return "TotalTime";
                    }
                };
            }
        }, "Total time", "TotalTime");
        registry.registerPolicy(spec);
        SCORING_POLICY_BERNARD_CUP = PolicyID.defineConstant("BernardCup", SCORING_POLICY_CATEGORY, "Total age-adusted time (must start and finish in all races to qualify in standings)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_BERNARD_CUP, new ParameterSpecification[]{ScoringPolicySpecification.MUST_START_ALL_RACES, ScoringPolicySpecification.MUST_FINISH_ALL_RACES, BernardCupScoringPolicy.createFormulaParmSpec("automatic")}, ScoringPolicySpecification.createConstructionAction(BernardCupScoringPolicy.class), "Bernard Cup age handicapped total time", "BernardCup");
        registry.registerPolicy(spec);
        SCORING_POLICY_SPORT_AGE = PolicyID.defineConstant("SportAge", SCORING_POLICY_CATEGORY, "Total age-gender-discipline-adusted time (must start and finish in all races to qualify in standings)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_SPORT_AGE, new ParameterSpecification[]{ScoringPolicySpecification.MUST_START_ALL_RACES, ScoringPolicySpecification.MUST_FINISH_ALL_RACES}, ScoringPolicySpecification.createConstructionAction(SportAgeScoringPolicy.class), "SportAge age-gender-discipline handicapped total time", "SportAge");
        registry.registerPolicy(spec);
        SCORING_POLICY_SISE_CUP = PolicyID.defineConstant("SiseCup", SCORING_POLICY_CATEGORY, "Total Sise Cup points");
        spec = new ScoringPolicySpecification(SCORING_POLICY_SISE_CUP, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES, StandardSeriesScoringPolicy.createMaxFinishesParmSpec(10)}, ScoringPolicySpecification.createConstructionAction(SiseCupScoringPolicy.class, new Class[]{Integer.TYPE}, new Object[]{new Integer(10)}), "Sise Cup points total (best N finishes)", "SiseCup");
        registry.registerPolicy(spec);
        SCORING_POLICY_DIVISIONS_CUP = PolicyID.defineConstant("DivisionsCup", SCORING_POLICY_CATEGORY, "Division's Cup best-results-per-total-starts scoring");
        spec = new ScoringPolicySpecification(SCORING_POLICY_DIVISIONS_CUP, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES}, ScoringPolicySpecification.createConstructionAction(DivisionsCupScoringPolicy.class), "Divisions Cup", "DivisionsCup");
        registry.registerPolicy(spec);
        SCORING_POLICY_DIVISIONS_CUP_80 = PolicyID.defineConstant("DivisionsCup80", SCORING_POLICY_CATEGORY, "Division's Cup best-results-per-total-starts scoring (best 80%)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_DIVISIONS_CUP_80, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES}, ScoringPolicySpecification.createConstructionAction(DivisionsCup80ScoringPolicy.class), "Divisions Cup (best 80%)", "DivisionsCup80");
        registry.registerPolicy(spec);
        SCORING_POLICY_MEDAL_COUNTS = PolicyID.defineConstant("MedalCounts", SCORING_POLICY_CATEGORY, "Event medal counts");
        spec = new ScoringPolicySpecification(SCORING_POLICY_MEDAL_COUNTS, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES}, ScoringPolicySpecification.createConstructionAction(MedalCountsScoringPolicy.class), "Medal Counts", "MedalCounts");
        registry.registerPolicy(spec);
        scoringPolicyRegistry = registry;
        BEST_N_FINISHES_SCORING_POLICIES = Arrays.asList(SCORING_POLICY_WC_POINTS_BEST_N_FINISHES, SCORING_POLICY_SISE_CUP);
    }
}

