/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.tools.foundation.processors.ValidationResolver;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.RaceCalendarTableHolder;
import org.ussamasters.aces.tools.ui.RaceDataDialog;
import org.ussamasters.aces.tools.ui.RaceSpecificationModel;

public class MergeRacesDialog
extends RaceDataDialog {
    protected RaceSeries racesList;
    protected RaceIdentifier mergedRaceID;
    protected RaceResult mergedResult;
    protected RaceSpecificationModel raceSpecificationModel;
    protected RaceCalendarTableHolder racesListHolder;

    public static RaceResult openOn(RaceSeries racesList, RaceIdentifier splitRaceID, Window aWindow) {
        MergeRacesDialog aDialog = new MergeRacesDialog(racesList, splitRaceID, aWindow);
        aDialog.openWindow();
        return aDialog.getMergedRace();
    }

    public MergeRacesDialog(RaceSeries racesList, RaceIdentifier mergedRaceID, Window aWindow) {
        super(aWindow);
        this.racesList = racesList;
        this.mergedRaceID = mergedRaceID;
        this.initializeModels();
    }

    public void acceptResult() {
    }

    @Override
    public void clearResult() {
        this.mergedResult = null;
    }

    protected RaceResult constructMergedResult(RaceDescriptor mergedRaceSpec, List<RacerResult> racerResultsList) {
        RaceResult aRaceResult = new RaceResult(mergedRaceSpec, racerResultsList);
        return RaceStandings.computeCanonicalStandings(aRaceResult);
    }

    public RaceResult getMergedRace() {
        return this.mergedResult;
    }

    public RaceSpecificationModel getRaceSpecificationModel() {
        return this.raceSpecificationModel;
    }

    public RaceCalendarTableHolder getRacesListHolder() {
        return this.racesListHolder;
    }

    protected void initializeModels() {
        this.raceSpecificationModel = new RaceSpecificationModel(this.mergedRaceID);
        this.racesListHolder = new RaceCalendarTableHolder(this.racesList);
        this.racesListHolder.getSelectionModel().setSelectionMode(2);
    }

    public ValidationResult validateResult(ValidationResolver validationResolver) {
        String msg;
        String propertyName;
        ValidationResult validationResult = new ValidationResult();
        RaceDescriptor mergedRaceSpec = this.raceSpecificationModel.getRaceSpecification();
        Class<? extends RaceClass<?>> raceClassClass = mergedRaceSpec.getRaceClassClass();
        CourseArrangement courseArrangement = mergedRaceSpec.getCourseArrangement();
        List<RaceIdentifier> selectedRaces = this.getRacesListHolder().getSelectedRaces();
        ArrayList<RacerResult> resultsList = new ArrayList<RacerResult>();
        if (selectedRaces.size() == 0) {
            validationResult.reportProblem("No races have been selected.");
            return validationResult;
        }
        if (selectedRaces.size() == 1) {
            validationResult.reportProblem("You must select at least two races for a merge operation.");
            return validationResult;
        }
        HashMap<String, NamedRacerResult> bibsTable = new HashMap<String, NamedRacerResult>();
        for (RaceIdentifier aRaceID : selectedRaces) {
            RaceResult aRaceResult = this.getSessionManager().getRaceResult(aRaceID);
            if (!aRaceResult.getRaceClassClass().equals(raceClassClass)) {
                validationResult.reportProblem("Cannot merge " + aRaceID.toDescriptionString() + " into " + this.mergedRaceID.toDescriptionString() + " - race classes are not the same.");
                return validationResult;
            }
            for (RacerResult rr : aRaceResult.getRacerResults()) {
                NamedRacerResult aRacerResult = (NamedRacerResult)rr;
                String bib = aRacerResult.getBib();
                NamedRacerResult anotherRacerResult = (NamedRacerResult)bibsTable.get(bib);
                if (anotherRacerResult != null) {
                    if (anotherRacerResult.getName().equals(aRacerResult.getName())) {
                        validationResult.reportProblem("Racer " + aRacerResult.getFirstName() + " " + aRacerResult.getLastName() + " is in more than one of the races being merged - this is not right!!");
                    } else {
                        validationResult.reportProblem("Bib number " + bib + " of racer " + aRacerResult.getFirstName() + " " + aRacerResult.getLastName() + " has already been used by " + anotherRacerResult.getFirstName() + " " + anotherRacerResult.getLastName() + " in another of the races being merged.  This is not allowed, bib numbers must be unique.");
                    }
                    return validationResult;
                }
                bibsTable.put(bib, aRacerResult);
                resultsList.add(aRacerResult);
            }
        }
        if (courseArrangement == CourseArrangement.UNKNOWN) {
            validationResult.reportProblem("You need to specify the arrangement of the courses for the set of races being merged.");
            return validationResult;
        }
        if (courseArrangement == CourseArrangement.SINGLE_COURSE && !validationResolver.confirm(propertyName = "courseArrangement", msg = "You have specified that all racers in the set of races being merged completed on the same course.\n\nThis is not ordinarily so when merging multiple races, is that really what you meant?!")) {
            validationResult.reportProblem(propertyName, "The course arrangement you have specified is fishy.");
            return validationResult;
        }
        this.mergedResult = this.constructMergedResult(mergedRaceSpec, resultsList);
        return ValidationResult.SUCCESS_RESULT;
    }
}

