/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import org.ussamasters.aces.racedata.io.RaceDataNormalizationServices;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.ui.RacerListReconciliationResult;

public class RaceCompetitorsReconcilationResult
extends RacerListReconciliationResult {
    protected static final int RACE_CLASS_SAME_AS_SERIES_CLASS = 0;
    protected static final int MAP_NATIONAL_AGE_CLASS_TO_DIVISION_CLASS = 1;
    protected static final int MAP_DIVISION_CLASS_TO_NATIONAL_CLASS = 2;
    protected RacerList raceCompetitorsList;
    protected Class<? extends RaceClass<?>> seriesAgeClassClass;
    protected int ageClassMappingCode = -1;

    public static RaceCompetitorsReconcilationResult reconcileCompetitors(RacerList raceCompetitorsList, ToolSessionRacerList racerList) {
        RaceCompetitorsReconcilationResult reconciliationResult = new RaceCompetitorsReconcilationResult(raceCompetitorsList, racerList);
        reconciliationResult.reconcileCompetitors();
        return reconciliationResult;
    }

    public RaceCompetitorsReconcilationResult(RacerList raceCompetitorsList, ToolSessionRacerList racerList) {
        super(racerList);
        this.raceCompetitorsList = raceCompetitorsList;
        this.initCompetitorProcessingParms();
    }

    protected void initCompetitorProcessingParms() {
        Class<? extends RaceClass<?>> raceClassClass = this.raceCompetitorsList.getAgeClassClass();
        this.initAbilityGroupReferences(raceClassClass);
        this.initRaceClassProcessingParms(raceClassClass);
    }

    protected void initRaceClassProcessingParms(Class<? extends RaceClass<?>> raceClassClass) {
        this.seriesAgeClassClass = this.getRacerList().getAgeClassClass();
        if (raceClassClass.equals(this.seriesAgeClassClass)) {
            this.ageClassMappingCode = 0;
            return;
        }
        RaceClassType raceClassType = this.raceClassHelper.getRaceClassType(raceClassClass);
        RaceClassType seriesRaceClassType = this.raceClassHelper.getRaceClassType(this.seriesAgeClassClass);
        if (raceClassType.isNationalClass() && this.raceClassHelper.isDivisionAgeClass(this.seriesAgeClassClass)) {
            this.ageClassMappingCode = 1;
            return;
        }
        if (this.raceClassHelper.isDivisionAgeClass(raceClassClass) && seriesRaceClassType.isNationalClass()) {
            throw new UnsupportedOperationException("Mapping from division age class " + raceClassClass.getName() + " to NationalClass not yet supported");
        }
        throw new IllegalArgumentException(String.format("No mapping from race class %s to %s", raceClassClass.getSimpleName(), this.seriesAgeClassClass.getSimpleName()));
    }

    protected RaceClass<?> getCompetitorAgeClass(Racer aCompetitor) {
        RaceClass<?> raceClass = aCompetitor.getAgeClass();
        if (raceClass.getClass().equals(this.seriesAgeClassClass)) {
            return raceClass;
        }
        switch (this.ageClassMappingCode) {
            case 0: {
                return raceClass;
            }
            case 1: {
                return this.raceClassHelper.toDivisionAgeClass(raceClass, this.seriesAgeClassClass);
            }
            case 2: {
                throw new UnsupportedOperationException(String.format("Mapping from division age class %s to %s not yet supported", raceClass.getClass().getSimpleName(), this.seriesAgeClassClass.getSimpleName()));
            }
        }
        throw new IllegalStateException("Invalid race class mapping index " + this.ageClassMappingCode);
    }

    @Override
    protected void processCompetitors() {
        for (Racer aRacer : this.raceCompetitorsList.getRacers()) {
            this.reconcileCompetitor(aRacer);
        }
    }

    protected void reconcileCompetitor(Racer aCompetitor) {
        Racer newRacer;
        boolean hasSameName;
        String lastName = aCompetitor.getLastName();
        String firstName = aCompetitor.getFirstName();
        RaceClass<?> ageClass = this.getCompetitorAgeClass(aCompetitor);
        Racer registeredRacer = this.findRacerWithBibNumber(aCompetitor.getBibNumber());
        if (registeredRacer != null && (hasSameName = this.hasSameName(registeredRacer, lastName, firstName))) {
            return;
        }
        registeredRacer = this.findRacerWithUSSANumber(aCompetitor.getUSSALicense().toString());
        if (registeredRacer != null && (hasSameName = this.hasSameName(registeredRacer, lastName, firstName))) {
            return;
        }
        registeredRacer = this.findRacerWithSameName(lastName, firstName, ageClass);
        if (registeredRacer != null) {
            return;
        }
        if (ageClass == null || !ageClass.isAgeGroupClass()) {
            return;
        }
        if (this.ageClassMappingCode == 0) {
            newRacer = aCompetitor;
        } else {
            newRacer = (Racer)aCompetitor.clone();
            newRacer.setAgeClass(ageClass);
        }
        this.recordUnregisteredRacer(newRacer);
    }

    protected void recordUnregisteredRacer(Racer aCompetitor) {
        String lastName = aCompetitor.getLastName();
        String firstName = aCompetitor.getFirstName();
        if (RaceDataNormalizationServices.needsCasingCorrection(lastName)) {
            lastName = RaceDataNormalizationServices.normalizeNameCasing(lastName);
        }
        if (RaceDataNormalizationServices.needsCasingCorrection(firstName)) {
            firstName = RaceDataNormalizationServices.normalizeNameCasing(firstName);
        }
        Racer newRacer = new Racer(aCompetitor.getBibNumber(), lastName, firstName);
        newRacer.initCompetitionClassValues(aCompetitor.getGender(), this.getCompetitorAgeClass(aCompetitor), aCompetitor.getNationalClass(), aCompetitor.getBirthYear());
        newRacer.initLicenseValues(aCompetitor.getAffiliation(), aCompetitor.getUSSALicense().toString());
        super.recordUnregisteredRacer(newRacer);
    }
}

