/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.swing.MessageDialog;
import java.awt.Window;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.ui.RaceCompetitorsReconcilationResult;
import org.ussamasters.aces.tools.ui.RacerListReconciliationResultViewer;
import org.ussamasters.aces.tools.ui.RacerListTableHolder;

public class RaceCompetitorsReconciliationViewer
extends RacerListReconciliationResultViewer {
    protected static final String APPLICATION_TITLE = "Race Competitors Reconcilation Report";
    protected RaceIdentifier raceID;
    protected RaceCompetitorsReconcilationResult reconciliationResult;
    protected RacerListTableHolder newRacersListHolder;

    public static void openOn(RaceIdentifier raceID, RaceCompetitorsReconcilationResult reconcilationResult) {
        RaceCompetitorsReconciliationViewer aViewer = new RaceCompetitorsReconciliationViewer(raceID, reconcilationResult);
        aViewer.openWindow();
    }

    public RaceCompetitorsReconciliationViewer(RaceIdentifier raceID, RaceCompetitorsReconcilationResult reconciliationResult) {
        super((ToolID)null, APPLICATION_TITLE);
        this.raceID = raceID;
        this.reconciliationResult = reconciliationResult;
        this.initializeReconciliationDataModels();
    }

    public void addNewRacer(Racer aRacer) {
        this.addNewRacer(aRacer, aRacer);
    }

    public void addNewRacer(Racer aRacer, Racer newRacerToAdd) {
        this.getRacerListEditor().addRacer(newRacerToAdd);
        this.removeNewRacer(aRacer);
    }

    public RacerListTableHolder getNewRacersListHolder() {
        return this.newRacersListHolder;
    }

    public RaceIdentifier getRace() {
        return this.raceID;
    }

    public Racer getSelectedNewRacer() {
        return this.getNewRacersListHolder().getSelectedRacer();
    }

    public boolean hasUnsavedChanges() {
        return this.getRacerListEditor().getHasChangesHolder().getValue();
    }

    protected void initializeReconciliationDataModels() {
        RacerList newRacersList = RacerList.emptyCopy(this.getRacerListEditor().getRacerList());
        Class<? extends RaceClass<?>> requiredAgeClassClass = newRacersList.getAgeClassClass();
        for (Object ri : this.reconciliationResult.getUnregisteredRacers()) {
            Racer aRacer = (Racer)ri;
            RaceClass<?> ageClass = aRacer.getAgeClass();
            if (!ageClass.getClass().equals(requiredAgeClassClass) || !ageClass.isAgeGroupClass()) {
                throw new IllegalStateException("Invalid racer age class " + ageClass.toConstantName() + " for " + aRacer.getName());
            }
            newRacersList.add(aRacer);
        }
        this.newRacersListHolder = new RacerListTableHolder(newRacersList);
    }

    public void removeNewRacer(Racer aRacer) {
        this.getNewRacersListHolder().getRacerList().remove(aRacer);
        this.getNewRacersListHolder().removeRacer(aRacer);
    }

    public void saveChanges() throws RaceDataIOException {
        if (!this.hasUnsavedChanges()) {
            return;
        }
        if (this.getRacerListEditor().getHasChangesHolder().getValue()) {
            this.getSessionManager().saveRacerList(this.racerListEditor.getRacerList());
            this.getRacerListEditor().getHasChangesHolder().setValue(false);
        }
    }

    @Override
    protected boolean shouldAllowCloseWindow(Window aWindow) {
        if (this.hasUnsavedChanges()) {
            int answer = MessageDialog.confirmOrCancel("Unsaved Changes", "You have made changes to the racer list which have not yet been saved.  Save changes?", aWindow);
            if (answer == 2) {
                return false;
            }
            if (answer == 0) {
                try {
                    this.saveChanges();
                }
                catch (RaceDataIOException ex) {
                    MessageDialog.displayError("Save Failed", "Unable to save racer list changes: " + ex.getMessage(), aWindow);
                    return false;
                }
            }
        }
        return super.shouldAllowCloseWindow(aWindow);
    }
}

