/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableRow;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceEntryResult2Run;

public class RaceEntryResultTableRow
extends TableRow {
    public static final String[] COLUMN_LABELS_1RUN = new String[]{"Bib", "Class", "LastName", "FirstName", "Time"};
    public static final String[] COLUMN_LABELS_2RUN = new String[]{"Bib", "Class", "LastName", "FirstName", "Run1", "Run2", "Time"};
    public static final int COLUMN_BIB_NUMBER = 0;
    public static final int COLUMN_AGE_CLASS = 1;
    public static final int COLUMN_LAST_NAME = 2;
    public static final int COLUMN_FIRST_NAME = 3;
    public static final int COLUMN_TIME = 4;
    public static final int COLUMN_RUN1 = 4;
    public static final int COLUMN_RUN2 = 5;
    public static final int COLUMN_TOTAL = 6;
    public static final int NUM_COLUMNS_1RUN = 5;
    public static final int NUM_COLUMNS_2RUN = 7;
    public static final int[] NUM_COLUMNS_BY_NUM_RUNS = new int[]{-1, 5, 7};
    public static final Vector<String> COLUMN_LABELS_1RUN_V = RaceEntryResultTableRow.asVector(COLUMN_LABELS_1RUN);
    public static final Vector<String> COLUMN_LABELS_2RUN_V = RaceEntryResultTableRow.asVector(COLUMN_LABELS_2RUN);
    public static final List<Vector<String>> COLUMN_LABELS_BY_NUM_RUNS = Collections.unmodifiableList(Arrays.asList(null, COLUMN_LABELS_1RUN_V, COLUMN_LABELS_2RUN_V));
    protected RaceEntryResult result;

    public static Vector<String> asVector(String[] values) {
        return new Vector<String>(Arrays.asList(values));
    }

    public RaceEntryResultTableRow(RaceEntryResult result) {
        this.result = result;
        this.setColumnValues();
    }

    public RaceEntryResult getRacerResult() {
        return this.result;
    }

    public void refresh() {
        this.setColumnValues();
    }

    protected void setColumnValues() {
        int nRuns = this.result.getNumberOfRuns();
        int nColumns = NUM_COLUMNS_BY_NUM_RUNS[nRuns];
        Object[] columnValues = new String[nColumns];
        columnValues[0] = this.result.getBib();
        columnValues[1] = this.result.getRaceClass().name;
        columnValues[2] = this.result.getLastName();
        columnValues[3] = this.result.getFirstName();
        switch (nRuns) {
            case 1: {
                columnValues[4] = this.result.getResultValue().toString();
                break;
            }
            case 2: {
                RaceEntryResult2Run r2 = (RaceEntryResult2Run)this.result;
                columnValues[4] = r2.getFirstRun().toString();
                columnValues[5] = r2.getSecondRun().toString();
                columnValues[6] = r2.getResultValue().toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invald number of runs in racer result: " + nRuns + " (" + this.result + ")");
            }
        }
        this.setColumnValues(columnValues);
    }

    public static Vector<String> getColumnLabels(int nRuns) {
        return COLUMN_LABELS_BY_NUM_RUNS.get(nRuns);
    }
}

