/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.models.RaceDataComponentModel;
import org.ussamasters.aces.tools.foundation.models.ToolServices;
import org.ussamasters.aces.tools.ui.ToolUIModelServices;

public class RaceIdentifierModel
extends RaceDataComponentModel {
    protected static final int currentYear = RaceDate.today().getYear();
    protected static List<String> monthNamesList;
    protected static List<String> daysOfMonthList;
    protected static List<String> yearsList;
    protected static List<RaceLocation> raceLocationsList;
    protected static List<RaceType> raceTypesList;
    protected static List<String> qualifierHintsList;
    protected RaceIdentifier raceID;
    protected boolean isIdentificationEditable;
    protected DefaultComboBoxModel<String> raceMonthModel;
    protected DefaultComboBoxModel<String> raceDayOfMonthModel;
    protected DefaultComboBoxModel<String> raceYearModel;
    protected DefaultComboBoxModel<RaceLocation> raceLocationModel;
    protected DefaultComboBoxModel<RaceType> raceTypeModel;
    protected DefaultComboBoxModel<String> raceQualifierModel;

    public static RaceIdentifier newRaceIdentifier(SeasonIdentifier season) {
        RaceDate defaultDate = RaceDate.today();
        if (defaultDate.isBefore(season.getStartDate())) {
            defaultDate = season.getStartDate();
        } else if (defaultDate.isAfter(season.getEndDate())) {
            defaultDate = season.getEndDate();
        }
        return new RaceIdentifier(defaultDate, raceLocationsList.get(0), RaceType.SL, null);
    }

    public RaceIdentifierModel(RaceIdentifier raceID) {
        this(raceID, true);
    }

    public RaceIdentifierModel(RaceIdentifier raceID, boolean isEditable) {
        this.initializeModels();
        this.setRace(raceID);
        this.setIdentificationEditable(isEditable);
    }

    protected RaceDate computeDate() {
        RaceDate aDate = new RaceDate();
        int itemIndex = monthNamesList.indexOf(this.raceMonthModel.getSelectedItem()) + 1;
        aDate.setMonth(itemIndex);
        aDate.setDay(Integer.parseInt((String)this.raceDayOfMonthModel.getSelectedItem()));
        aDate.setYear(Integer.parseInt((String)this.raceYearModel.getSelectedItem()));
        return aDate;
    }

    protected RaceIdentifier getOriginalRace() {
        return this.raceID;
    }

    public RaceIdentifier getRace() {
        if (this.raceID != null && !this.isIdentificationEditable()) {
            return this.raceID;
        }
        return new RaceIdentifier(this.computeDate(), (RaceLocation)this.getRaceLocationModel().getSelectedItem(), (RaceType)this.getRaceTypeModel().getSelectedItem(), ((String)this.getRaceQualifierModel().getSelectedItem()).trim());
    }

    public ComboBoxModel<RaceLocation> getRaceLocationModel() {
        return this.raceLocationModel;
    }

    public ComboBoxModel<String> getRaceQualifierModel() {
        return this.raceQualifierModel;
    }

    public ComboBoxModel<RaceType> getRaceTypeModel() {
        return this.raceTypeModel;
    }

    public ComboBoxModel<String> getRaceDayOfMonthModel() {
        return this.raceDayOfMonthModel;
    }

    public ComboBoxModel<String> getRaceMonthModel() {
        return this.raceMonthModel;
    }

    public ComboBoxModel<String> getRaceYearModel() {
        return this.raceYearModel;
    }

    protected SeasonIdentifier getSeason() {
        return this.getOriginalRace().getSeason();
    }

    public ToolServices getToolServices() {
        return ToolServices.getCurrent();
    }

    protected void initializeModels() {
        ToolUIModelServices toolUIModelServices = this.getToolUIModelServices();
        this.raceMonthModel = toolUIModelServices.constructComboBoxListHolder(monthNamesList);
        this.raceDayOfMonthModel = toolUIModelServices.constructComboBoxListHolder(daysOfMonthList);
        this.raceYearModel = toolUIModelServices.constructComboBoxListHolder(yearsList);
        this.raceLocationModel = toolUIModelServices.constructComboBoxListHolder(raceLocationsList);
        this.raceTypeModel = toolUIModelServices.constructComboBoxListHolder(new ArrayList<RaceType>(raceTypesList));
        this.raceQualifierModel = toolUIModelServices.constructComboBoxListHolder(qualifierHintsList);
    }

    protected void installRaceValues() {
        SeasonConfiguration seasonConfig = SeasonConfiguration.getSeasonConfig(this.getSeason());
        Set<RaceType> registeredRaceTypes = seasonConfig.getFFactorTable().keySet();
        boolean hasSC = registeredRaceTypes.contains(RaceType.SC);
        boolean hasAC = registeredRaceTypes.contains(RaceType.AC);
        if (hasAC && !hasSC) {
            ((DefaultComboBoxModel)this.getRaceTypeModel()).removeElement(RaceType.SC);
        } else if (hasSC && !hasAC) {
            ((DefaultComboBoxModel)this.getRaceTypeModel()).removeElement(RaceType.AC);
        }
        this.getRaceLocationModel().setSelectedItem(this.raceID.getLocation());
        this.getRaceTypeModel().setSelectedItem(this.raceID.getType());
        this.selectDate(this.raceID.getDate());
        this.raceQualifierModel.setSelectedItem(this.raceID.getQualifier());
    }

    public boolean isIdentificationEditable() {
        return this.isIdentificationEditable;
    }

    protected void selectDate(RaceDate aDate) {
        int itemIndex = aDate.getMonthIndex() - 1;
        this.raceMonthModel.setSelectedItem(monthNamesList.get(itemIndex));
        itemIndex = aDate.getDay() - 1;
        this.raceDayOfMonthModel.setSelectedItem(daysOfMonthList.get(itemIndex));
        itemIndex = yearsList.indexOf("" + aDate.getYear());
        this.raceYearModel.setSelectedItem(yearsList.get(itemIndex));
    }

    public void setIdentificationEditable(boolean isEditable) {
        this.isIdentificationEditable = isEditable;
    }

    public void setRace(RaceIdentifier raceID) {
        this.raceID = raceID;
        if (raceID != null) {
            this.installRaceValues();
        }
    }

    protected static void initStaticData() {
        ToolServices myToolServices = ToolServices.getCurrent();
        monthNamesList = Arrays.asList(RaceDate.SHORT_MONTH_NAMES);
        int nDays = 31;
        daysOfMonthList = new ArrayList<String>(nDays);
        for (int i = 1; i <= nDays; ++i) {
            daysOfMonthList.add("" + i);
        }
        yearsList = new ArrayList<String>(5);
        yearsList.add("" + (currentYear - 3));
        yearsList.add("" + (currentYear - 2));
        yearsList.add("" + (currentYear - 1));
        yearsList.add("" + currentYear);
        yearsList.add("" + (currentYear + 1));
        raceLocationsList = myToolServices.constructConstantList(RaceLocation.class);
        raceLocationsList.remove(RaceLocation.UNKNOWN);
        Collections.sort(raceLocationsList, ToolServices.BY_FULLNAME_LOCATION_SORTER);
        raceTypesList = myToolServices.constructConstantList(RaceType.class);
        String[] qualifierHints = new String[]{"", "GroupA", "GroupB", "GroupC", "GroupD", "GroupAB", "GroupCD", "AllRacers", "1of2", "2of2", "(cancelled)", "(rescheduled)", "Makeup", "ScoredMakeup", "UnscoredMakeup", "Unscored"};
        qualifierHintsList = Arrays.asList(qualifierHints);
    }

    static {
        RaceIdentifierModel.initStaticData();
    }
}

