/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableHolder;
import com.glaivestone.mv.swing.TableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.tools.foundation.models.RaceDataComponentModel;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.ui.RaceResultReconcilationResult;

public class RaceResultReconcilationModel
extends RaceDataComponentModel {
    public static final String[] COLUMN_LABELS_UNREGISTERED = new String[]{"Bib", "Race Class", "Racer Name"};
    public static final String[] COLUMN_LABELS_INCONSISTENT_BIB = new String[]{"Race Bib", "Race Class", "Racer Name", "Reg. Bib", "Class", "Registered Name"};
    public static final String[] COLUMN_LABELS_MAYBE_PROBLEM = new String[]{"Bib", "Race Class", "Racer Name", "Bib", "Class", "Registered Name"};
    protected static final int INDEX_RACE_BIB = 0;
    protected static final int INDEX_RACE_CLASS = 1;
    protected static final int INDEX_RACE_NAME = 2;
    protected static final int SIZE_UNREGISTERED_RACER_ROW = 3;
    protected static final int INDEX_REGISTERED_BIB = 3;
    protected static final int INDEX_REGISTERED_CLASS = 4;
    protected static final int INDEX_REGISTERED_NAME = 5;
    protected static final int SIZE_MAYBE_PROBLEM_ROW = 6;
    public static final int NULL_BIB_NUMBER = -1;
    protected RaceResultReconcilationResult reconciliationResult;
    protected boolean mustRecomputeStandings;
    protected TableHolder unregisteredRacersTableHolder;
    protected TableHolder inconsistentBibRacersTableHolder;
    protected TableHolder maybeProblemRacersTableHolder;

    public RaceResultReconcilationModel(RaceResultReconcilationResult reconciliationResult) {
        this.reconciliationResult = reconciliationResult;
        this.initializeModels();
    }

    protected TableRow buildBasicTableRow(RaceEntryResult aRacerResult, int nColumns) {
        TableRow aRow = new TableRow(aRacerResult, nColumns);
        aRow.setSize(nColumns);
        aRow.set(0, aRacerResult.getBib());
        aRow.set(1, aRacerResult.getRaceClass().name);
        aRow.set(2, aRacerResult.getName());
        return aRow;
    }

    protected TableRow buildInconsistentBibRacerRow(RaceEntryResult aRacerResult) {
        return this.buildMaybeProblemRacerRow(aRacerResult, this.getRegisteredRacerCandidateMatch(aRacerResult));
    }

    protected TableRow buildMaybeProblemRacerRow(RaceEntryResult aRacerResult) {
        return this.buildMaybeProblemRacerRow(aRacerResult, this.getRegisteredRacerCandidateMatch(aRacerResult));
    }

    protected TableRow buildMaybeProblemRacerRow(RaceEntryResult aRacerResult, Racer aRacer) {
        RaceClass<?> raceClass = aRacerResult.getRaceClass();
        RaceClass<?> registeredClass = raceClass.isNationalClass() ? aRacer.getNationalClass() : aRacer.getAgeClass();
        TableRow aRow = this.buildBasicTableRow(aRacerResult, 6);
        aRow.set(3, aRacer.getBib());
        aRow.set(4, registeredClass.name);
        aRow.set(5, aRacer.getLastName() + ", " + aRacer.getFirstName());
        return aRow;
    }

    protected TableRow buildUnregisteredRacerRow(RaceEntryResult aRacerResult) {
        return this.buildBasicTableRow(aRacerResult, 3);
    }

    protected TableHolder constructTableHolder(String[] columnLabels, List<TableRow> rows) {
        TableHolder aTableHolder = new TableHolder();
        aTableHolder.setData(Arrays.asList(columnLabels), rows);
        return aTableHolder;
    }

    public RaceIdentifier getRace() {
        return this.reconciliationResult.getRaceResult().getRaceId();
    }

    public Class<? extends RaceClass<?>> getRaceClassClass() {
        return this.reconciliationResult.getRaceResult().getRaceClassClass();
    }

    public RacerListManagementPolicy getRacerListManagementPolicy() {
        return this.reconciliationResult.getRacerList().getManagementPolicy();
    }

    public Racer getRegisteredRacerCandidateMatch(RaceEntryResult aRacerResult) {
        return this.reconciliationResult.getRegisteredRacerCandidateMatch(aRacerResult);
    }

    public TableHolder getInconsistentBibRacersTableHolder() {
        return this.inconsistentBibRacersTableHolder;
    }

    public TableHolder getMaybeProblemRacersTableHolder() {
        return this.maybeProblemRacersTableHolder;
    }

    protected int getRowIndex(RaceEntryResult aRacerResult, TableHolder holder) {
        if (holder == this.getMaybeProblemRacersTableHolder()) {
            return this.reconciliationResult.getMaybeProblemRacers().indexOf(aRacerResult);
        }
        if (holder == this.getInconsistentBibRacersTableHolder()) {
            return this.reconciliationResult.getInconsistentBibRacers().indexOf(aRacerResult);
        }
        if (holder == this.getUnregisteredRacersTableHolder()) {
            return this.reconciliationResult.getUnregisteredRacers().indexOf(aRacerResult);
        }
        throw new IllegalArgumentException("Unknown result holder");
    }

    protected RaceEntryResult getSelectedRacerResult(TableHolder aTableHolder) {
        TableRow selectedRow = (TableRow)aTableHolder.getSelectedValue();
        return selectedRow == null ? null : (RaceEntryResult)selectedRow.getValue();
    }

    protected List<RaceEntryResult> getSelectedRacerResults(TableHolder aTableHolder) {
        List<Object> selectedRows = aTableHolder.getSelectedValues();
        ArrayList<RaceEntryResult> selectedResults = new ArrayList<RaceEntryResult>(selectedRows.size());
        for (Object sel : selectedRows) {
            TableRow selectedRow = (TableRow)sel;
            selectedResults.add((RaceEntryResult)selectedRow.getValue());
        }
        return selectedResults;
    }

    public RaceEntryResult getSelectedInconsistentBibRacer() {
        List<RaceEntryResult> selectedResults = this.getSelectedInconsistentBibRacers();
        int nResults = selectedResults.size();
        if (nResults > 1) {
            throw new IllegalStateException("Wrong operation to use when multiple results selected");
        }
        return nResults == 0 ? null : selectedResults.get(0);
    }

    public List<RaceEntryResult> getSelectedInconsistentBibRacers() {
        return this.getSelectedRacerResults(this.getInconsistentBibRacersTableHolder());
    }

    public RaceEntryResult getSelectedMaybeProblemRacer() {
        List<RaceEntryResult> selectedResults = this.getSelectedMaybeProblemRacers();
        int nResults = selectedResults.size();
        if (nResults > 1) {
            throw new IllegalStateException("Wrong operation to use when multiple results selected");
        }
        return nResults == 0 ? null : selectedResults.get(0);
    }

    public List<RaceEntryResult> getSelectedMaybeProblemRacers() {
        return this.getSelectedRacerResults(this.getMaybeProblemRacersTableHolder());
    }

    public RaceEntryResult getSelectedUnregisteredRacer() {
        return this.getSelectedRacerResult(this.getUnregisteredRacersTableHolder());
    }

    public TableHolder getUnregisteredRacersTableHolder() {
        return this.unregisteredRacersTableHolder;
    }

    public RaceResult getUpdatedRaceResult() {
        RaceResult updatedResult = this.reconciliationResult.getRaceResult();
        if (this.mustRecomputeStandings) {
            updatedResult = this.getSessionManager().recomputeStandings(updatedResult);
        }
        return updatedResult;
    }

    protected void initializeModels() {
        this.initHasChangesHolder();
        this.mustRecomputeStandings = false;
        this.initUnregisteredRacers();
        this.initInconsistentBibRacers();
        this.initMaybeProblemRacers();
    }

    protected void initInconsistentBibRacers() {
        List<RacerResult> racerResults = this.reconciliationResult.getInconsistentBibRacers();
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(racerResults.size());
        for (RacerResult rr : racerResults) {
            RaceEntryResult aRacerResult = (RaceEntryResult)rr;
            tableRows.add(this.buildInconsistentBibRacerRow(aRacerResult));
        }
        this.inconsistentBibRacersTableHolder = this.constructTableHolder(COLUMN_LABELS_INCONSISTENT_BIB, tableRows);
        this.inconsistentBibRacersTableHolder.setMultiSelect();
    }

    protected void initMaybeProblemRacers() {
        List<RacerResult> racerResults = this.reconciliationResult.getMaybeProblemRacers();
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(racerResults.size());
        for (RacerResult rr : racerResults) {
            RaceEntryResult aRacerResult = (RaceEntryResult)rr;
            tableRows.add(this.buildMaybeProblemRacerRow(aRacerResult));
        }
        this.maybeProblemRacersTableHolder = this.constructTableHolder(COLUMN_LABELS_MAYBE_PROBLEM, tableRows);
        this.maybeProblemRacersTableHolder.setMultiSelect();
    }

    protected void initUnregisteredRacers() {
        List<Object> racerResults = this.reconciliationResult.getUnregisteredRacers();
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(racerResults.size());
        for (Object rr : racerResults) {
            RaceEntryResult aRacerResult = (RaceEntryResult)rr;
            tableRows.add(this.buildUnregisteredRacerRow(aRacerResult));
        }
        this.unregisteredRacersTableHolder = this.constructTableHolder(COLUMN_LABELS_UNREGISTERED, tableRows);
    }

    public void updateInconsistentBibRacerBib(RaceEntryResult aRacerResult) {
        Racer registeredRacer = this.getRegisteredRacerCandidateMatch(aRacerResult);
        this.updateRacerResult(aRacerResult, this.getInconsistentBibRacersTableHolder(), registeredRacer.getBibNumber(), null, null, null);
    }

    public void updateMaybeProblemRacerName(RaceEntryResult aRacerResult) {
        Racer registeredRacer = this.getRegisteredRacerCandidateMatch(aRacerResult);
        this.updateProblemRacerName(aRacerResult, registeredRacer.getLastName(), registeredRacer.getFirstName());
    }

    public void updateProblemRacerName(RaceEntryResult aRacerResult, String lastName, String firstName) {
        this.updateRacerResult(aRacerResult, this.getMaybeProblemRacersTableHolder(), -1, lastName, firstName, null);
    }

    public void updateRacerResult(RaceEntryResult aRacerResult, TableHolder holder, int bibNumber, String lastName, String firstName, RaceClass<?> raceClass) {
        int rowIndex = this.getRowIndex(aRacerResult, holder);
        if (rowIndex == -1) {
            System.out.println("***Result row not found for " + aRacerResult.getName());
            return;
        }
        this.getHasChangesHolder().setValue(true);
        if (bibNumber != -1) {
            aRacerResult.setBibNumber(bibNumber);
            holder.getDataModel().setValueAt("" + bibNumber, rowIndex, 0);
        }
        if (lastName != null) {
            aRacerResult.setName(lastName, firstName);
            holder.getDataModel().setValueAt(aRacerResult.getName(), rowIndex, 2);
        }
        if (raceClass != null) {
            if (!raceClass.getClass().equals(aRacerResult.getRaceClass().getClass())) {
                throw new IllegalArgumentException("Invalid racer result class update: cannot change " + aRacerResult.getRaceClass().toConstantName() + " to " + raceClass.toConstantName());
            }
            aRacerResult.setRaceClass(raceClass);
            holder.getDataModel().setValueAt(raceClass.name, rowIndex, 1);
            this.mustRecomputeStandings = true;
        }
    }
}

