/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.OneArgumentBlock;
import com.glaivestone.javax.io.FileType;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.BooleanHolder;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.reports.RaceDataReportConstants;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.models.WorkingSetModelEvent;
import org.ussamasters.aces.tools.foundation.models.WorkingSetModelListener;
import org.ussamasters.aces.tools.ui.RaceResultDataTool;
import org.ussamasters.aces.tools.ui.RaceSeriesTableHolder;

public class RaceResultsTool
extends RaceResultDataTool {
    public static final ToolID TOOL_ID = new ToolID("RaceResultsTool");
    protected static String APPLICATION_TITLE = "USSA Masters Race Results";
    protected static final FileType[] REPORT_FORMATS = new FileType[]{RaceDataReportConstants.FILE_TYPE_TEXT, RaceDataReportConstants.FILE_TYPE_HTML, RaceDataReportConstants.FILE_TYPE_PDF};
    protected static boolean generateHTMLReportsDefault = true;
    protected static boolean generateTextReportsDefault = false;
    protected static boolean generatePdfReportsDefault = false;
    protected static boolean viewGeneratedReportsDefault = true;
    private static final Class<RaceResultsTool> THIS_CLASS = RaceResultsTool.class;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION = RaceResultsTool.constructToolConstructionAction(THIS_CLASS);
    protected RaceSeries raceCalendar;
    protected RaceSeriesTableHolder raceSeriesTableHolder;
    protected BooleanHolder generateHTMLReportsHolder;
    protected BooleanHolder generateTextReportsHolder;
    protected BooleanHolder generatePdfReportsHolder;
    protected BooleanHolder viewGeneratedReportsHolder;
    protected BooleanHolder raceStatusChangedHolder;
    protected WorkingSetModelListener raceResultModelListener;

    public static ApplicationView findOrOpen() {
        ApplicationView aWindow = RaceResultsTool.findWindow(TOOL_ID);
        if (aWindow != null) {
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
        } else {
            aWindow = RaceResultsTool.open();
        }
        return aWindow;
    }

    public static void installTool(ToolInfo toolInfo) {
        String displayName = toolInfo.getDisplayName();
        if (displayName != null) {
            APPLICATION_TITLE = displayName;
        }
        generateHTMLReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generateHTMLReports", generateHTMLReportsDefault);
        generateTextReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generateTextReports", generateTextReportsDefault);
        generatePdfReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generatePdfReports", generatePdfReportsDefault);
        viewGeneratedReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("viewGeneratedReports", viewGeneratedReportsDefault);
    }

    public static ApplicationView open() {
        return RaceResultsTool.openToolWindow(TOOL_ID, TOOL_CONSTRUCTION_ACTION);
    }

    public RaceResultsTool() throws RaceDataIOException {
        this(TOOL_ID, APPLICATION_TITLE);
    }

    protected RaceResultsTool(ToolID toolID, String title) throws RaceDataIOException {
        super(toolID, title);
        this.initializeWorkingSetDataModels();
    }

    public void addRace(RaceIdentifier newRace) throws RaceDataIOException {
        this.getSessionManager().addRace(newRace);
        this.getRaceSeriesTableHolder().addRace(newRace, this.getRaceSeries().indexOf(newRace));
    }

    public boolean allowsScoringTools() {
        return false;
    }

    public boolean allowsSeasonScoring() {
        return false;
    }

    protected WorkingSetModelListener constructRaceResultModelListener() {
        return new WorkingSetModelListener(){

            protected boolean isRaceResultEvent(WorkingSetModelEvent event) {
                return event.getFile().getParentFile().equals(RaceResultsTool.this.getSessionManager().getRaceDataDirectory()) && event.getModel() instanceof RaceResult;
            }

            @Override
            public void modelAdded(WorkingSetModelEvent event) {
                if (this.isRaceResultEvent(event)) {
                    RaceResultsTool.this.raceResultAdded((RaceResult)event.getModel());
                }
            }

            @Override
            public void modelChanged(WorkingSetModelEvent event) {
                if (this.isRaceResultEvent(event)) {
                    RaceResultsTool.this.raceDataChanged(((RaceResult)event.getModel()).getRaceId());
                }
            }

            @Override
            public void modelRemoved(WorkingSetModelEvent event) {
                if (this.isRaceResultEvent(event)) {
                    RaceResultsTool.this.raceDataChanged(((RaceResult)event.getModel()).getRaceId());
                }
            }
        };
    }

    @Override
    protected String defaultWindowClassName() {
        return "org.ussamasters.aces.tools.ui.swing.RaceResultsToolWindow";
    }

    public void deleteRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getRaceSeriesTableHolder().remove(raceID);
        this.getSessionManager().removeRace(raceID);
    }

    public void deleteRaceData(RaceIdentifier raceID) {
        this.deleteRaceReports(raceID);
        this.deleteRaceReportsFiles(raceID);
        this.getSessionManager().deleteRaceResult(raceID);
        this.getRaceSeriesTableHolder().updateRaceInfo(raceID);
    }

    public void deleteRaceReports(RaceIdentifier raceID) {
        this.deleteRaceReportsFiles(raceID);
        this.getRaceSeriesTableHolder().updateRaceInfo(raceID);
    }

    protected void deleteRaceReportsFiles(RaceIdentifier raceID) {
        int nDeleted = 0;
        for (int i = 0; i < REPORT_FORMATS.length; ++i) {
            for (File reportFile : this.getResultReportFiles(raceID, REPORT_FORMATS[i])) {
                reportFile.delete();
                ++nDeleted;
            }
        }
    }

    public void generateRaceResultsReports(RaceIdentifier raceID) throws RaceDataIOException {
        this.generateRaceResultsReportsGuts(raceID);
        this.raceDataChanged(raceID);
    }

    protected void generateRaceResultsReportsGuts(RaceIdentifier raceID) throws RaceDataIOException {
        boolean displayReports = false;
        ArrayList<FileType> reportTypes = new ArrayList<FileType>();
        if (this.getGenerateHTMLReportsHolder().getValue()) {
            reportTypes.add(RaceDataReportConstants.FILE_TYPE_HTML);
        }
        if (this.getGenerateTextReportsHolder().getValue()) {
            reportTypes.add(RaceDataReportConstants.FILE_TYPE_TEXT);
        }
        if (this.getGeneratePdfReportsHolder().getValue()) {
            reportTypes.add(RaceDataReportConstants.FILE_TYPE_PDF);
        }
        if (reportTypes.size() == 0) {
            return;
        }
        this.generateRaceResultsReports(raceID, reportTypes, displayReports);
    }

    public RaceSeries getCandidateRacesToMerge(RaceIdentifier selectedRace) {
        return this.getCandidateRacesToSplitOrMerge(selectedRace, false);
    }

    public RaceSeries getCandidateRacesToSplit(RaceIdentifier selectedRace) {
        return this.getCandidateRacesToSplitOrMerge(selectedRace, true);
    }

    protected RaceSeries getCandidateRacesToSplitOrMerge(RaceIdentifier selectedRace, boolean matchLocation) {
        RaceType raceType = selectedRace.getType();
        RaceSeries candidateRaces = RaceSeries.createEmptySeries(this.getRaceSeries());
        for (RaceIdentifier raceID : this.getRaceSeries().getRaces()) {
            RaceResult aRaceResult;
            if (raceID.equals(selectedRace) || raceID.getType() != raceType || matchLocation && raceID.getLocation() != selectedRace.getLocation() || (aRaceResult = this.getRaceResult(raceID)) == null) continue;
            candidateRaces.add(raceID);
        }
        return candidateRaces;
    }

    public BooleanHolder getGenerateHTMLReportsHolder() {
        return this.generateHTMLReportsHolder;
    }

    public BooleanHolder getGeneratePdfReportsHolder() {
        return this.generatePdfReportsHolder;
    }

    public BooleanHolder getGenerateTextReportsHolder() {
        return this.generateTextReportsHolder;
    }

    public int getNumberOfRaces() {
        return this.raceCalendar.size();
    }

    public File getRaceDataDirectory() {
        return this.getSessionManager().getRaceDataDirectory();
    }

    public BooleanHolder getRaceStatusChangedHolder() {
        return this.raceStatusChangedHolder;
    }

    @Override
    public RaceResult getRaceResult(RaceIdentifier raceID) {
        if (raceID == null) {
            return null;
        }
        return super.getRaceResult(raceID);
    }

    @Override
    public RacerList getRaceResultCompetitorInfo(RaceIdentifier raceID) throws RaceDataIOException {
        if (raceID == null) {
            return null;
        }
        return super.getRaceResultCompetitorInfo(raceID);
    }

    @Override
    public RacerList getRaceResultCompetitors(RaceIdentifier raceID) throws RaceDataIOException {
        if (raceID == null) {
            return null;
        }
        return super.getRaceResultCompetitors(raceID);
    }

    protected RaceIdentifier getRace(RaceResult aRaceResult) {
        for (RaceIdentifier aRace : this.raceCalendar.getRaces()) {
            if (!aRace.equals(aRaceResult)) continue;
            return aRace;
        }
        return null;
    }

    public RaceSeries getRaceSeries() {
        return this.raceCalendar;
    }

    public String getRaceSeriesName() {
        return this.raceCalendar.getName();
    }

    public RaceSeriesTableHolder getRaceSeriesTableHolder() {
        return this.raceSeriesTableHolder;
    }

    @Override
    protected List<File> getResultReportFiles(RaceIdentifier raceID, FileType reportFileType) {
        if (this.getRaceResult(raceID) == null) {
            return Collections.emptyList();
        }
        return super.getResultReportFiles(raceID, reportFileType);
    }

    public RaceIdentifier getSelectedRace() {
        return this.getRaceSeriesTableHolder().getSelectedRace();
    }

    public RaceResult getSelectedRaceResult() {
        return this.getRaceResult(this.getSelectedRace());
    }

    public BooleanHolder getViewGeneratedReportsHolder() {
        return this.viewGeneratedReportsHolder;
    }

    public boolean hasResultsAvailable(RaceIdentifier aRace) {
        return this.getRaceResult(aRace) != null;
    }

    public boolean hasHTMLReportsAvailable(RaceIdentifier aRace) {
        return this.getResultReportFiles(aRace, RaceDataReportConstants.FILE_TYPE_HTML).size() > 0;
    }

    public boolean hasPdfReportsAvailable(RaceIdentifier aRace) {
        return this.getResultReportFiles(aRace, RaceDataReportConstants.FILE_TYPE_PDF).size() > 0;
    }

    public boolean hasTextReportsAvailable(RaceIdentifier aRace) {
        return this.getResultReportFiles(aRace, RaceDataReportConstants.FILE_TYPE_TEXT).size() > 0;
    }

    @Override
    protected void initializeModels() {
        super.initializeModels();
        this.generateHTMLReportsHolder = new BooleanHolder(generateHTMLReportsDefault);
        this.generateTextReportsHolder = new BooleanHolder(generateTextReportsDefault);
        this.generatePdfReportsHolder = new BooleanHolder(generatePdfReportsDefault);
        this.viewGeneratedReportsHolder = new BooleanHolder(viewGeneratedReportsDefault);
    }

    protected void initRaceSeriesTableHolder() {
        this.raceSeriesTableHolder = new RaceSeriesTableHolder(this.raceCalendar, new String[]{"Status", "Reports"}, new EvaluableAction[]{new OneArgumentBlock(this, "ComposeRaceStatusEntry"){

            @Override
            protected Object evaluateExpression(Object aValue) {
                RaceIdentifier aRace = (RaceIdentifier)aValue;
                return RaceResultsTool.this.getRaceResult(aRace) != null ? "completed" : "";
            }
        }, new OneArgumentBlock(this, "ComposeReportsStatusEntry"){

            @Override
            protected Object evaluateExpression(Object aValue) {
                RaceIdentifier aRace = (RaceIdentifier)aValue;
                return RaceResultsTool.this.hasReportsAvailable(aRace) ? "available" : "";
            }
        }});
    }

    protected void initializeWorkingSetDataModels() throws RaceDataIOException {
        this.raceCalendar = this.getSessionManager().getRaceCalendar();
        this.raceStatusChangedHolder = new BooleanHolder();
        this.initRaceSeriesTableHolder();
    }

    protected void notifyRaceStatusChanged() {
        this.getRaceStatusChangedHolder().toggleValue();
    }

    public void showWorkingSetDirectory() throws IOException {
        this.showDirectory(this.getSessionManager().getWorkingSetDirectory());
    }

    public void openCorrectionsLog() throws IOException {
        this.openCorrectionsLog(this.getRaceDataDirectory());
    }

    protected void raceDataChanged(RaceIdentifier raceID) {
        this.getRaceSeriesTableHolder().updateRaceInfo(raceID);
        this.notifyRaceStatusChanged();
    }

    public void raceResultAdded(RaceResult aRaceResult) {
        RaceIdentifier raceID = aRaceResult.getRaceId();
        try {
            this.generateRaceResultsReportsGuts(raceID);
        }
        catch (RaceDataIOException raceDataIOException) {
            // empty catch block
        }
        int selectedIndex = this.raceCalendar.indexOf(raceID);
        if (selectedIndex == -1) {
            return;
        }
        this.raceDataChanged(raceID);
    }

    protected void registerWorkingSetEventHandlers() {
        if (this.raceResultModelListener == null) {
            this.raceResultModelListener = this.constructRaceResultModelListener();
            this.getSessionManager().addModelListener(this.raceResultModelListener);
        }
    }

    protected void removeWorkingSetEventHandlers() {
        if (this.raceResultModelListener != null) {
            this.getSessionManager().removeModelListener(this.raceResultModelListener);
            this.raceResultModelListener = null;
        }
    }

    public void saveRaceResult(RaceResult aRaceResult) throws RaceDataIOException {
        this.getSessionManager().saveRaceResult(aRaceResult);
    }

    public void updateRace(RaceIdentifier raceID, RaceIdentifier newRaceID) throws RaceDataIOException {
        this.deleteRace(raceID);
        this.addRace(newRaceID);
    }

    public void viewHTMLReports(RaceIdentifier aRace) {
        this.viewReports(aRace, RaceDataReportConstants.FILE_TYPE_HTML);
    }

    public void viewReport(File reportFile) {
        RaceDataReportServices.openReport(reportFile);
    }

    public void viewReports(RaceIdentifier aRace, FileType reportFileType) {
        List<File> reportFiles = this.getResultReportFiles(aRace, reportFileType);
        for (File reportFile : reportFiles) {
            this.viewReport(reportFile);
        }
    }

    public void viewPdfReports(RaceIdentifier aRace) {
        this.viewReports(aRace, RaceDataReportConstants.FILE_TYPE_PDF);
    }

    public void viewTextReports(RaceIdentifier aRace) {
        this.viewReports(aRace, RaceDataReportConstants.FILE_TYPE_TEXT);
    }

    @Override
    protected void windowClosed(Window aWindow) {
        this.removeWorkingSetEventHandlers();
        super.windowClosed(aWindow);
    }

    @Override
    protected void windowOpened(Window aWindow) {
        this.registerWorkingSetEventHandlers();
        super.windowOpened(aWindow);
    }

    public static void main(String[] args) {
        RaceResultsTool.processCommandLineArgs(args);
        RaceResultsTool.initiateSession();
        RaceResultsTool.open();
    }
}

