/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.mv.ApplicationView;
import java.awt.Frame;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.models.WorkingSetChangeEvent;
import org.ussamasters.aces.tools.ui.RaceResultsTool;

public class RaceScoringTool
extends RaceResultsTool {
    public static final ToolID TOOL_ID = new ToolID("RaceScoringTool");
    protected static String APPLICATION_TITLE = "USSA Masters Race Scoring";
    private static final Class<RaceScoringTool> THIS_CLASS = RaceScoringTool.class;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION = RaceScoringTool.constructToolConstructionAction(THIS_CLASS);

    public static ApplicationView findOrOpen() {
        ApplicationView aWindow = RaceScoringTool.findWindow(TOOL_ID);
        if (aWindow != null) {
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
        } else {
            aWindow = RaceScoringTool.open();
        }
        return aWindow;
    }

    public static void installTool(ToolInfo toolInfo) {
        String displayName = toolInfo.getDisplayName();
        if (displayName != null) {
            APPLICATION_TITLE = displayName;
        }
    }

    public static ApplicationView open() {
        return RaceScoringTool.openToolWindow(TOOL_ID, TOOL_CONSTRUCTION_ACTION);
    }

    public RaceScoringTool() throws RaceDataIOException {
        super(TOOL_ID, APPLICATION_TITLE);
    }

    @Override
    public boolean allowsScoringTools() {
        return true;
    }

    @Override
    public boolean allowsSeasonScoring() {
        return this.getSessionManager().allowsSeasonScoring();
    }

    @Override
    public void loadingWorkingSet(WorkingSetChangeEvent event) {
        this.getRaceSeriesTableHolder().clear();
    }

    @Override
    public boolean supportsWorkingSetSwitching() {
        return true;
    }

    @Override
    public void workingSetLoaded(WorkingSetChangeEvent event) {
        this.raceCalendar = this.getSessionManager().getRaceCalendar();
        this.getRaceSeriesTableHolder().setData(this.raceCalendar);
        super.workingSetLoaded(event);
    }

    public static void main(String[] args) {
        RaceScoringTool.processCommandLineArgs(args);
        RaceScoringTool.initiateSession();
        RaceScoringTool.open();
    }
}

