/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.tools.foundation.models.RaceDataComponentModel;
import org.ussamasters.aces.tools.foundation.models.RacerListManagementPolicy;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.ui.RacerListTableHolder;

public class RacerListEditorModel
extends RaceDataComponentModel {
    public static final int DEFAULT_SORT_ORDER = 0;
    protected ToolSessionRacerList racerList;
    protected RacerListTableHolder racerListHolder;

    public RacerListEditorModel(ToolSessionRacerList racerList) {
        this(racerList, 0);
    }

    public RacerListEditorModel(ToolSessionRacerList racerList, int racerListSortOrder) {
        this.racerList = racerList;
        this.initializeModels(racerListSortOrder);
    }

    public void addRacer(Racer aRacer) {
        this.racerList.add(aRacer);
        this.getHasChangesHolder().setValue(true);
        this.getRacerListHolder().addRacer(aRacer);
        this.getRacerListHolder().selectRacer(aRacer);
    }

    public ToolSessionRacerList getRacerList() {
        return this.racerList;
    }

    public RacerListTableHolder getRacerListHolder() {
        return this.racerListHolder;
    }

    public RacerListManagementPolicy getRacerListManagementPolicy() {
        return this.racerList.getManagementPolicy();
    }

    public Racer getSelectedRacer() {
        return this.getRacerListHolder().getSelectedRacer();
    }

    public boolean hasUnsavedChanges() {
        return this.hasChangesHolder.getValue();
    }

    protected void initializeModels(int racerListSortOrder) {
        this.initHasChangesHolder();
        this.racerListHolder = new RacerListTableHolder(this.racerList, racerListSortOrder);
        if (this.racerList.size() > 0) {
            this.racerListHolder.selectIndex(0);
        }
    }

    public void removeRacer(Racer aRacer) {
        this.getRacerListHolder().removeRacer(aRacer);
        this.racerList.remove(aRacer);
        this.getHasChangesHolder().setValue(true);
    }

    public void updateRacer(Racer aRacer) {
        this.racerList.update(aRacer);
        this.getHasChangesHolder().setValue(true);
        this.getRacerListHolder().refreshRow(aRacer);
        this.getRacerListHolder().selectRacer(aRacer);
    }
}

