/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.swing.TableHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.ui.RacerTableRow;

public class RacerListTableHolder
extends TableHolder {
    public static final int NUM_COLUMNS = 8;
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_BIB = 1;
    public static final int SORT_BY_AGE = 2;
    public static final int SORT_BY_CLASS = 3;
    public static final int NUM_SORT_ORDERS = 4;
    public static final int DEFAULT_SORT_ORDER = 0;
    protected static final List<Comparator<RacerTableRow>> rowSorters = RacerListTableHolder.constructRowSorters();
    public static final Vector<String> COLUMN_LABELS = RacerTableRow.STANDARD_COLUMN_LABELS;
    public static final int[] COLUMN_WIDTHS = RacerTableRow.STANDARD_COLUMN_WIDTHS;
    protected RacerList racerList;
    protected int currentSortOrder;
    protected Vector<RacerTableRow> racerDataRows;

    public RacerListTableHolder(RacerList racerList) {
        this(racerList, 0);
    }

    public RacerListTableHolder(RacerList racerList, int sortOrder) {
        this.setSortOrder(sortOrder);
        this.setData(racerList);
    }

    public void addRacer(Racer aRacer) {
        RacerTableRow newRow = new RacerTableRow(aRacer);
        int newRowIndex = this.racerDataRows.size();
        this.add(newRow);
        this.selectIndex(newRowIndex);
        this.sortRows();
    }

    protected void buildRows() {
        Vector<RacerTableRow> rows = new Vector<RacerTableRow>(this.racerList.size());
        for (Racer aRacer : this.racerList.getRacers()) {
            rows.add(new RacerTableRow(aRacer));
        }
        this.racerDataRows = rows;
    }

    public RacerList getRacerList() {
        return this.racerList;
    }

    public Racer getSelectedRacer() {
        RacerTableRow selectedRow = (RacerTableRow)this.getSelectedValue();
        return selectedRow == null ? null : selectedRow.getRacer();
    }

    public int getSortOrder() {
        return this.currentSortOrder;
    }

    @Override
    public int indexOf(Object aValue) {
        return this.indexOf((Racer)aValue);
    }

    public int indexOf(Racer aRacer) {
        int nRows = this.size();
        Vector<Vector> rows = this.getConcreteDataModel().getDataVector();
        for (int i = 0; i < nRows; ++i) {
            RacerTableRow aRow = (RacerTableRow)rows.elementAt(i);
            if (!aRow.getRacer().equals(aRacer)) continue;
            return i;
        }
        return -1;
    }

    public void refreshRow(Racer aRacer) {
        int rowIndex = this.indexOf(aRacer);
        if (rowIndex == -1) {
            System.out.println("***Racer row not found for " + aRacer.getName());
            return;
        }
        ((RacerTableRow)this.getRow(rowIndex)).refresh();
        this.getConcreteDataModel().fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void removeRacer(Racer aRacer) {
        this.remove(this.indexOf(aRacer));
    }

    public void setData(RacerList racerList) {
        this.racerList = racerList;
        this.buildRows();
        this.sortRows();
        this.getConcreteDataModel().setDataVector(this.racerDataRows, COLUMN_LABELS);
    }

    public void selectRacer(Racer aRacer) {
        int rowIndex = this.indexOf(aRacer);
        if (rowIndex != -1) {
            this.selectIndex(rowIndex);
        }
    }

    public void setSortOrder(int sortOrder) {
        this.currentSortOrder = sortOrder;
        if (this.racerDataRows != null) {
            RacerTableRow selectedRow = (RacerTableRow)this.getSelectedValue();
            this.sortRows();
            if (selectedRow != null) {
                int selectedIndex = this.getConcreteDataModel().getDataVector().indexOf(selectedRow);
                this.selectIndex(selectedIndex);
            }
        }
    }

    protected void sortRows() {
        Collections.sort(this.racerDataRows, rowSorters.get(this.currentSortOrder));
        this.getConcreteDataModel().fireTableDataChanged();
    }

    protected static List<Comparator<RacerTableRow>> constructRowSorters() {
        Comparator<RacerTableRow> byBibRowSorter = new Comparator<RacerTableRow>(){

            @Override
            public int compare(RacerTableRow row1, RacerTableRow row2) {
                return row1.getRacer().compareByBib(row2.getRacer());
            }
        };
        Comparator<RacerTableRow> byAgeRowSorter = new Comparator<RacerTableRow>(){

            @Override
            public int compare(RacerTableRow row1, RacerTableRow row2) {
                return row1.getRacer().compareByAge(row2.getRacer());
            }
        };
        Comparator<RacerTableRow> byNameRowSorter = new Comparator<RacerTableRow>(){

            @Override
            public int compare(RacerTableRow row1, RacerTableRow row2) {
                return row1.getRacer().compareByName(row2.getRacer());
            }
        };
        Comparator<RacerTableRow> byClassRowSorter = new Comparator<RacerTableRow>(){

            @Override
            public int compare(RacerTableRow row1, RacerTableRow row2) {
                return row1.getRacer().compareByAgeClass(row2.getRacer());
            }
        };
        ArrayList<Comparator<RacerTableRow>> rowSorters = new ArrayList<Comparator<RacerTableRow>>(4);
        rowSorters.add(byNameRowSorter);
        rowSorters.add(byBibRowSorter);
        rowSorters.add(byAgeRowSorter);
        rowSorters.add(byClassRowSorter);
        return rowSorters;
    }
}

