/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.BooleanHolder;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.PolicyID;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandardOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.scoring.AgeClassAbilityBonusScoringPolicy;
import org.ussamasters.aces.racedata.scoring.AllFinishesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.BestNFinishesAgeClassAbilityBonusScoringPolicy;
import org.ussamasters.aces.racedata.scoring.BestNFinishesScoringPolicy;
import org.ussamasters.aces.racedata.scoring.ScoringPolicyRegistry;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeasonStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.foundation.models.ToolInfo;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.SeriesScoringTool;

public class SeasonScoringTool
extends SeriesScoringTool {
    public static final ToolID TOOL_ID = new ToolID("SeasonScoringTool");
    public static final String SCORING_POLICY_CATEGORY = "SeasonScoring";
    public static final PolicyID SCORING_POLICY_WC_POINTS_ALL_FINISHES;
    public static final PolicyID SCORING_POLICY_WC_POINTS_BEST_N_FINISHES;
    public static final PolicyID SCORING_POLICY_WC_POINTS_AGE_CLASS_ABILITY_BONUS;
    public static final PolicyID SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS;
    public static final int DEFAULT_BEST_N_FINISHES_COUNT = 10;
    protected static boolean generateHTMLReportsDefault;
    protected static boolean generateTextReportsDefault;
    protected static boolean generatePdfReportsDefault;
    private static final Class<SeasonScoringTool> THIS_CLASS;
    private static final EvaluableAction TOOL_CONSTRUCTION_ACTION;
    protected static final String STANDINGS_FILE_NAME_PREFIX;
    protected static StandingsOrganizationType[] SUPPORTED_ORGANIZATION_TYPES;
    protected static final ScoringPolicyRegistry scoringPolicyRegistry;
    protected static String APPLICATION_TITLE;
    protected static final String LAST_SELECTED_SCORING_POLICY_TOOL_OPTION = "selectedScoringPolicy";

    public static ApplicationView findOrOpen() {
        ApplicationView aWindow = SeasonScoringTool.findWindow(TOOL_ID);
        if (aWindow != null) {
            Frame frameWindow = (Frame)aWindow.getMainWindow();
            if (frameWindow.getState() == 1) {
                frameWindow.setState(0);
            } else {
                frameWindow.toFront();
            }
            frameWindow.requestFocus();
        } else {
            aWindow = SeasonScoringTool.open();
        }
        return aWindow;
    }

    public static void installTool(ToolInfo toolInfo) {
        String displayName = toolInfo.getDisplayName();
        if (displayName != null) {
            APPLICATION_TITLE = displayName;
        }
        generateHTMLReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generateHTMLReports", generateHTMLReportsDefault);
        generateTextReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generateTextReports", generateTextReportsDefault);
        generatePdfReportsDefault = toolInfo.getToolInstallationConfigSettings().getBooleanValue("generatePdfReports", generatePdfReportsDefault);
    }

    public static ApplicationView open() {
        return SeasonScoringTool.openToolWindow(TOOL_ID, TOOL_CONSTRUCTION_ACTION);
    }

    public SeasonScoringTool() throws RaceDataIOException {
        super(TOOL_ID, APPLICATION_TITLE, SUPPORTED_ORGANIZATION_TYPES, scoringPolicyRegistry);
    }

    @Override
    public void addRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getSessionManager().addSeasonScoringRace(raceID);
    }

    @Override
    protected SeriesStandings createStandings(StandingsOrganizationType organizationType, ScoringPolicySpecification policySpec) {
        if (!SeasonStandings.isSupportedOrganization(organizationType, this.getRaceSeries())) {
            return null;
        }
        SeasonStandings standings = (SeasonStandings)SeasonStandings.forRaceSeries(this.getRaceSeries(), this.getSessionManager().getRacerList(), organizationType);
        standings.computeStandings(this.getScoringPolicy(policySpec));
        return standings;
    }

    @Override
    public int generateStandingsReports(ScoringPolicySpecification policySpec) throws RaceDataIOException {
        int nReportsGenerated;
        SeasonStandings.allowGenderStandingsHACK = WorkingSetSettings.getCurrent().getSeasonScoringAllowGenderStandingsHACK();
        try {
            nReportsGenerated = super.generateStandingsReports(policySpec);
        }
        finally {
            SeasonStandings.allowGenderStandingsHACK = false;
        }
        return nReportsGenerated;
    }

    @Override
    public File getReportsDirectory() {
        return this.getSessionManager().getSeasonReportsDirectory();
    }

    public File getSeriesDataDirectory() {
        return this.getSessionManager().getSeasonDataDirectory();
    }

    @Override
    protected String getStandingsFileNamePrefix() {
        return STANDINGS_FILE_NAME_PREFIX;
    }

    @Override
    protected void initializeModels() {
        super.initializeModels();
        this.generateHTMLReportsHolder = new BooleanHolder(generateHTMLReportsDefault);
        this.generateTextReportsHolder = new BooleanHolder(generateTextReportsDefault);
        this.generatePdfReportsHolder = new BooleanHolder(generatePdfReportsDefault);
    }

    @Override
    protected void initializeWorkingSetDataModels() throws RaceDataIOException {
        super.initializeWorkingSetDataModels();
        this.initRaceSeriesHolder(this.getSessionManager().getSeasonScoringRaces());
        this.initScoringPolicySelection();
    }

    protected void initScoringPolicySelection() {
        String selectedPolicyName = this.getSessionManager().getToolOption(this.getToolID(), LAST_SELECTED_SCORING_POLICY_TOOL_OPTION);
        this.initScoringPolicySelection(selectedPolicyName);
    }

    @Override
    protected void loadScoringPolicyParms(ScoringPolicySpecification policySpec) {
        if (policySpec.policyID == SCORING_POLICY_WC_POINTS_BEST_N_FINISHES || policySpec.policyID == SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS) {
            String parmName = "maxFinishes";
            int defaultValue = (Integer)policySpec.getParameter(parmName);
            int maxRacesToCount = WorkingSetSettings.getCurrent().getSeasonScoringBestNFinishesCount(defaultValue);
            if (maxRacesToCount != defaultValue) {
                policySpec.setParameter(parmName, new Integer(maxRacesToCount));
            }
        } else if (policySpec.policyID == SCORING_POLICY_WC_POINTS_AGE_CLASS_ABILITY_BONUS || policySpec.policyID == SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS) {
            int bonusValue = WorkingSetSettings.getCurrent().getSeasonScoringAbilityBonusAgeClassScore();
            boolean includeAbilityClasses = WorkingSetSettings.getCurrent().getSeasonScoringAbilityBonusIncludeAbilityClasses();
            if (bonusValue != AgeClassAbilityBonusScoringPolicy.DEFAULT_AGE_CLASS_ABILITY_SCORE.intValue()) {
                policySpec.setParameter("bonusValue", new Integer(bonusValue));
            }
            if (includeAbilityClasses) {
                policySpec.setParameter("includeAbilityClasses", includeAbilityClasses);
            }
        }
    }

    @Override
    public void removeRace(RaceIdentifier raceID) throws RaceDataIOException {
        this.getSessionManager().removeSeasonScoringRace(raceID);
    }

    @Override
    protected void saveScoringPolicyParms(ScoringPolicySpecification policySpec) {
        this.getSessionManager().saveToolOption(TOOL_ID, LAST_SELECTED_SCORING_POLICY_TOOL_OPTION, policySpec.getName());
        if (policySpec.hasConfigurableParameters()) {
            if (policySpec.policyID == SCORING_POLICY_WC_POINTS_BEST_N_FINISHES || policySpec.policyID == SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS) {
                String parmName = "maxFinishes";
                int maxRacesToCount = (Integer)policySpec.getParameter(parmName);
                WorkingSetSettings.getCurrent().setSeasonScoringBestNFinishesCount(maxRacesToCount);
            } else if (policySpec.policyID == SCORING_POLICY_WC_POINTS_AGE_CLASS_ABILITY_BONUS || policySpec.policyID == SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS) {
                int bonusValue = (Integer)policySpec.getParameter("bonusValue");
                boolean includeAbilityClasses = (Boolean)policySpec.getParameter("includeAbilityClasses");
                WorkingSetSettings.getCurrent().setSeasonScoringAbilityBonusAgeClassScore(bonusValue);
                WorkingSetSettings.getCurrent().setSeasonScoringAbilityBonusIncludeAbilityClasses(includeAbilityClasses);
            }
            try {
                WorkingSetSettings.getCurrent().saveSettings();
            }
            catch (IOException ex) {
                DebugSupport.current().dump("Unable to save working set settings with scoring policy " + policySpec.getName() + " settings.");
                DebugSupport.current().dumpStack(ex);
            }
        }
    }

    public static void main(String[] args) {
        SeasonScoringTool.processCommandLineArgs(args);
        SeasonScoringTool.initiateSession();
        SeasonScoringTool.open();
    }

    static {
        generateHTMLReportsDefault = true;
        generateTextReportsDefault = false;
        generatePdfReportsDefault = false;
        THIS_CLASS = SeasonScoringTool.class;
        TOOL_CONSTRUCTION_ACTION = SeasonScoringTool.constructToolConstructionAction(THIS_CLASS);
        STANDINGS_FILE_NAME_PREFIX = SeasonStandings.rootReferenceName(StandingsType.SEASON);
        SUPPORTED_ORGANIZATION_TYPES = new StandingsOrganizationType[]{StandardOrganizationType.BY_CLASS, StandardOrganizationType.BY_GENDER};
        APPLICATION_TITLE = "Season Scoring Tool";
        ScoringPolicyRegistry registry = new ScoringPolicyRegistry();
        SCORING_POLICY_WC_POINTS_ALL_FINISHES = PolicyID.defineConstant("WorldCupPoints-AllFinishes", SCORING_POLICY_CATEGORY, "Total World Cup points (all finishes count)");
        ScoringPolicySpecification spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_ALL_FINISHES, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES}, ScoringPolicySpecification.createConstructionAction(AllFinishesScoringPolicy.class, new Class[]{ScoringElement.class}, new Object[]{ScoringElement.POINTS}), "World Cup points total (all finishes)", "AllFinishes");
        registry.registerPolicy(spec);
        SCORING_POLICY_WC_POINTS_BEST_N_FINISHES = PolicyID.defineConstant("WorldCupPoints-BestNFinishes", SCORING_POLICY_CATEGORY, "Total World Cup points (best N finishes count)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_BEST_N_FINISHES, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, ScoringPolicySpecification.NEED_NOT_FINISH_ALL_RACES, BestNFinishesScoringPolicy.createMaxFinishesParmSpec(10)}, ScoringPolicySpecification.createConstructionAction(BestNFinishesScoringPolicy.class, new Class[]{Integer.TYPE, ScoringElement.class}, new Object[]{new Integer(10), ScoringElement.POINTS}), "World Cup points total (best N finishes)", "BestNFinishes");
        registry.registerPolicy(spec);
        SCORING_POLICY_WC_POINTS_AGE_CLASS_ABILITY_BONUS = PolicyID.defineConstant("WorldCupPoints-AgeClassAbilityBonus", SCORING_POLICY_CATEGORY, "total World Cup points (age class bonus scored for open/super seed result)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_AGE_CLASS_ABILITY_BONUS, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, AgeClassAbilityBonusScoringPolicy.createBonusValueParmSpec(AgeClassAbilityBonusScoringPolicy.DEFAULT_AGE_CLASS_ABILITY_SCORE.intValue()), AgeClassAbilityBonusScoringPolicy.createIncludeAbilityClassesParmSpec(false)}, ScoringPolicySpecification.createConstructionAction(AgeClassAbilityBonusScoringPolicy.class), "World Cup points total (ability result bonus in age class)", "AgeClassAbilityBonusScoring");
        registry.registerPolicy(spec);
        SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS = PolicyID.defineConstant("WorldCupPoints-BestNFinishesACAB", SCORING_POLICY_CATEGORY, "Total World Cup points (best N finishes, age class bonus scored for open/super seed result)");
        spec = new ScoringPolicySpecification(SCORING_POLICY_WC_POINTS_BEST_N_FINISHES_AGE_CLASS_ABILITY_BONUS, new ParameterSpecification[]{ScoringPolicySpecification.NEED_NOT_START_ALL_RACES, BestNFinishesScoringPolicy.createMaxFinishesParmSpec(10), AgeClassAbilityBonusScoringPolicy.createBonusValueParmSpec(AgeClassAbilityBonusScoringPolicy.DEFAULT_AGE_CLASS_ABILITY_SCORE.intValue()), AgeClassAbilityBonusScoringPolicy.createIncludeAbilityClassesParmSpec(false)}, ScoringPolicySpecification.createConstructionAction(BestNFinishesAgeClassAbilityBonusScoringPolicy.class, new Class[]{Integer.TYPE}, new Object[]{new Integer(10)}), "World Cup points total (best N finishes, ability result bonus in age class)", "BestNFinishesACAB");
        registry.registerPolicy(spec);
        scoringPolicyRegistry = registry;
    }
}

