/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.io.FileType;
import com.glaivestone.mv.BooleanHolder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.StandingsOrganizationType;
import org.ussamasters.aces.racedata.reports.RaceDataReportConstants;
import org.ussamasters.aces.racedata.reports.RaceDataReportServices;
import org.ussamasters.aces.racedata.reports.SeriesScoring;
import org.ussamasters.aces.racedata.scoring.ScoringPolicyRegistry;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;
import org.ussamasters.aces.tools.foundation.models.ToolID;
import org.ussamasters.aces.tools.ui.RaceDataTool;
import org.ussamasters.aces.tools.ui.ScoredRaceSeriesModel;

public abstract class SeriesScoringTool
extends RaceDataTool {
    public static boolean dumpRacerAges = true;
    public static String racerAgeFilePath = "W:\\Working\\ACES\\ACEScoring\\AcesData\\IMM2007\\LoritzCupRacerAges.csv";
    public static FileWriter fsRacerAges;
    public static final ToolID TOOL_ID;
    protected static final FileType[] REPORT_FORMATS;
    protected static boolean generateHTMLReportsDefault;
    protected static boolean generateTextReportsDefault;
    protected static boolean generatePdfReportsDefault;
    protected ScoredRaceSeriesModel raceSeriesHolder;
    protected DefaultComboBoxModel<ScoringPolicySpecification> scoringPoliciesHolder;
    protected BooleanHolder generateHTMLReportsHolder;
    protected BooleanHolder generateTextReportsHolder;
    protected BooleanHolder generatePdfReportsHolder;
    protected StandingsOrganizationType[] supportedOrganizationTypes;
    protected ScoringPolicyRegistry scoringPoliciesRegistry;
    protected ScoringPolicySpecification selectedScoringPolicySpec;

    protected SeriesScoringTool(ToolID toolID, String title, StandingsOrganizationType[] supportedOrganizationTypes, ScoringPolicyRegistry supportedScoringPoliciesRegistry) throws RaceDataIOException {
        super(toolID, title);
        this.supportedOrganizationTypes = supportedOrganizationTypes;
        this.scoringPoliciesRegistry = supportedScoringPoliciesRegistry;
        this.initializeWorkingSetDataModels();
    }

    public abstract void addRace(RaceIdentifier var1) throws RaceDataIOException;

    protected SeriesStandingsScoringPolicy constructScoringPolicy(ScoringPolicySpecification policySpec) {
        return (SeriesStandingsScoringPolicy)policySpec.constructPolicy();
    }

    protected DefaultComboBoxModel<ScoringPolicySpecification> constructScoringPoliciesHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(this.scoringPoliciesRegistry.getPolicySpecifications());
    }

    protected abstract SeriesStandings createStandings(StandingsOrganizationType var1, ScoringPolicySpecification var2);

    public void deleteScoringReports() {
        int nDeleted = 0;
        for (int i = 0; i < RaceDataReportServices.ALL_REPORT_TYPES.length; ++i) {
            List<File> reportFiles = RaceDataReportServices.getReportFiles(this.getStandingsFileNamePrefix(), RaceDataReportServices.ALL_REPORT_TYPES[i], this.getReportsDirectory());
            for (File reportFile : reportFiles) {
                reportFile.delete();
                ++nDeleted;
            }
        }
    }

    public int generateStandingsReports(ScoringPolicySpecification policySpec) throws RaceDataIOException {
        ArrayList<FileType> reportTypes = new ArrayList<FileType>();
        if (this.getGenerateHTMLReportsHolder().getValue()) {
            reportTypes.add(RaceDataReportConstants.FILE_TYPE_HTML);
        }
        if (this.getGenerateTextReportsHolder().getValue()) {
            reportTypes.add(RaceDataReportConstants.FILE_TYPE_TEXT);
        }
        if (this.getGeneratePdfReportsHolder().getValue()) {
            reportTypes.add(RaceDataReportConstants.FILE_TYPE_PDF);
        }
        if (reportTypes.size() == 0) {
            return -1;
        }
        ArrayList<SeriesStandings> allStandings = new ArrayList<SeriesStandings>();
        for (int i = 0; i < this.supportedOrganizationTypes.length; ++i) {
            SeriesStandings standings = this.createStandings(this.supportedOrganizationTypes[i], policySpec);
            if (standings == null) continue;
            allStandings.add(standings);
        }
        if (allStandings.size() == 0) {
            return 0;
        }
        this.writeStandingsReports(new SeriesScoring((List<SeriesStandings>)allStandings), reportTypes, false);
        this.saveScoringPolicyParms(policySpec);
        return allStandings.size();
    }

    public BooleanHolder getGenerateHTMLReportsHolder() {
        return this.generateHTMLReportsHolder;
    }

    public BooleanHolder getGeneratePdfReportsHolder() {
        return this.generatePdfReportsHolder;
    }

    public BooleanHolder getGenerateTextReportsHolder() {
        return this.generateTextReportsHolder;
    }

    public RaceResult getRaceResult(RaceIdentifier aRace) {
        if (aRace == null) {
            return null;
        }
        return this.getSessionManager().getRaceResult(aRace);
    }

    public RaceSeries getRaceSeries() {
        return this.getRaceSeriesHolder().getRaceSeries();
    }

    public ScoredRaceSeriesModel getRaceSeriesHolder() {
        return this.raceSeriesHolder;
    }

    protected List<File> getResultReportFiles(ScoringPolicySpecification scoringPolicySpec, FileType reportFileType) {
        return RaceDataReportServices.getReportFiles(this.getStandingsFileNamePrefix(), scoringPolicySpec.fileNameQualifier, reportFileType, this.getReportsDirectory());
    }

    public abstract File getReportsDirectory();

    protected SeriesStandingsScoringPolicy getScoringPolicy(ScoringPolicySpecification policySpec) {
        return this.constructScoringPolicy(policySpec);
    }

    public DefaultComboBoxModel<ScoringPolicySpecification> getScoringPoliciesHolder() {
        return this.scoringPoliciesHolder;
    }

    public ScoringPolicySpecification getSelectedScoringPolicySpecification() {
        return this.selectedScoringPolicySpec;
    }

    public String getSeriesName() {
        return this.getRaceSeries().getName();
    }

    protected abstract String getStandingsFileNamePrefix();

    public boolean hasHTMLReportsAvailable(ScoringPolicySpecification policySpec) {
        return this.getResultReportFiles(policySpec, RaceDataReportConstants.FILE_TYPE_HTML).size() > 0;
    }

    public boolean hasPdfReportsAvailable(ScoringPolicySpecification policySpec) {
        return this.getResultReportFiles(policySpec, RaceDataReportConstants.FILE_TYPE_PDF).size() > 0;
    }

    public boolean hasTextReportsAvailable(ScoringPolicySpecification policySpec) {
        return this.getResultReportFiles(policySpec, RaceDataReportConstants.FILE_TYPE_TEXT).size() > 0;
    }

    protected void initializeWorkingSetDataModels() throws RaceDataIOException {
        this.scoringPoliciesHolder = this.constructScoringPoliciesHolder();
    }

    protected void initRaceSeriesHolder(RaceSeries aRaceSeries) {
        this.raceSeriesHolder = new ScoredRaceSeriesModel(aRaceSeries, this);
    }

    protected void initScoringPolicySelection(String selectedPolicyName) {
        ScoringPolicySpecification selectedSpec = null;
        if (selectedPolicyName != null) {
            selectedSpec = this.scoringPoliciesRegistry.getSpecification(selectedPolicyName);
        }
        if (selectedSpec == null) {
            selectedSpec = this.scoringPoliciesRegistry.getPolicySpecifications().get(0);
        }
        this.scoringPoliciesHolder.setSelectedItem(selectedSpec);
        this.selectScoringPolicy(selectedSpec);
    }

    protected abstract void loadScoringPolicyParms(ScoringPolicySpecification var1);

    public void openCorrectionsLog() throws IOException {
        this.openCorrectionsLog(this.getSessionManager().getSeriesDataDirectory());
    }

    public abstract void removeRace(RaceIdentifier var1) throws RaceDataIOException;

    protected abstract void saveScoringPolicyParms(ScoringPolicySpecification var1);

    public void selectScoringPolicy(ScoringPolicySpecification selectedSpec) {
        if (selectedSpec == null) {
            this.selectedScoringPolicySpec = selectedSpec;
        } else {
            this.selectedScoringPolicySpec = selectedSpec.copy();
            this.loadScoringPolicyParms(this.selectedScoringPolicySpec);
        }
    }

    protected void setRaceSeries(RaceSeries raceSeries) {
        this.getRaceSeriesHolder().setRaceSeries(raceSeries);
    }

    public void viewHTMLReports(ScoringPolicySpecification policySpec) {
        this.viewReports(policySpec, RaceDataReportConstants.FILE_TYPE_HTML);
    }

    public void viewReport(File reportFile) {
        RaceDataReportServices.openReport(reportFile);
    }

    public void viewReports(ScoringPolicySpecification policySpec, FileType reportFileType) {
        List<File> reportFiles = this.getResultReportFiles(policySpec, reportFileType);
        for (File reportFile : reportFiles) {
            this.viewReport(reportFile);
        }
    }

    public void viewPdfReports(ScoringPolicySpecification policySpec) {
        this.viewReports(policySpec, RaceDataReportConstants.FILE_TYPE_PDF);
    }

    public void viewTextReports(ScoringPolicySpecification policySpec) {
        this.viewReports(policySpec, RaceDataReportConstants.FILE_TYPE_TEXT);
    }

    protected void writeStandingsReports(SeriesScoring seriesScoring, List<FileType> reportTypes, boolean displayReports) throws RaceDataIOException {
        RaceDataReportServices.writeSeriesStandingsReports(seriesScoring, reportTypes, this.getReportsDirectory(), displayReports);
    }

    protected void writeStandingsReports(SeriesStandings standings, List<FileType> reportTypes, boolean displayReports) throws RaceDataIOException {
        boolean obsolete = true;
        if (obsolete) {
            throw new UnsupportedOperationException("OBSOLETE");
        }
        RaceDataReportServices.writeSeriesStandingsReports(new SeriesScoring(standings), RaceDataReportServices.SUPPORTED_REPORT_TYPES, this.getReportsDirectory(), displayReports);
    }

    static {
        TOOL_ID = new ToolID("SeriesScoringTool");
        REPORT_FORMATS = new FileType[]{RaceDataReportConstants.FILE_TYPE_TEXT, RaceDataReportConstants.FILE_TYPE_HTML, RaceDataReportConstants.FILE_TYPE_PDF};
        generateHTMLReportsDefault = true;
        generateTextReportsDefault = false;
        generatePdfReportsDefault = false;
    }
}

