/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.lang.SystemConstants;
import com.glaivestone.javax.swing.PlainTextDocument;
import com.glaivestone.mv.BooleanHolder;
import com.glaivestone.mv.swing.ListHolder;
import com.glaivestone.mv.swing.TableHolder;
import com.glaivestone.mv.swing.TableRow;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.ussamasters.aces.racedata.interchange.FISXMLDataImporter;
import org.ussamasters.aces.racedata.interchange.TimingDataFormat;
import org.ussamasters.aces.racedata.interchange.TimingDataSource;
import org.ussamasters.aces.racedata.interchange.TimingSystemCSVDataImporter;
import org.ussamasters.aces.racedata.interchange.TimingSystemDataImporter;
import org.ussamasters.aces.racedata.interchange.USSASkiDataImporter;
import org.ussamasters.aces.racedata.io.CSVSpecDataReader;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.models.RaceDataComponentModel;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.RaceResultsImportTool;

public class TimingDataImportModel
extends RaceDataComponentModel {
    private static final Class<TimingDataImportModel> THIS_CLASS = TimingDataImportModel.class;
    public static final String BIB_IMPORT_MAPPING_SPECS_FILE_NAME = RaceDataIOConstants.FILE_TYPE_CFG.composeFileName("BibNumberImportMapping");
    protected static final String RESOURCE_NAME_BIB_NUMBER_MAPPING_TABLE = THIS_CLASS.getName() + ".BibNumberMappingTable";
    protected static final String COLUMN_SPECS_DIRECTORY_NAME = "RaceResultsImportColumnSpecs";
    protected static final String LAST_SELECTED_CSV_COLUMN_ORDER_TOOL_OPTION = "selectedCSVColumnOrder";
    protected static final Map<TimingDataFormat, String[]> DEFAULT_COLUMN_NAME_SPECS = new HashMap<TimingDataFormat, String[]>(){
        {
            this.put(TimingDataFormat.NULL, new String[0]);
            this.put(TimingDataFormat.CSV, TimingSystemCSVDataImporter.SPLIT_SECOND_TIMING_DATA_COLUMN_NAMES);
            this.put(TimingDataFormat.SKIDATA, USSASkiDataImporter.COMPETITOR_ENTRY_COLUMN_NAMES);
            this.put(TimingDataFormat.FISXML, FISXMLDataImporter.COMPETITOR_ENTRY_COLUMN_NAMES);
        }
    };
    protected static final String COLUMN_SPECS_SOURCE_SPEC_FILE = "file";
    protected static final String COLUMN_SPECS_SOURCE_TIMING_DATA = "timingData";
    protected static final String INTERNAL_RACE_DATA_1RUN_COLUMN_ORDER_FILE_NAME = "NormalizedInternalResultsColumnOrder-1Run.cfg";
    protected static final String INTERNAL_RACE_DATA_2RUN_COLUMN_ORDER_FILE_NAME = "NormalizedInternalResultsColumnOrder.cfg";
    protected static final String START_GROUP_SPECS_DIRECTORY_NAME = "StartGroupCodeSpecs";
    protected static final String DEFAULT_START_GROUP_SPECS_FILE_NAME = "StandardStartGroupCodes.cfg";
    protected static final String LAST_SELECTED_START_GROUP_SPECS_TOOL_OPTION = "selectedStartGroupCodes";
    protected static final String[] START_GROUP_CODES_COLUMN_NAMES = new String[]{"StartGroupCode", "Class"};
    protected static final String[] DISABLED_START_GROUP_CODES_COLUMN_NAMES = new String[0];
    protected static final int INDEX_START_GROUP_CODE = 0;
    protected static final int INDEX_START_GROUP_AGE_CLASS = 1;
    protected static final int START_GROUP_CODES_ROW_SIZE = START_GROUP_CODES_COLUMN_NAMES.length;
    protected static final Comparator<TableRow> START_GROUP_CODES_SORTER = new Comparator<TableRow>(){

        @Override
        public int compare(TableRow tr1, TableRow tr2) {
            return ((String)tr1.get(0)).compareTo((String)tr2.get(0));
        }
    };
    protected int numberOfRuns;
    protected Class<? extends RaceClass<?>> raceClassClass;
    protected BooleanHolder hasTimingDataHolder;
    protected TimingDataFormat timingDataFormat;
    protected File[] timingDataFiles;
    protected PlainTextDocument timingDataFileNamesModel;
    protected PlainTextDocument timingDataModel;
    protected String columnSpecsSource;
    protected File timingDataColumnSpecsDirectory;
    protected String[] timingDataColumnNames;
    protected ListHolder timingDataColumnsModel;
    protected File startGroupSpecsDirectory;
    protected File startGroupSpecsFile;
    protected Map<String, String> startGroupCodesMap;
    protected TableHolder startGroupCodesMapHolder;

    public TimingDataImportModel(Class<? extends RaceClass<?>> raceClassClass) {
        this(2, raceClassClass);
    }

    public TimingDataImportModel(int numberOfRuns, Class<? extends RaceClass<?>> raceClassClass) {
        this.setNumberOfRuns(numberOfRuns);
        this.setRaceClassClass(raceClassClass);
        this.initializeModels();
    }

    protected List<TableRow> buildStartGroupMappingTableRows(Map<String, String> mappingTable) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>();
        for (Map.Entry<String, String> entry : mappingTable.entrySet()) {
            tableRows.add(this.constructStartGroupCodeRow(entry.getKey(), entry.getValue()));
        }
        Collections.sort(tableRows, START_GROUP_CODES_SORTER);
        return tableRows;
    }

    protected String composeStartGroupsSpecFileDescription(File aFile) {
        return FileSystemReference.computeRelativePath(aFile, this.getSessionManager().getUserDataDirectory());
    }

    protected String composeTimingDataFileDescription(File aFile) {
        return FileSystemReference.computeRelativePath(aFile, this.getSessionManager().getUserDataDirectory());
    }

    protected String composeTimingDataArchivePreamble() {
        String IMPORT_HEADER_TITLE = "Timing Data Import";
        String IMPORT_HEADER_INPUT_TAG = "Input";
        String IMPORT_HEADER_CSV_COLUMN_ORDER_TAG = "CSV Column Order";
        String IMPORT_HEADER_START_GROUP_SPECS_TAG = "Start group specs file";
        StringBuffer sb = new StringBuffer(512);
        sb.append("# ");
        sb.append(IMPORT_HEADER_TITLE + " (" + RaceDate.today().toStandardString() + ")");
        sb.append(SystemConstants.NEW_LINE);
        for (int i = 0; i < this.timingDataFiles.length; ++i) {
            sb.append("# ");
            sb.append(IMPORT_HEADER_INPUT_TAG + ": " + this.composeTimingDataFileDescription(this.timingDataFiles[i]));
            sb.append(SystemConstants.NEW_LINE);
        }
        if (this.timingDataFormat == TimingDataFormat.CSV) {
            sb.append("# ");
            sb.append(IMPORT_HEADER_CSV_COLUMN_ORDER_TAG);
            sb.append(":");
            sb.append(SystemConstants.NEW_LINE);
            sb.append("# ");
            sb.append(RaceDataIOServices.toCSVString(this.timingDataColumnNames));
            sb.append(SystemConstants.NEW_LINE);
        }
        if (this.startGroupSpecsFile != null) {
            sb.append("# ");
            sb.append(IMPORT_HEADER_START_GROUP_SPECS_TAG + ": " + this.composeStartGroupsSpecFileDescription(this.startGroupSpecsFile));
            sb.append(SystemConstants.NEW_LINE);
        }
        sb.append("# ");
        sb.append(SystemConstants.NEW_LINE);
        return sb.toString();
    }

    protected TableRow constructStartGroupCodeRow(String startGroupCode, String raceClassName) {
        TableRow aRow = new TableRow(null, START_GROUP_CODES_ROW_SIZE);
        aRow.add(0, startGroupCode);
        aRow.add(1, raceClassName);
        return aRow;
    }

    public File defaultColumnSpecsDirectory() {
        return this.timingDataColumnSpecsDirectory;
    }

    public File defaultStartGroupSpecsDirectory() {
        return this.startGroupSpecsDirectory;
    }

    public File defaultStartGroupSpecsFile() {
        String specFileName = this.getSessionManager().getToolOption(RaceResultsImportTool.TOOL_ID, LAST_SELECTED_START_GROUP_SPECS_TOOL_OPTION, DEFAULT_START_GROUP_SPECS_FILE_NAME);
        return new File(this.startGroupSpecsDirectory, specFileName);
    }

    public File defaultTimingDataFileDirectory() {
        File aDirectory = this.getSessionManager().getTimingSystemFilesSourceDirectory();
        if (aDirectory == null || !aDirectory.exists()) {
            aDirectory = this.getSessionManager().getUserDataDirectory();
        }
        return aDirectory;
    }

    public File defaultColumnSpecFile(File timingDataFilesDirectory) {
        if (!this.isTimingDataColumnSpecAllowed()) {
            return null;
        }
        if (timingDataFilesDirectory.equals(this.getSessionManager().getRaceDataDirectory())) {
            String internalColumnOrderSpecFileName = this.numberOfRuns == 1 ? INTERNAL_RACE_DATA_1RUN_COLUMN_ORDER_FILE_NAME : INTERNAL_RACE_DATA_2RUN_COLUMN_ORDER_FILE_NAME;
            File columnSpecFile = new File(this.defaultColumnSpecsDirectory(), internalColumnOrderSpecFileName);
            return columnSpecFile.exists() ? columnSpecFile : null;
        }
        return null;
    }

    protected Map<String, String> getBibNumberMappingTable() throws RaceDataIOException {
        Map<String, String> mappingTable = (Map<String, String>)this.getSessionManager().getWorkingSetResource(RESOURCE_NAME_BIB_NUMBER_MAPPING_TABLE);
        if (mappingTable == null) {
            File specFile = new File(this.getSessionManager().getWorkingSetConfigurationDirectory(), BIB_IMPORT_MAPPING_SPECS_FILE_NAME);
            mappingTable = TimingSystemDataImporter.loadBibNumberMappingTable(specFile);
            if (mappingTable == null) {
                mappingTable = Collections.emptyMap();
            }
            this.getSessionManager().registerWorkingSetResource(RESOURCE_NAME_BIB_NUMBER_MAPPING_TABLE, mappingTable);
        }
        return mappingTable;
    }

    public BooleanHolder getHasTimingDataHolder() {
        return this.hasTimingDataHolder;
    }

    public Map<String, String> getStartGroupCodesMap() {
        return this.startGroupCodesMap;
    }

    public TableHolder getStartGroupCodesMapHolder() {
        return this.startGroupCodesMapHolder;
    }

    public String getTimingData() {
        return this.getTimingDataModel().getText();
    }

    public String[] getTimingDataColumnNames() {
        return this.timingDataColumnNames;
    }

    public ListHolder getTimingDataColumnsModel() {
        return this.timingDataColumnsModel;
    }

    public PlainTextDocument getTimingDataFileNamesModel() {
        return this.timingDataFileNamesModel;
    }

    public TimingDataFormat getTimingDataFormat() {
        return this.timingDataFormat;
    }

    public PlainTextDocument getTimingDataModel() {
        return this.timingDataModel;
    }

    public TimingSystemDataImporter importRaceResult(RaceDescriptor raceSpecification) throws RaceDataIOException {
        TimingSystemDataImporter loader;
        String timingData = this.getTimingData();
        SeasonIdentifier season = this.getSessionManager().getRaceCalendar().getSeason();
        if (this.timingDataFormat == TimingDataFormat.CSV) {
            loader = TimingSystemCSVDataImporter.importTimingData(timingData, this.getTimingDataColumnNames(), this.getBibNumberMappingTable(), this.getStartGroupCodesMap(), raceSpecification, season);
        } else if (this.timingDataFormat == TimingDataFormat.SKIDATA) {
            loader = USSASkiDataImporter.importTimingData(timingData, this.getBibNumberMappingTable(), this.getStartGroupCodesMap(), raceSpecification, season);
        } else if (this.timingDataFormat == TimingDataFormat.FISXML) {
            loader = FISXMLDataImporter.importTimingData(timingData, this.getBibNumberMappingTable(), this.getStartGroupCodesMap(), raceSpecification, season);
        } else {
            throw new IllegalStateException("Unknown timing system data format for race results: " + this.timingDataFormat);
        }
        if (this.startGroupSpecsFile != null) {
            this.getSessionManager().saveToolOption(RaceResultsImportTool.TOOL_ID, LAST_SELECTED_START_GROUP_SPECS_TOOL_OPTION, this.startGroupSpecsFile.getName());
        }
        return loader;
    }

    public TimingSystemDataImporter importRacerList(boolean processNonStarters) throws RaceDataIOException {
        TimingSystemDataImporter loader;
        String timingData = this.getTimingData();
        SeasonIdentifier season = this.getSessionManager().getRaceCalendar().getSeason();
        if (this.timingDataFormat == TimingDataFormat.CSV) {
            loader = TimingSystemCSVDataImporter.importCompetitorData(timingData, this.getTimingDataColumnNames(), this.getBibNumberMappingTable(), this.getStartGroupCodesMap(), this.raceClassClass, season, processNonStarters);
        } else if (this.timingDataFormat == TimingDataFormat.SKIDATA) {
            loader = USSASkiDataImporter.importCompetitorData(timingData, this.getBibNumberMappingTable(), this.raceClassClass, season, processNonStarters);
        } else if (this.timingDataFormat == TimingDataFormat.FISXML) {
            loader = FISXMLDataImporter.importCompetitorData(timingData, this.getBibNumberMappingTable(), this.raceClassClass, season, processNonStarters);
        } else {
            throw new IllegalStateException("Unknown timing system data format for racer list import: " + this.timingDataFormat);
        }
        return loader;
    }

    protected void initializeModels() {
        this.hasTimingDataHolder = new BooleanHolder(false);
        this.timingDataFormat = TimingDataFormat.NULL;
        this.timingDataFiles = null;
        this.timingDataFileNamesModel = new PlainTextDocument();
        this.timingDataModel = new PlainTextDocument();
        this.columnSpecsSource = null;
        this.timingDataColumnSpecsDirectory = new File(this.getSessionManager().getUserConfigurationDirectory(), COLUMN_SPECS_DIRECTORY_NAME);
        this.timingDataColumnsModel = new ListHolder();
        this.setTimingDataColumnNames(DEFAULT_COLUMN_NAME_SPECS.get(this.timingDataFormat));
        this.startGroupSpecsDirectory = new File(this.getSessionManager().getUserConfigurationDirectory(), START_GROUP_SPECS_DIRECTORY_NAME);
        this.startGroupSpecsFile = null;
        this.startGroupCodesMap = null;
        this.startGroupCodesMapHolder = new TableHolder();
    }

    public boolean isStartGroupCodesMapAllowed() {
        return this.timingDataFormat == TimingDataFormat.SKIDATA || this.isStartGroupCodesMapRequired();
    }

    public boolean isStartGroupCodesMapDefined() {
        return this.startGroupCodesMap != null && this.startGroupCodesMap.size() > 0;
    }

    public boolean isStartGroupCodesMapExpected() {
        return this.isStartGroupCodesMapRequired() || RaceClass.getAbilityGroupClassConstants(this.raceClassClass) != null;
    }

    public boolean isStartGroupCodesMapRequired() {
        String startGroupsColumnName = "StartGroupCode";
        return this.timingDataFormat == TimingDataFormat.CSV && this.timingDataColumnsModel.indexOf(startGroupsColumnName) != -1;
    }

    public boolean isTimingDataColumnSpecAllowed() {
        return this.isTimingDataColumnSpecRequired();
    }

    public boolean isTimingDataColumnSpecRequired() {
        return this.timingDataFormat == TimingDataFormat.CSV;
    }

    public void loadColumnSpecs() throws IOException {
        List<String[]> specsList;
        boolean inputLineWasCommented;
        String colOrderSpec;
        String timingData = this.getTimingData();
        BufferedReader aReader = new BufferedReader(new StringReader(timingData));
        try {
            colOrderSpec = aReader.readLine();
        }
        catch (IOException ex) {
            colOrderSpec = "";
        }
        if (colOrderSpec != null) {
            colOrderSpec = colOrderSpec.trim();
        }
        if (colOrderSpec == null || colOrderSpec.length() == 0) {
            throw new IOException("No column specifications found in first line of timing data");
        }
        boolean bl = inputLineWasCommented = colOrderSpec.charAt(0) == '#';
        if (inputLineWasCommented) {
            colOrderSpec = colOrderSpec.substring(1, colOrderSpec.length());
        }
        if ((specsList = CSVSpecDataReader.loadValues(colOrderSpec)).size() == 0) {
            throw new IOException("No column specifications found in first line of timing data");
        }
        this.columnSpecsSource = COLUMN_SPECS_SOURCE_TIMING_DATA;
        this.setTimingDataColumnNames(specsList.get(0));
        if (!inputLineWasCommented) {
            try {
                this.getTimingDataModel().insertString(0, "#", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void loadColumnSpecs(File specsFile) throws IOException {
        List<String[]> specsList = CSVSpecDataReader.loadValues(specsFile);
        if (specsList.size() == 0) {
            throw new IOException("No column specifications found in " + specsFile.getAbsolutePath());
        }
        if (specsList.size() > 1) {
            throw new IOException("Invalid column specifications file: " + specsFile.getAbsolutePath());
        }
        this.columnSpecsSource = COLUMN_SPECS_SOURCE_SPEC_FILE;
        this.setTimingDataColumnNames(specsList.get(0));
    }

    public void loadColumnSpecs(String columnSpecsFileName) throws IOException {
        this.loadColumnSpecs(new File(this.defaultColumnSpecsDirectory(), columnSpecsFileName));
    }

    public void loadStartGroupSpecs(File aFile) throws RaceDataIOException {
        Map<String, String> mappingTable = TimingSystemDataImporter.loadStartGroupCodeMap(aFile);
        List<TableRow> tableRows = this.buildStartGroupMappingTableRows(mappingTable);
        this.startGroupCodesMap = mappingTable;
        this.getStartGroupCodesMapHolder().clear();
        this.getStartGroupCodesMapHolder().addAll(tableRows);
        this.startGroupSpecsFile = aFile;
    }

    public void loadTimingData(File[] files) throws IOException {
        String inputData;
        String inputFilesDescription;
        TimingDataFormat inputFormat;
        int nFiles = files.length;
        TimingDataFormat previousTimingDataFormat = this.timingDataFormat;
        if (nFiles == 1) {
            File aFile = files[0];
            TimingDataSource timingDataSource = TimingDataSource.forFile(aFile);
            inputFormat = timingDataSource.getFormat();
            inputFilesDescription = this.composeTimingDataFileDescription(aFile);
            inputData = timingDataSource.getTimingData();
        } else {
            StringBuffer sbFilesDescription = new StringBuffer();
            StringBuffer sbTimingData = new StringBuffer();
            inputFormat = TimingDataFormat.NULL;
            for (int i = 0; i < files.length; ++i) {
                File aFile = files[i];
                TimingDataSource timingDataSource = TimingDataSource.forFile(aFile);
                if (i == 0) {
                    inputFormat = timingDataSource.getFormat();
                    sbFilesDescription.append(this.composeTimingDataFileDescription(aFile));
                } else {
                    if (timingDataSource.getFormat() != inputFormat) {
                        throw new IOException("Selected files must have the same timing data format");
                    }
                    sbFilesDescription.append(", ");
                    sbFilesDescription.append(aFile.getName());
                    sbTimingData.append(SystemConstants.NEW_LINE);
                }
                sbTimingData.append("# ");
                sbTimingData.append(aFile.getName());
                sbTimingData.append(SystemConstants.NEW_LINE);
                sbTimingData.append(timingDataSource.getTimingData());
            }
            inputFilesDescription = sbFilesDescription.toString();
            inputData = sbTimingData.toString();
        }
        this.timingDataFormat = inputFormat;
        this.timingDataFiles = files;
        this.getTimingDataFileNamesModel().setText(inputFilesDescription);
        this.getTimingDataModel().setText(inputData);
        if (this.timingDataFormat != previousTimingDataFormat) {
            this.setTimingDataColumnNames(DEFAULT_COLUMN_NAME_SPECS.get(this.timingDataFormat));
        }
        this.getHasTimingDataHolder().setValue(true);
    }

    public void setNumberOfRuns(int numberOfRuns) {
        this.numberOfRuns = numberOfRuns;
    }

    public void setRaceClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        this.raceClassClass = raceClassClass;
    }

    protected void setTimingDataColumnNames(String[] columnNames) {
        this.timingDataColumnNames = columnNames;
        this.timingDataColumnsModel.clear();
        this.timingDataColumnsModel.addAll(Arrays.asList(columnNames));
    }

    public void updateStartGroupSpecs(boolean enabled) {
        if (enabled) {
            if (this.startGroupCodesMap == null) {
                this.getStartGroupCodesMapHolder().setColumnNames(START_GROUP_CODES_COLUMN_NAMES);
            }
        } else {
            if (this.startGroupCodesMap != null) {
                this.startGroupCodesMap = null;
                this.getStartGroupCodesMapHolder().clear();
                this.startGroupSpecsFile = null;
            }
            this.getStartGroupCodesMapHolder().setColumnNames(DISABLED_START_GROUP_CODES_COLUMN_NAMES);
        }
    }

    public void validateSpecifications(ValidationResult validationResult) {
        if (this.isStartGroupCodesMapRequired() && !this.isStartGroupCodesMapDefined()) {
            validationResult.reportProblem("You must specify how to map start group codes to age classes in order to interpret values in the timing data StartGroupCode field.");
            return;
        }
    }
}

