/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui;

import com.glaivestone.mv.IntegerHolder;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.RaceDataDialog;

public class WorkingSetSettingsEditor
extends RaceDataDialog {
    private static List<StandingsType> seriesTypesList;
    protected DefaultComboBoxModel<RaceOrganization> seriesOrganizerHolder;
    protected DefaultComboBoxModel<RaceClassType> seriesRaceClassHolder;
    protected DefaultComboBoxModel<WorldCupPointsType> worldCupPointsHolder;
    protected DefaultComboBoxModel<CourseArrangement> standardCourseArrangementHolder;
    protected DefaultComboBoxModel<StandingsType> seriesTypeHolder;
    protected IntegerHolder seasonYearHolder;

    protected WorkingSetSettingsEditor(Window aWindow) {
        super(aWindow);
    }

    protected static void initStaticData() {
        seriesTypesList = new ArrayList<StandingsType>();
        seriesTypesList.add(StandingsType.SERIES);
        seriesTypesList.add(StandingsType.SEASON);
    }

    protected DefaultComboBoxModel<CourseArrangement> constructCourseArrangementsHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(this.getToolServices().getCourseArrangementsList());
    }

    protected DefaultComboBoxModel<RaceClassType> constructRaceClassClassesHolder(RaceClassType selectedRaceClass) {
        List<RaceClassType> raceClassTypesList = this.getToolServices().getRaceClassTypesList();
        if (selectedRaceClass != null && !raceClassTypesList.contains(selectedRaceClass)) {
            raceClassTypesList.add(selectedRaceClass);
        }
        return this.getToolUIModelServices().constructComboBoxListHolder(raceClassTypesList);
    }

    protected DefaultComboBoxModel<RaceOrganization> constructSeriesOrganizersHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(this.getToolServices().getRaceOrganizersList());
    }

    protected DefaultComboBoxModel<StandingsType> constructSeriesTypesHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(seriesTypesList);
    }

    protected DefaultComboBoxModel<WorldCupPointsType> constructWorldCupPointsHolder() {
        return this.getToolUIModelServices().constructComboBoxListHolder(this.getToolServices().getWorldCupPointsTypesList());
    }

    public DefaultComboBoxModel<RaceOrganization> getSeriesOrganizerHolder() {
        return this.seriesOrganizerHolder;
    }

    public DefaultComboBoxModel<RaceClassType> getSeriesRaceClassHolder() {
        return this.seriesRaceClassHolder;
    }

    public IntegerHolder getSeasonYearHolder() {
        return this.seasonYearHolder;
    }

    public DefaultComboBoxModel<StandingsType> getSeriesTypeHolder() {
        return this.seriesTypeHolder;
    }

    public DefaultComboBoxModel<CourseArrangement> getStandardCourseArrangementHolder() {
        return this.standardCourseArrangementHolder;
    }

    public RaceOrganization getSelectedSeriesOganizer() {
        return (RaceOrganization)this.seriesOrganizerHolder.getSelectedItem();
    }

    public Class<? extends RaceClass<?>> getSelectedSeriesRaceClass(SeasonIdentifier season) {
        RaceClassType raceClassType = this.getSelectedSeriesRaceClassType();
        return SeasonConfiguration.getSeasonConfig(season).getRaceClassClass(raceClassType);
    }

    protected RaceClassType getSelectedSeriesRaceClassType() {
        return (RaceClassType)this.seriesRaceClassHolder.getSelectedItem();
    }

    public CourseArrangement getSelectedCourseArrangement() {
        return (CourseArrangement)this.standardCourseArrangementHolder.getSelectedItem();
    }

    public WorldCupPointsType getSelectedWorldCupPoints() {
        return (WorldCupPointsType)((Object)this.getWorldCupPointsHolder().getSelectedItem());
    }

    public StandingsType getSelectedSeriesType() {
        return (StandingsType)this.seriesTypeHolder.getSelectedItem();
    }

    public DefaultComboBoxModel<WorldCupPointsType> getWorldCupPointsHolder() {
        return this.worldCupPointsHolder;
    }

    protected void initRaceSeriesSettingsModels(WorkingSetSettings wsSettings) {
        RaceClassType raceClassType = RaceClassRegistry.current().getRaceClassType(wsSettings.getRaceClassClass());
        this.seriesOrganizerHolder = this.constructSeriesOrganizersHolder();
        this.seriesOrganizerHolder.setSelectedItem(wsSettings.getOrganizer());
        this.seriesRaceClassHolder = this.constructRaceClassClassesHolder(raceClassType);
        this.worldCupPointsHolder = this.constructWorldCupPointsHolder();
        this.seriesRaceClassHolder.setSelectedItem(raceClassType);
        this.worldCupPointsHolder.setSelectedItem((Object)wsSettings.getWorldCupPointsType());
        this.standardCourseArrangementHolder = this.constructCourseArrangementsHolder();
        this.standardCourseArrangementHolder.setSelectedItem(wsSettings.getStandardCourseArrangement());
        this.seriesTypeHolder = this.constructSeriesTypesHolder();
        this.seriesTypeHolder.setSelectedItem(wsSettings.getType());
        this.seasonYearHolder = new IntegerHolder(wsSettings.getSeason().getSeasonYear());
    }

    static {
        WorkingSetSettingsEditor.initStaticData();
    }
}

