/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.MergeRacesDialog;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;
import org.ussamasters.aces.tools.ui.swing.RaceSpecificationPanel;

public class MergeRacesDialogWindow
extends RSTDialogWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 8000.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 6000.0f;
    protected RaceSpecificationPanel raceSpecificationPanel;
    protected JScrollPane racesListScrollPane;
    protected JTable racesListTablePane;
    protected OKCancelButtonsPanel operationButtonsPanel;

    public MergeRacesDialogWindow() {
    }

    public MergeRacesDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public MergeRacesDialogWindow(Frame arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.setTitle("Merge Races");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceSpecificationPanel();
        this.initRacesListTablePane();
        this.initOperationButtonsPanel();
    }

    protected void initRaceSpecificationPanel() {
        this.raceSpecificationPanel = new RaceSpecificationPanel();
        FramerFactory.current.installComponent(this.raceSpecificationPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, 2900.0f);
        this.raceSpecificationPanel.setMinimumSize(new Dimension(1040, 964));
        this.raceSpecificationPanel.setPreferredSize(new Dimension(1040, 964));
    }

    protected void initRacesListTablePane() {
        this.racesListScrollPane = new JScrollPane();
        FramerFactory.current.installComponent(this.racesListScrollPane, this.contentPanel, 1, 170, 0.0f, 3000.0f, 0.0f, 510.0f);
        this.racesListTablePane = new JTable();
        this.racesListScrollPane.setViewportView(this.racesListTablePane);
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1050.0f, 990.0f, 8000.0f, 6000.0f);
    }

    protected MergeRacesDialog myApp() {
        return (MergeRacesDialog)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.raceSpecificationPanel.setModel(this.myApp().getRaceSpecificationModel());
        this.racesListTablePane.setModel(this.myApp().getRacesListHolder().getDataModel());
        this.racesListTablePane.setSelectionModel(this.myApp().getRacesListHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.racesListTablePane);
        this.configureConnections();
    }

    protected void configureConnections() {
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (MergeRacesDialogWindow.this.acceptResult()) {
                    MergeRacesDialogWindow.this.requestCloseWindow();
                }
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MergeRacesDialogWindow.this.requestCloseWindow();
            }
        });
    }

    protected boolean acceptResult() {
        UserConfirmationValidationResolver validationResolver = this.myToolServices().constructUserConfirmationValidationResolver(this.dialogWindow);
        ValidationResult validationResult = this.myApp().validateResult(validationResolver);
        if (validationResult.failed()) {
            if (validationResolver.numberOfDenials == 0) {
                MessageDialog.displayWarning("Merge Failed", validationResult.getMessage(), this.dialogWindow);
            }
            return false;
        }
        this.myApp().acceptResult();
        return true;
    }
}

