/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.foundation.swing.UserConfirmationValidationResolver;
import org.ussamasters.aces.tools.ui.NewScoringEventDialog;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;

public class NewScoringEventDialogWindow
extends RSTDialogWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 6780.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 3180.0f;
    protected Map<String, Object> propertyValueItemMap;
    protected JLabel eventNameLabel;
    protected JTextField eventNameField;
    protected JLabel eventFileNameLabel;
    protected JTextField eventFileNameField;
    protected JTextField eventDescriptionField;
    protected JLabel descriptionLabel;
    protected JLabel raceClassesLabel;
    protected JComboBox<RaceClassType> raceClassesComboBox;
    protected OKCancelButtonsPanel operationButtonsPanel;

    public NewScoringEventDialogWindow() {
    }

    public NewScoringEventDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public NewScoringEventDialogWindow(Frame arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.dialogWindow.setTitle("New Combined Event");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initEventNameItems();
        this.initEventFileNameItems();
        this.initEventDescriptionItems();
        this.initRaceClassesItems();
        this.initOperationButtonsPanel();
    }

    protected void initEventNameItems() {
        this.eventNameLabel = new JLabel();
        this.eventNameLabel.setName("eventNameLabel");
        this.eventNameLabel.setText("Event name");
        FramerFactory.current.installComponent(this.eventNameLabel, this.contentPanel, 1, 136, 0.0f, 0.0f, 1185.0f, 315.0f);
        this.eventNameField = new JTextField();
        this.eventNameField.setName("eventNameField");
        this.eventNameField.setColumns(10);
        FramerFactory.current.installComponent(this.eventNameField, this.contentPanel, 1, 168, 1410.0f, 0.0f, 0.0f, 315.0f);
    }

    protected void initEventFileNameItems() {
        this.eventFileNameLabel = new JLabel();
        this.eventFileNameLabel.setName("eventFileNameLabel");
        this.eventFileNameLabel.setText("File name");
        FramerFactory.current.installComponent(this.eventFileNameLabel, this.contentPanel, 1, 136, 0.0f, 375.0f, 1305.0f, 315.0f);
        this.eventFileNameField = new JTextField();
        this.eventFileNameField.setName("eventFileNameField");
        this.eventFileNameField.setColumns(10);
        FramerFactory.current.installComponent(this.eventFileNameField, this.contentPanel, 1, 168, 1410.0f, 375.0f, 2760.0f, 315.0f);
    }

    protected void initEventDescriptionItems() {
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setName("descriptionLabel");
        this.descriptionLabel.setText("Description");
        FramerFactory.current.installComponent(this.descriptionLabel, this.contentPanel, 1, 136, 0.0f, 840.0f, 1275.0f, 315.0f);
        this.eventDescriptionField = new JTextField();
        this.eventDescriptionField.setName("eventDescriptionField");
        this.eventDescriptionField.setColumns(10);
        FramerFactory.current.installComponent(this.eventDescriptionField, this.contentPanel, 1, 168, 1410.0f, 840.0f, 0.0f, 315.0f);
    }

    public void initRaceClassesItems() {
        this.raceClassesLabel = new JLabel();
        this.raceClassesLabel.setName("raceClassesLabel");
        this.raceClassesLabel.setText("Classes");
        FramerFactory.current.installComponent(this.raceClassesLabel, this.contentPanel, 1, 136, 0.0f, 1320.0f, 855.0f, 315.0f);
        this.raceClassesComboBox = new JComboBox();
        this.raceClassesComboBox.setName("raceClassesComboBox");
        this.myToolServices().installRaceClassTypeRenderer(this.raceClassesComboBox);
        FramerFactory.current.installComponent(this.raceClassesComboBox, this.contentPanel, 1, 168, 1410.0f, 1320.0f, 1020.0f, 345.0f);
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        this.operationButtonsPanel.setName("operationButtonsPanel");
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1530.0f, 1230.0f, 6780.0f, 3180.0f);
    }

    protected NewScoringEventDialog myApp() {
        return (NewScoringEventDialog)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.propertyValueItemMap = this.constructPropertyValueItemMap();
        this.dialogWindow.setTitle(this.myApp().getTitle());
        this.eventNameField.setDocument(this.myApp().getEventNameHolder());
        this.eventFileNameField.setDocument(this.myApp().getEventFileNameHolder());
        this.eventDescriptionField.setDocument(this.myApp().getEventDescriptionHolder());
        SwingPatches.installComboBoxModel(this.raceClassesComboBox, this.myApp().getEventRaceClassHolder());
        this.configureConnections();
    }

    protected Map<String, Object> constructPropertyValueItemMap() {
        HashMap<String, Object> mappingTable = new HashMap<String, Object>();
        mappingTable.put("eventName", this.eventNameField);
        mappingTable.put("eventFileName", this.eventFileNameField);
        return mappingTable;
    }

    protected void configureConnections() {
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (NewScoringEventDialogWindow.this.acceptChanges()) {
                    NewScoringEventDialogWindow.this.requestCloseWindow();
                }
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewScoringEventDialogWindow.this.requestCloseWindow();
            }
        });
    }

    protected boolean acceptChanges() {
        UserConfirmationValidationResolver validationResolver = this.myToolServices().constructUserConfirmationValidationResolver(this.dialogWindow);
        ValidationResult validationResult = this.myApp().validateChanges(validationResolver);
        if (validationResult.failed()) {
            Component valueItem = (Component)this.propertyValueItemMap.get(validationResult.getAspect());
            if (valueItem != null) {
                if (valueItem instanceof JTextField) {
                    ((JTextField)valueItem).selectAll();
                }
                valueItem.requestFocus();
            }
            if (validationResolver.numberOfDenials == 0) {
                MessageDialog.displayWarning("Invalid Combined Event Definition", validationResult.getMessage(), this.dialogWindow);
            }
            return false;
        }
        try {
            this.myApp().acceptChanges();
        }
        catch (IOException ex) {
            this.reportCombinedEventCreationFailed(ex);
            return false;
        }
        catch (RaceDataIOException ex) {
            this.reportCombinedEventCreationFailed(ex);
            return false;
        }
        catch (RuntimeException ex) {
            this.reportCombinedEventCreationFailed(ex);
            return false;
        }
        return true;
    }

    protected void reportCombinedEventCreationFailed(Exception ex) {
        DebugSupport.current().dumpStack(ex);
        MessageDialog.displayError("Combined Event Creation Failed", "Unable to create new combined event: " + ex.getMessage(), this.dialogWindow);
    }
}

