/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.tools.ui.RaceIdentifierModel;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;

public class RaceIdentifierPanel
extends RSTPanel {
    public static final float DEFAULT_HEIGHT_TWIPS = 2130.0f;
    protected RaceIdentifierModel raceModel;
    protected JPanel raceDatePanel;
    protected JLabel yearLabel;
    protected JComboBox<String> yearComboBox;
    protected JLabel monthLabel;
    protected JComboBox<String> monthComboBox;
    protected JLabel dayOfMonthLabel;
    protected JComboBox<String> dayOfMonthComboBox;
    protected JLabel raceTypeLabel;
    protected JComboBox<RaceType> raceTypeComboBox;
    protected JLabel qualifierLabel;
    protected JComboBox<String> qualifierField;
    protected JLabel raceLocationLabel;
    protected JComboBox<RaceLocation> raceLocationComboBox;

    public RaceIdentifierPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setName("raceIdentifierPanel");
        this.setLayout(FramerFactory.current.newLayoutManager());
    }

    protected void initChildComponents() {
        this.initRaceDatePanel();
        this.initRaceLocationItems();
        this.initRaceTypeItems();
        this.initQualifierItems();
    }

    protected void initRaceDatePanel() {
        this.raceDatePanel = new JPanel();
        this.raceDatePanel.setName("raceDatePanel");
        this.raceDatePanel.setBorder(BorderFactory.createTitledBorder("Date"));
        FramerFactory.current.installComponent(this.raceDatePanel, this, 1, 136, 0.0f, 0.0f, 6432.0f, 840.0f);
        this.raceDatePanel.setLayout(FramerFactory.current.newLayoutManager());
        this.monthLabel = new JLabel();
        this.monthLabel.setName("monthLabel");
        this.monthLabel.setText("Month:");
        FramerFactory.current.installComponent(this.monthLabel, this.raceDatePanel, 1, 130, 30.0f, 315.0f, 645.0f, 135.0f);
        this.monthComboBox = new JComboBox();
        this.monthComboBox.setName("monthComboBox");
        FramerFactory.current.installComponent(this.monthComboBox, this.raceDatePanel, 1, 130, 780.0f, 348.0f, 1416.0f, 120.0f);
        this.dayOfMonthLabel = new JLabel();
        this.dayOfMonthLabel.setName("dayOfMonthLabel");
        this.dayOfMonthLabel.setText("Day:");
        FramerFactory.current.installComponent(this.dayOfMonthLabel, this.raceDatePanel, 1, 130, 2475.0f, 315.0f, 510.0f, 135.0f);
        this.dayOfMonthComboBox = new JComboBox();
        this.dayOfMonthComboBox.setName("dayOfMonthComboBox");
        FramerFactory.current.installComponent(this.dayOfMonthComboBox, this.raceDatePanel, 1, 130, 3012.0f, 348.0f, 960.0f, 120.0f);
        this.yearLabel = new JLabel();
        this.yearLabel.setName("yearLabel");
        this.yearLabel.setText("Year:");
        FramerFactory.current.installComponent(this.yearLabel, this.raceDatePanel, 1, 130, 4212.0f, 315.0f, 576.0f, 132.0f);
        this.yearComboBox = new JComboBox();
        this.yearComboBox.setName("yearComboBox");
        FramerFactory.current.installComponent(this.yearComboBox, this.raceDatePanel, 1, 130, 4800.0f, 315.0f, 1416.0f, 156.0f);
    }

    protected void initQualifierItems() {
        this.qualifierLabel = new JLabel();
        this.qualifierLabel.setName("qualifierLabel");
        this.qualifierLabel.setText("Qualifier");
        FramerFactory.current.installComponent(this.qualifierLabel, this, 1, 136, 2475.0f, 1416.0f, 768.0f, 315.0f);
        this.qualifierField = new JComboBox();
        this.qualifierField.setName("qualifierField");
        this.qualifierField.setEditable(true);
        FramerFactory.current.installComponent(this.qualifierField, this, 1, 168, 3300.0f, 1404.0f, 72.0f, 300.0f);
    }

    protected void initRaceTypeItems() {
        this.raceTypeLabel = new JLabel();
        this.raceTypeLabel.setName("raceTypeLabel");
        this.raceTypeLabel.setText("Event");
        FramerFactory.current.installComponent(this.raceTypeLabel, this, 1, 136, 0.0f, 1416.0f, 708.0f, 315.0f);
        this.raceTypeComboBox = new JComboBox();
        this.raceTypeComboBox.setName("raceTypeComboBox");
        this.myToolServices().installConstantNameRenderer(this.raceTypeComboBox);
        FramerFactory.current.installComponent(this.raceTypeComboBox, this, 1, 136, 864.0f, 1404.0f, 948.0f, 300.0f);
    }

    protected void initRaceLocationItems() {
        this.raceLocationLabel = new JLabel();
        this.raceLocationLabel.setName("raceLocationLabel");
        this.raceLocationLabel.setText("Location");
        FramerFactory.current.installComponent(this.raceLocationLabel, this, 1, 136, 0.0f, 936.0f, 852.0f, 315.0f);
        this.raceLocationComboBox = new JComboBox();
        this.raceLocationComboBox.setName("raceLocationComboBox");
        this.myToolServices().installRaceLocationRenderer(this.raceLocationComboBox);
        FramerFactory.current.installComponent(this.raceLocationComboBox, this, 1, 168, 864.0f, 924.0f, 72.0f, 315.0f);
    }

    public void setModel(RaceIdentifierModel raceModel) {
        this.raceModel = raceModel;
        this.initializeWindow();
    }

    protected void initializeWindow() {
        SwingPatches.installComboBoxModel(this.monthComboBox, this.raceModel.getRaceMonthModel());
        SwingPatches.installComboBoxModel(this.dayOfMonthComboBox, this.raceModel.getRaceDayOfMonthModel());
        SwingPatches.installComboBoxModel(this.yearComboBox, this.raceModel.getRaceYearModel());
        SwingPatches.installComboBoxModel(this.raceLocationComboBox, this.raceModel.getRaceLocationModel());
        SwingPatches.installComboBoxModel(this.raceTypeComboBox, this.raceModel.getRaceTypeModel());
        SwingPatches.installComboBoxModel(this.qualifierField, this.raceModel.getRaceQualifierModel());
        if (!this.raceModel.isIdentificationEditable()) {
            this.monthComboBox.setEnabled(false);
            this.dayOfMonthComboBox.setEnabled(false);
            this.yearComboBox.setEnabled(false);
            this.raceLocationComboBox.setEnabled(false);
            this.raceTypeComboBox.setEnabled(false);
            this.qualifierField.setEnabled(false);
        }
    }
}

