/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceEntryResult2Run;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.tools.ui.ChooseRacerDialog;
import org.ussamasters.aces.tools.ui.RaceResultEditor;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RaceSpecificationPanel;

public class RaceResultEditorWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 8715.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 8220.0f;
    int nRuns;
    protected RaceSpecificationPanel raceSpecificationPanel;
    protected JPanel competitorResultsPanel;
    protected JLabel competitorResultsLabel;
    protected JScrollPane competitorResultsScrollPane;
    protected JTable competitorResultsTablePane;
    protected JButton editNameButton;
    protected JButton editClassButton;
    protected JButton editRun1Button;
    protected JButton editRun2Button;
    protected JButton addRacerButton;
    protected JButton removeRacerButton;
    protected JButton saveButton;
    protected JPopupMenu competitorResultsPanePopupMenu;
    protected OperationAction editClassAction;
    protected OperationAction editNameAction;
    protected OperationAction editRun1Action;
    protected OperationAction editRun2Action;
    protected OperationAction editRacerResultAction;
    protected OperationAction addRacerAction;
    protected OperationAction removeRacerAction;

    public RaceResultEditorWindow() {
    }

    public RaceResultEditorWindow(String arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Race Result Editor");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceSpecificationPanel();
        this.initCompetitorResultsPanel();
        this.initSaveButton();
    }

    protected void initRaceSpecificationPanel() {
        this.raceSpecificationPanel = new RaceSpecificationPanel();
        FramerFactory.current.installComponent(this.raceSpecificationPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, 2900.0f);
    }

    protected void initCompetitorResultsPanel() {
        this.competitorResultsPanel = new JPanel();
        this.competitorResultsPanel.setName("competitorResultsPanel");
        FramerFactory.current.installComponent(this.competitorResultsPanel, this.contentPanel, 1, 170, 0.0f, 2900.0f, 0.0f, 510.0f);
        this.competitorResultsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.competitorResultsLabel = new JLabel();
        this.competitorResultsLabel.setName("competitorResultsLabel");
        this.competitorResultsLabel.setText("Competitor Results:");
        FramerFactory.current.installComponent(this.competitorResultsLabel, this.competitorResultsPanel, 1, 136, 0.0f, 0.0f, 1800.0f, 315.0f);
        this.competitorResultsScrollPane = new JScrollPane();
        this.competitorResultsScrollPane.setName("competitorResultsScrollPane");
        FramerFactory.current.installComponent(this.competitorResultsScrollPane, this.competitorResultsPanel, 1, 170, 0.0f, 450.0f, 1380.0f, 30.0f);
        this.competitorResultsTablePane = new JTable();
        this.competitorResultsTablePane.setName("competitorResultsTablePane");
        this.competitorResultsScrollPane.setViewportView(this.competitorResultsTablePane);
        this.editClassButton = new JButton();
        this.editClassButton.setMargin(new Insets(0, 0, 0, 0));
        this.editClassButton.setName("editClassButton");
        this.editClassButton.setText("Edit class...");
        FramerFactory.current.installComponent(this.editClassButton, this.competitorResultsPanel, 1, 40, 1125.0f, 450.0f, 0.0f, 315.0f);
        this.editNameButton = new JButton();
        this.editNameButton.setMargin(new Insets(0, 0, 0, 0));
        this.editNameButton.setName("editNameButton");
        this.editNameButton.setText("Edit name...");
        FramerFactory.current.installComponent(this.editNameButton, this.competitorResultsPanel, 1, 40, 1125.0f, 900.0f, 0.0f, 315.0f);
        this.editRun1Button = new JButton();
        this.editRun1Button.setMargin(new Insets(0, 0, 0, 0));
        this.editRun1Button.setName("editRun1Button");
        this.editRun1Button.setText("Edit result...");
        FramerFactory.current.installComponent(this.editRun1Button, this.competitorResultsPanel, 1, 40, 1125.0f, 1350.0f, 0.0f, 315.0f);
        this.editRun2Button = new JButton();
        this.editRun2Button.setMargin(new Insets(0, 0, 0, 0));
        this.editRun2Button.setName("editRun2Button");
        this.editRun2Button.setText("Edit result...");
        FramerFactory.current.installComponent(this.editRun2Button, this.competitorResultsPanel, 1, 40, 1125.0f, 1800.0f, 0.0f, 315.0f);
        this.addRacerButton = new JButton();
        this.addRacerButton.setMargin(new Insets(0, 0, 0, 0));
        this.addRacerButton.setName("addRacerButton");
        this.addRacerButton.setText("Add racer...");
        FramerFactory.current.installComponent(this.addRacerButton, this.competitorResultsPanel, 1, 34, 1125.0f, 315.0f, 0.0f, 450.0f);
        this.removeRacerButton = new JButton();
        this.removeRacerButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeRacerButton.setName("removeRacerButton");
        this.removeRacerButton.setText("Remove racer");
        FramerFactory.current.installComponent(this.removeRacerButton, this.competitorResultsPanel, 1, 34, 1125.0f, 315.0f, 0.0f, 0.0f);
    }

    protected void initSaveButton() {
        this.saveButton = new JButton();
        this.saveButton.setMargin(new Insets(0, 0, 0, 0));
        this.saveButton.setName("saveButton");
        this.saveButton.setText("Save");
        FramerFactory.current.installComponent(this.saveButton, this.contentPanel, 1, 66, 0.5f, 315.0f, 825.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1185.0f, 915.0f, 8715.0f, 8220.0f);
    }

    protected RaceResultEditor myApp() {
        return (RaceResultEditor)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.nRuns = this.myApp().getNumberOfRuns();
        this.initOperationActions();
        this.raceSpecificationPanel.setModel(this.myApp().getRaceSpecificationModel());
        this.raceSpecificationPanel.raceClassesComboBox.setEnabled(false);
        this.competitorResultsTablePane.setModel(this.myApp().getRaceResultTableHolder().getDataModel());
        this.competitorResultsTablePane.setSelectionModel(this.myApp().getRaceResultTableHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.competitorResultsTablePane);
        this.updateResultOperationButtons();
        this.updateSaveButton();
        this.competitorResultsPanePopupMenu = this.buildCompetitorResultsPanePopupMenu();
        this.configureConnections();
    }

    protected void initOperationActions() {
        this.editClassAction = new OperationAction("Edit Class...", "Change the racer's class (gender or age)", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultEditorWindow.this.editRacerClass();
            }
        });
        this.editNameAction = new OperationAction("Edit Name...", "Change the racer's name", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultEditorWindow.this.editRacerName();
            }
        });
        if (this.nRuns == 1) {
            this.editRacerResultAction = new OperationAction("Edit Time...", "Change the racer's result", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    RaceResultEditorWindow.this.editRacerResult();
                }
            });
        } else {
            this.editRun1Action = new OperationAction("Edit run 1...", "Change the racer's first-run result", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    RaceResultEditorWindow.this.editRacerRun1();
                }
            });
            this.editRun2Action = new OperationAction("Edit run 2...", "Change the racer's second-run result", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    RaceResultEditorWindow.this.editRacerRun2();
                }
            });
        }
        this.addRacerAction = new OperationAction("Add racer...", "Add a racer result", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultEditorWindow.this.addRacerResult();
            }
        });
        this.removeRacerAction = new OperationAction("Remove racer", "Remove the selected racer's result", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultEditorWindow.this.removeRacerResult();
            }
        });
    }

    protected JPopupMenu buildCompetitorResultsPanePopupMenu() {
        JPopupMenu aMenu = new JPopupMenu();
        this.editClassAction.appendTo(aMenu);
        this.editNameAction.appendTo(aMenu);
        if (this.nRuns == 1) {
            this.editRacerResultAction.appendTo(aMenu);
        } else {
            this.editRun1Action.appendTo(aMenu);
            this.editRun2Action.appendTo(aMenu);
        }
        aMenu.addSeparator();
        this.removeRacerAction.appendTo(aMenu);
        return aMenu;
    }

    protected void configureConnections() {
        this.myToolServices().registerPanePopupHandler(this.competitorResultsTablePane, this.competitorResultsPanePopupMenu);
        this.competitorResultsTablePane.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RaceResultEditorWindow.this.updateResultOperationButtons();
            }
        });
        this.editClassButton.setAction(this.editClassAction);
        this.editNameButton.setAction(this.editNameAction);
        if (this.nRuns == 1) {
            this.editRun1Button.setAction(this.editRacerResultAction);
            this.editRun2Button.setVisible(false);
        } else {
            this.editRun1Button.setAction(this.editRun1Action);
            this.editRun2Button.setAction(this.editRun2Action);
        }
        this.addRacerButton.setAction(this.addRacerAction);
        this.removeRacerButton.setAction(this.removeRacerAction);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultEditorWindow.this.saveChanges();
            }
        });
        this.myApp().getRaceSpecificationModel().getHasChangesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceResultEditorWindow.this.updateSaveButton();
            }
        });
        this.myApp().getResultsChangedHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceResultEditorWindow.this.updateSaveButton();
            }
        });
    }

    protected void updateResultOperationButtons() {
        boolean hasResultSelection = this.myApp().getSelectedResult() != null;
        this.editClassAction.setEnabled(hasResultSelection);
        this.editNameAction.setEnabled(hasResultSelection);
        if (this.nRuns == 1) {
            this.editRacerResultAction.setEnabled(hasResultSelection);
        } else {
            this.editRun1Action.setEnabled(hasResultSelection);
            this.editRun2Action.setEnabled(hasResultSelection);
        }
        this.removeRacerAction.setEnabled(hasResultSelection);
    }

    protected void updateSaveButton() {
        this.saveButton.setEnabled(this.myApp().hasUnsavedChanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveChanges() {
        boolean regenerateReports;
        try {
            this.myApp().saveChanges();
        }
        catch (RaceDataIOException ex) {
            MessageDialog.displayError("Save Changes Failed", "Unable to save race result changes: " + ex.getMessage(), this.frameWindow);
        }
        if (this.myApp().hasReportsAvailable() && (regenerateReports = MessageDialog.confirm("The results reports for this race should be updated to incorporate the changes you have just made to the results data.\n\nRegenerate reports now?", this.frameWindow))) {
            Cursor originalCursor = this.frameWindow.getCursor();
            try {
                this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
                this.myApp().regenerateRaceResultsReports();
            }
            catch (RaceDataIOException ex) {
                MessageDialog.displayError("Report Generation Failed", "Unable to regenerate race reports with result changes: " + ex.getMessage(), this.frameWindow);
            }
            finally {
                this.frameWindow.setCursor(originalCursor);
            }
        }
    }

    protected void addRacerResult() {
        Racer newRacer = ChooseRacerDialog.openFor(this.frameWindow);
        if (newRacer == null) {
            return;
        }
        throw new UnsupportedOperationException("###Not Yet Implemented###");
    }

    protected void removeRacerResult() {
        RaceEntryResult aRacerResult = this.myApp().getSelectedResult();
        this.myApp().removeRacerResult(aRacerResult);
    }

    protected void editRacerClass() {
        RaceEntryResult aRacerResult = this.myApp().getSelectedResult();
        RaceClass<?> newRaceClass = this.myToolServices().editRacerResultClass(aRacerResult, this.frameWindow);
        if (newRaceClass == null) {
            return;
        }
        this.myApp().updateRacerClass(aRacerResult, newRaceClass);
    }

    protected void editRacerName() {
        RaceEntryResult aRacerResult = this.myApp().getSelectedResult();
        String[] editedName = this.myToolServices().editRacerResultName(aRacerResult, this.frameWindow);
        if (editedName == null) {
            return;
        }
        this.myApp().updateRacerName(aRacerResult, editedName[0], editedName[1]);
    }

    protected void editRacerResult() {
        RaceEntryResult aRacerResult = this.myApp().getSelectedResult();
        CompetitorResultValue<?> curResult = aRacerResult.getResultValue();
        CompetitorResultValue<?> newResult = this.myToolServices().editRacerRunResult(curResult, this.frameWindow);
        if (newResult == null) {
            return;
        }
        this.myApp().updateRacerResult(aRacerResult, newResult);
    }

    protected void editRacerRun1() {
        RaceEntryResult2Run aRacerResult = (RaceEntryResult2Run)this.myApp().getSelectedResult();
        CompetitorResultValue<?> curResult = aRacerResult.getFirstRun();
        CompetitorResultValue<?> newResult = this.myToolServices().editRacerRunResult(curResult, this.frameWindow);
        if (newResult == null) {
            return;
        }
        this.myApp().updateRacerResultFirstRun(aRacerResult, newResult);
    }

    protected void editRacerRun2() {
        RaceEntryResult2Run aRacerResult = (RaceEntryResult2Run)this.myApp().getSelectedResult();
        CompetitorResultValue<?> curResult = aRacerResult.getSecondRun();
        CompetitorResultValue<?> newResult = this.myToolServices().editRacerRunResult(curResult, this.frameWindow);
        if (newResult == null) {
            return;
        }
        this.myApp().updateRacerResultSecondRun(aRacerResult, newResult);
    }
}

