/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.ui.RaceResultReconciliationViewer;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RaceDescriptionPanel;
import org.ussamasters.aces.tools.ui.swing.RaceResultReconciliationPanel;
import org.ussamasters.aces.tools.ui.swing.RacerListEditorPanel;

public class RaceResultReconciliationViewerWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 11115.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 7860.0f;
    protected RaceDescriptionPanel raceDescriptionPanel;
    protected JSplitPane reconciliationAndRacersSplitPane;
    protected RacerListEditorPanel racerListEditorPanel;
    protected RaceResultReconciliationPanel reconciliationPanel;
    protected JButton saveChangesButton;

    public RaceResultReconciliationViewerWindow() {
    }

    public RaceResultReconciliationViewerWindow(String arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Race Result Reconciliation Report");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceDescriptionPanel();
        this.initReconciliationAndRacersSplitPane();
        this.initSaveChangesButton();
    }

    protected void initRaceDescriptionPanel() {
        this.raceDescriptionPanel = new RaceDescriptionPanel();
        this.raceDescriptionPanel.setBorder(BorderFactory.createTitledBorder("Race"));
        FramerFactory.current.installComponent(this.raceDescriptionPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, 1800.0f);
    }

    protected void initReconciliationAndRacersSplitPane() {
        this.reconciliationAndRacersSplitPane = new JSplitPane();
        this.reconciliationAndRacersSplitPane.setName("reconciliationAndRacersSplitPane");
        this.reconciliationAndRacersSplitPane.setContinuousLayout(true);
        this.reconciliationAndRacersSplitPane.setOrientation(0);
        this.reconciliationAndRacersSplitPane.setOneTouchExpandable(true);
        FramerFactory.current.installComponent(this.reconciliationAndRacersSplitPane, this.contentPanel, 1, 170, 0.0f, 1900.0f, 0.0f, 525.0f);
        this.racerListEditorPanel = new RacerListEditorPanel();
        this.racerListEditorPanel.setName("racerListEditorPanel");
        this.racerListEditorPanel.setBorder(BorderFactory.createTitledBorder("Registered Racers"));
        this.reconciliationAndRacersSplitPane.setTopComponent(this.racerListEditorPanel);
        this.reconciliationPanel = new RaceResultReconciliationPanel();
        this.reconciliationPanel.setName("reconciliationPanel");
        this.reconciliationPanel.setBorder(BorderFactory.createTitledBorder("Unreconciled Race Competitors"));
        this.reconciliationAndRacersSplitPane.setBottomComponent(this.reconciliationPanel);
    }

    protected void initSaveChangesButton() {
        this.saveChangesButton = new JButton();
        this.saveChangesButton.setName("saveChangesButton");
        this.saveChangesButton.setText("Save Changes");
        this.saveChangesButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.saveChangesButton, this.contentPanel, 1, 66, 0.5f, 315.0f, 1455.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 435.0f, 510.0f, 11115.0f, 7860.0f);
    }

    @Override
    protected void initializeWindow() {
        this.configureAppNameWindowTitle();
        this.raceDescriptionPanel.setRace(this.myApp().getRace());
        this.racerListEditorPanel.setEditor(this.myApp().getRacerListEditor());
        this.reconciliationPanel.setEditor(this.myApp().getRacerListEditor());
        this.reconciliationPanel.setRacerListPanel(this.racerListEditorPanel);
        this.reconciliationPanel.setModel(this.myApp().getReconciliationResultModel());
        this.saveChangesButton.setEnabled(false);
        this.configureConnections();
    }

    protected RaceResultReconciliationViewer myApp() {
        return (RaceResultReconciliationViewer)this.getAppModel();
    }

    protected void configureConnections() {
        this.frameWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                RaceResultReconciliationViewerWindow.this.reconciliationPanel.setMinimumSize(new Dimension(10, 10));
                RaceResultReconciliationViewerWindow.this.racerListEditorPanel.setMinimumSize(new Dimension(10, 10));
                RaceResultReconciliationViewerWindow.this.reconciliationAndRacersSplitPane.setDividerSize(8);
                RaceResultReconciliationViewerWindow.this.reconciliationAndRacersSplitPane.setDividerLocation(0.5);
            }
        });
        this.myApp().getReconciliationResultModel().getHasChangesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceResultReconciliationViewerWindow.this.saveChangesButton.setEnabled(RaceResultReconciliationViewerWindow.this.myApp().hasUnsavedChanges());
            }
        });
        this.myApp().getRacerListEditor().getHasChangesHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceResultReconciliationViewerWindow.this.saveChangesButton.setEnabled(RaceResultReconciliationViewerWindow.this.myApp().hasUnsavedChanges());
            }
        });
        this.saveChangesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultReconciliationViewerWindow.this.saveChanges();
            }
        });
    }

    protected void saveChanges() {
        try {
            this.myApp().saveChanges();
        }
        catch (RuntimeException | RaceDataIOException ex) {
            this.reportSaveChangesFailed(ex);
        }
    }

    protected void reportSaveChangesFailed(Exception ex) {
        DebugSupport.current().dumpStack(ex, 10);
        MessageDialog.displayError("Save Changes Failed", "Unable to save changes: " + ex.getMessage(), this.frameWindow);
    }
}

