/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.tools.ui.ChooseRaceDialog;
import org.ussamasters.aces.tools.ui.EditRaceIdentifierDialog;
import org.ussamasters.aces.tools.ui.EventScoringTool;
import org.ussamasters.aces.tools.ui.MergeRacesDialog;
import org.ussamasters.aces.tools.ui.RaceResultEditor;
import org.ussamasters.aces.tools.ui.RaceResultsImportTool;
import org.ussamasters.aces.tools.ui.RaceResultsTool;
import org.ussamasters.aces.tools.ui.SeasonScoringTool;
import org.ussamasters.aces.tools.ui.SplitRaceDialog;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.RaceSeriesDefinitionPanel;
import org.ussamasters.aces.tools.ui.swing.ReportFormatOptionsPanel;
import org.ussamasters.aces.tools.ui.swing.ReportViewOperationsPanel;

public class RaceResultsToolWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 9030.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 8000.0f;
    protected JMenuBar menuBar;
    protected RaceSeriesDefinitionPanel raceSeriesDescriptionPanel;
    protected JPanel raceSeriesAndOperationsPanel;
    protected JPanel seriesRacesPanel;
    protected JLabel seriesRacesLabel;
    protected JTable seriesRacesTable;
    protected JScrollPane seriesRacesScrollPane;
    protected JPanel raceOperationsPanel;
    protected JButton importRaceDataButton;
    protected JButton editRaceDataButton;
    protected JButton reconcileRaceCompetitorsButtont;
    protected JButton generateRaceReportsButton;
    protected ReportFormatOptionsPanel reportFormatOptionsPanel;
    protected ReportViewOperationsPanel viewReportOperationsPanel;
    protected OperationAction showWorkingSetDirectoryAction;
    protected OperationAction openCorrectionsLogAction;
    protected OperationAction newRaceAction;
    protected OperationAction editRaceAction;
    protected OperationAction deleteRaceAction;
    protected OperationAction loadRaceDataAction;
    protected OperationAction loadRaceDataByMergingAction;
    protected OperationAction loadRaceDataBySplittingAction;
    protected OperationAction editRaceDataAction;
    protected OperationAction reconcileRaceCompetitorsAction;
    protected OperationAction deleteRaceDataAction;
    protected OperationAction generateReportsAction;
    protected OperationAction viewHTMLReportsAction;
    protected OperationAction viewTextReportsAction;
    protected OperationAction viewPdfReportsAction;
    protected OperationAction viewReportsAction;
    protected OperationAction deleteReportsAction;
    protected OperationAction seasonScoringMenuItem;
    protected JPopupMenu racePanePopupMenu;
    protected JFileChooser importRaceDataFileChooser;
    protected JFileChooser reportFilesChooser;

    public RaceResultsToolWindow() {
    }

    public RaceResultsToolWindow(String title) {
        super(title);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Race Results Tool");
        this.menuBar = new JMenuBar();
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceSeriesDescriptionPanel();
        this.initRaceSeriesAndOperationsPanel();
        this.initSeriesRacesPanel();
        this.initRaceOperationsPanel();
    }

    protected void initRaceSeriesDescriptionPanel() {
        this.raceSeriesDescriptionPanel = new RaceSeriesDefinitionPanel();
        this.raceSeriesDescriptionPanel.init();
        FramerFactory.current.installComponent(this.raceSeriesDescriptionPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, 810.0f);
        this.raceSeriesDescriptionPanel.setMinimumSize(new Dimension(220, 97));
        this.raceSeriesDescriptionPanel.setPreferredSize(new Dimension(220, 97));
    }

    protected void initRaceSeriesAndOperationsPanel() {
        this.raceSeriesAndOperationsPanel = new JPanel();
        FramerFactory.current.installComponent(this.raceSeriesAndOperationsPanel, this.contentPanel, 1, 170, 0.0f, 810.0f, 0.0f, 90.0f);
        this.raceSeriesAndOperationsPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    protected void initSeriesRacesPanel() {
        this.seriesRacesPanel = new JPanel();
        FramerFactory.current.installComponent(this.seriesRacesPanel, this.raceSeriesAndOperationsPanel, 1, 170, 0.0f, 0.0f, 2000.0f, 0.0f);
        this.seriesRacesPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.seriesRacesLabel = new JLabel();
        this.seriesRacesLabel.setName("seriesRacesLabel");
        this.seriesRacesLabel.setText("Series Race Results:");
        FramerFactory.current.installComponent(this.seriesRacesLabel, this.seriesRacesPanel, 1, 136, 0.0f, 0.0f, 1905.0f, 315.0f);
        this.seriesRacesScrollPane = new JScrollPane();
        this.seriesRacesScrollPane.setName("seriesRacesScrollPane");
        FramerFactory.current.installComponent(this.seriesRacesScrollPane, this.seriesRacesPanel, 1, 170, 0.0f, 350.0f, 0.0f, 0.0f);
        this.seriesRacesTable = new JTable();
        this.seriesRacesTable.setName("seriesRacesTable");
        this.seriesRacesScrollPane.setViewportView(this.seriesRacesTable);
    }

    protected void initRaceOperationsPanel() {
        this.raceOperationsPanel = this.raceSeriesAndOperationsPanel;
        this.importRaceDataButton = new JButton();
        this.importRaceDataButton.setName("importRaceDataButton");
        this.importRaceDataButton.setText("Load results...");
        this.importRaceDataButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.importRaceDataButton, this.raceOperationsPanel, 1, 40, 1395.0f, 360.0f, 0.0f, 315.0f);
        this.editRaceDataButton = new JButton();
        this.editRaceDataButton.setName("editRaceDataButton");
        this.editRaceDataButton.setText("Edit results");
        this.editRaceDataButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.editRaceDataButton, this.raceOperationsPanel, 1, 40, 1395.0f, 825.0f, 0.0f, 315.0f);
        this.reconcileRaceCompetitorsButtont = new JButton();
        this.reconcileRaceCompetitorsButtont.setName("reconcileRaceCompetitorsButtont");
        this.reconcileRaceCompetitorsButtont.setText("Validate");
        this.reconcileRaceCompetitorsButtont.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.reconcileRaceCompetitorsButtont, this.raceOperationsPanel, 1, 40, 1395.0f, 1200.0f, 0.0f, 315.0f);
        this.generateRaceReportsButton = new JButton();
        this.generateRaceReportsButton.setName("generateRaceReportsButton");
        this.generateRaceReportsButton.setText("Generate Reports");
        this.generateRaceReportsButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.generateRaceReportsButton, this.raceOperationsPanel, 1, 34, 1800.0f, 315.0f, 0.0f, 3380.0f);
        this.reportFormatOptionsPanel = new ReportFormatOptionsPanel();
        FramerFactory.current.installComponent(this.reportFormatOptionsPanel, this.raceOperationsPanel, 1, 34, 1800.0f, 1500.0f, 0.0f, 1800.0f);
        this.viewReportOperationsPanel = new ReportViewOperationsPanel();
        FramerFactory.current.installComponent(this.viewReportOperationsPanel, this.raceOperationsPanel, 1, 34, 1800.0f, 1700.0f, 0.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 165.0f, 390.0f, 9030.0f, 8000.0f);
    }

    protected RaceResultsTool myApp() {
        return (RaceResultsTool)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.initOperationActions();
        this.configureAppNameWindowTitle();
        this.raceSeriesDescriptionPanel.setAppModel(this.myApp());
        this.seriesRacesTable.setModel(this.myApp().getRaceSeriesTableHolder().getDataModel());
        this.seriesRacesTable.setSelectionModel(this.myApp().getRaceSeriesTableHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.seriesRacesTable);
        this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.setSelected(this.myApp().getGenerateHTMLReportsHolder().getValue());
        this.reportFormatOptionsPanel.generateTextReportsCheckBox.setSelected(this.myApp().getGenerateTextReportsHolder().getValue());
        this.reportFormatOptionsPanel.generatePrintReportsCheckBox.setSelected(this.myApp().getGeneratePdfReportsHolder().getValue());
        this.updateSelectedRaceOperations();
        this.buildMenuBar();
        this.racePanePopupMenu = this.buildRacePanePopupMenu();
        this.configureConnections();
    }

    protected void initOperationActions() {
        this.showWorkingSetDirectoryAction = new OperationAction("Show Working Set Directory", "Show the working set directory in your file system", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.showWorkingSetDirectory();
            }
        });
        this.openCorrectionsLogAction = new OperationAction("Open Corrections Log", "Notes on corrections you make to race data", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.openCorrectionsLog();
            }
        });
        this.newRaceAction = new OperationAction("New...", "Create a new race entry in the series calendar", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultsToolWindow.this.newRace();
            }
        });
        this.editRaceAction = new OperationAction("Edit", "Edit the race specification", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultsToolWindow.this.editRace();
            }
        });
        this.deleteRaceAction = new OperationAction("Delete", "Delete the race and any results data from the series calendar", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultsToolWindow.this.deleteRace();
            }
        });
        this.loadRaceDataAction = new OperationAction("Load results...", "Load results data exported from timing system for the selected race", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.loadRaceResults();
            }
        });
        this.loadRaceDataByMergingAction = new OperationAction("Load by merging...", "Load results data by merging races", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.loadRaceResultsByMerging();
            }
        });
        this.loadRaceDataBySplittingAction = new OperationAction("Load by splitting...", "Load results data by splitting out a subset from another race", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.loadRaceResultsBySplitting();
            }
        });
        this.editRaceDataAction = new OperationAction("Edit results", "Edit results data for the selected race", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.editResults();
            }
        });
        this.reconcileRaceCompetitorsAction = this.myToolServices().constructReconcileRaceCompetitorsAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RaceResultsToolWindow.this.myToolServices().reconcileRaceResult(RaceResultsToolWindow.this.myApp().getSelectedRaceResult(), RaceResultsToolWindow.this.frameWindow);
            }
        });
        this.deleteRaceDataAction = new OperationAction("Delete results", "Delete results data for the selected race", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.deleteRaceData();
            }
        });
        this.generateReportsAction = new OperationAction("Generate Reports", "Generate race results reports for the selected race ", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.generateRaceResultsReport();
            }
        });
        this.viewHTMLReportsAction = new OperationAction("View HTML Reports", "View race results reports for the selected race in HTML (web) format", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.myApp().viewHTMLReports(RaceResultsToolWindow.this.myApp().getSelectedRace());
            }
        });
        this.viewTextReportsAction = new OperationAction("View Text Reports", "View race results reports for the selected race in text format", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.myApp().viewTextReports(RaceResultsToolWindow.this.myApp().getSelectedRace());
            }
        });
        this.viewPdfReportsAction = new OperationAction("View PDF Reports", "View race results reports for the selected race in PDF format", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.myApp().viewPdfReports(RaceResultsToolWindow.this.myApp().getSelectedRace());
            }
        });
        this.viewReportsAction = new OperationAction("View Reports...", "View selected race result reports", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.viewReports();
            }
        });
        this.deleteReportsAction = new OperationAction("Delete Reports", "Delete the standings reports for the selected race.", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceResultsToolWindow.this.deleteReports();
            }
        });
    }

    protected void configureConnections() {
        if (this.myApp().supportsWorkingSetSwitching()) {
            this.myApp().getWorkingSetChangedHolder().addChangeListener(new ValueChangeListener(){

                @Override
                public void valueChanged(ValueChangeEvent event) {
                    RaceResultsToolWindow.this.updateScoringMenuEnablement();
                }
            });
        }
        this.myToolServices().registerPanePopupHandler(this.seriesRacesTable, this.racePanePopupMenu);
        this.myToolServices().registerDoubleClickHandler((JComponent)this.seriesRacesTable, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceIdentifier selectedRace = RaceResultsToolWindow.this.myApp().getSelectedRace();
                if (selectedRace == null) {
                    return;
                }
                if (RaceResultsToolWindow.this.myApp().hasResultsAvailable(selectedRace)) {
                    RaceResultsToolWindow.this.editRaceDataAction.actionPerformed(event);
                } else {
                    RaceResultsToolWindow.this.editRaceAction.actionPerformed(event);
                }
            }
        });
        this.myApp().getRaceSeriesTableHolder().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RaceResultsToolWindow.this.updateSelectedRaceOperations();
            }
        });
        this.importRaceDataButton.setAction(this.loadRaceDataAction);
        this.editRaceDataButton.setAction(this.editRaceDataAction);
        this.reconcileRaceCompetitorsButtont.setAction(this.reconcileRaceCompetitorsAction);
        this.generateRaceReportsButton.setAction(this.generateReportsAction);
        this.myApp().getRaceStatusChangedHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RaceResultsToolWindow.this.updateSelectedRaceOperations();
            }
        });
        this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                RaceResultsToolWindow.this.myApp().getGenerateHTMLReportsHolder().setValue(RaceResultsToolWindow.this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.isSelected());
                RaceResultsToolWindow.this.updateGenerateReportsOperations(RaceResultsToolWindow.this.myApp().getSelectedRace());
            }
        });
        this.reportFormatOptionsPanel.generateTextReportsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                RaceResultsToolWindow.this.myApp().getGenerateTextReportsHolder().setValue(RaceResultsToolWindow.this.reportFormatOptionsPanel.generateTextReportsCheckBox.isSelected());
                RaceResultsToolWindow.this.updateGenerateReportsOperations(RaceResultsToolWindow.this.myApp().getSelectedRace());
            }
        });
        this.reportFormatOptionsPanel.generatePrintReportsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                RaceResultsToolWindow.this.myApp().getGeneratePdfReportsHolder().setValue(RaceResultsToolWindow.this.reportFormatOptionsPanel.generatePrintReportsCheckBox.isSelected());
                RaceResultsToolWindow.this.updateGenerateReportsOperations(RaceResultsToolWindow.this.myApp().getSelectedRace());
            }
        });
        String label = this.viewReportOperationsPanel.viewHTMLReportsButton.getText();
        this.viewReportOperationsPanel.viewHTMLReportsButton.setAction(this.viewHTMLReportsAction);
        label = this.viewReportOperationsPanel.viewTextReportsButton.getText();
        this.viewReportOperationsPanel.viewTextReportsButton.setAction(this.viewTextReportsAction);
        this.viewReportOperationsPanel.viewPdfReportsButton.setAction(this.viewPdfReportsAction);
        this.viewReportOperationsPanel.viewReportsButton.setAction(this.viewReportsAction);
    }

    protected void buildMenuBar() {
        this.frameWindow.setJMenuBar(this.menuBar);
        this.menuBar.add(this.buildFileMenu());
        this.menuBar.add(this.buildRaceMenu());
        this.menuBar.add(this.buildReportMenu());
        if (this.myApp().allowsScoringTools()) {
            this.menuBar.add(this.buildScoringMenu());
        }
        this.menuBar.add(this.myToolServices().buildStandardHelpMenu(this.frameWindow));
    }

    protected JMenu buildFileMenu() {
        JMenu aMenu = this.myToolServices().constructFileMenu();
        if (this.myApp().supportsWorkingSetSwitching()) {
            this.myToolServices().appendRaceSeriesWorkingSetItems(aMenu, this.frameWindow, this.myApp());
            aMenu.addSeparator();
        }
        this.showWorkingSetDirectoryAction.appendTo(aMenu);
        this.openCorrectionsLogAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.myToolServices().appendApplicationCloseItem(aMenu, this.frameWindow);
        return aMenu;
    }

    protected JMenu buildReportMenu() {
        JMenu aMenu = new JMenu("Report");
        aMenu.setToolTipText("Race report operations");
        this.generateReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.viewHTMLReportsAction.appendTo(aMenu);
        this.viewTextReportsAction.appendTo(aMenu);
        this.viewPdfReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.deleteReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.viewReportsAction.appendTo(aMenu);
        return aMenu;
    }

    protected JMenu buildRaceMenu() {
        JMenu aMenu = new JMenu("Race");
        aMenu.setToolTipText("Series calendar and race result operations");
        this.newRaceAction.appendTo(aMenu);
        this.editRaceAction.appendTo(aMenu);
        this.deleteRaceAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.loadRaceDataAction.appendTo(aMenu);
        this.loadRaceDataByMergingAction.appendTo(aMenu);
        this.loadRaceDataBySplittingAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.editRaceDataAction.appendTo(aMenu);
        this.reconcileRaceCompetitorsAction.appendTo(aMenu);
        this.deleteRaceDataAction.appendTo(aMenu);
        return aMenu;
    }

    protected JMenu buildScoringMenu() {
        JMenu aMenu = this.myToolServices().constructScoringMenu();
        OperationAction ma = this.myToolServices().constructLaunchToolAction(EventScoringTool.TOOL_ID, "Event Scoring", "Event standings scoring");
        ma.appendTo(aMenu);
        ma = this.myToolServices().constructLaunchToolAction(SeasonScoringTool.TOOL_ID, "Season Scoring", "Season standings scoring");
        ma.appendTo(aMenu);
        this.seasonScoringMenuItem = ma;
        this.updateScoringMenuEnablement();
        aMenu.addSeparator();
        this.myToolServices().constructImportRacerListAction(this.frameWindow).appendTo(aMenu);
        aMenu.addSeparator();
        this.myToolServices().constructLaunchRacerListEditorAction().appendTo(aMenu);
        return aMenu;
    }

    protected JPopupMenu buildRacePanePopupMenu() {
        JPopupMenu aMenu = new JPopupMenu();
        this.newRaceAction.appendTo(aMenu);
        this.editRaceAction.appendTo(aMenu);
        this.deleteRaceAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.loadRaceDataAction.appendTo(aMenu);
        this.loadRaceDataByMergingAction.appendTo(aMenu);
        this.loadRaceDataBySplittingAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.editRaceDataAction.appendTo(aMenu);
        this.reconcileRaceCompetitorsAction.appendTo(aMenu);
        this.deleteRaceDataAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.generateReportsAction.appendTo(aMenu);
        this.viewHTMLReportsAction.appendTo(aMenu);
        this.viewTextReportsAction.appendTo(aMenu);
        this.deleteReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.openCorrectionsLogAction.appendTo(aMenu);
        return aMenu;
    }

    protected void updateSelectedRaceOperations() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        boolean hasRaceSelection = selectedRace != null;
        boolean hasResultData = hasRaceSelection && this.myApp().hasResultsAvailable(selectedRace);
        this.editRaceAction.setEnabled(hasRaceSelection && !hasResultData);
        this.deleteRaceAction.setEnabled(hasRaceSelection);
        this.updateRaceDataOperations(selectedRace);
    }

    protected void updateRaceDataOperations(RaceIdentifier selectedRace) {
        boolean hasRaceSelection = selectedRace != null;
        boolean hasResultData = hasRaceSelection && this.myApp().hasResultsAvailable(selectedRace);
        this.loadRaceDataAction.setEnabled(hasRaceSelection);
        this.loadRaceDataByMergingAction.setEnabled(hasRaceSelection);
        this.loadRaceDataBySplittingAction.setEnabled(hasRaceSelection);
        this.editRaceDataAction.setEnabled(hasResultData);
        this.reconcileRaceCompetitorsAction.setEnabled(hasResultData);
        this.deleteRaceDataAction.setEnabled(hasResultData);
        this.updateReportOperationItems(selectedRace);
    }

    protected void updateReportOperationItems(RaceIdentifier selectedRace) {
        this.updateGenerateReportsOperations(selectedRace);
        this.viewHTMLReportsAction.setEnabled(this.myApp().hasHTMLReportsAvailable(selectedRace));
        this.viewTextReportsAction.setEnabled(this.myApp().hasTextReportsAvailable(selectedRace));
        this.viewPdfReportsAction.setEnabled(this.myApp().hasPdfReportsAvailable(selectedRace));
        this.deleteReportsAction.setEnabled(this.myApp().hasReportsAvailable(selectedRace));
        this.viewReportsAction.setEnabled(this.myApp().getReportsDirectory().exists());
    }

    protected void updateGenerateReportsOperations(RaceIdentifier selectedRace) {
        boolean hasRaceSelection = selectedRace != null;
        boolean resultsAvailable = this.myApp().hasResultsAvailable(selectedRace);
        this.generateReportsAction.setEnabled(hasRaceSelection && resultsAvailable && (this.myApp().getGenerateHTMLReportsHolder().getValue() || this.myApp().getGenerateTextReportsHolder().getValue() || this.myApp().getGeneratePdfReportsHolder().getValue()));
    }

    protected JFileChooser getImportRaceDataDialog() {
        if (this.importRaceDataFileChooser == null) {
            this.importRaceDataFileChooser = new JFileChooser();
            this.importRaceDataFileChooser.setCurrentDirectory(this.mySessionManager().getRaceDataDirectory());
        }
        return this.importRaceDataFileChooser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateRaceResultsReport() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().generateRaceResultsReports(selectedRace);
        }
        catch (RaceDataIOException ex) {
            this.reportReportGenerationFailure(ex);
        }
        catch (RuntimeException ex) {
            this.reportReportGenerationFailure(ex);
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }

    protected void reportReportGenerationFailure(Throwable ex) {
        DebugSupport.current().dumpStack(ex, 10);
        String errorMessage = ex.getMessage();
        if (errorMessage == null) {
            errorMessage = "" + ex;
        }
        MessageDialog.displayError("Error Generating Reports", errorMessage, this.frameWindow);
    }

    protected boolean confirmLoadRaceData(RaceIdentifier selectedRace) {
        String prompt;
        return this.myApp().getRaceResult(selectedRace) == null || MessageDialog.confirm(prompt = "The results of this race have already been loaded.\n\nDo you really want to reload the results?", this.frameWindow);
    }

    protected void loadRaceResults() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        if (!this.confirmLoadRaceData(selectedRace)) {
            return;
        }
        RaceResultsImportTool.findOrOpen(selectedRace, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRaceResultsByMerging() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        RaceSeries candidateRaces = this.myApp().getCandidateRacesToMerge(selectedRace);
        if (candidateRaces.size() < 2) {
            MessageDialog.displayMessage("No Races Available to Merge", "There is not race data available for merging multiple " + selectedRace.getType().name + " results at " + selectedRace.getLocation().fullName, this.frameWindow);
            return;
        }
        if (!this.confirmLoadRaceData(selectedRace)) {
            return;
        }
        RaceResult mergedResult = MergeRacesDialog.openOn(candidateRaces, selectedRace, this.getMainWindow());
        if (mergedResult == null) {
            return;
        }
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().saveRaceResult(mergedResult);
        }
        catch (RaceDataIOException ex) {
            this.reportSaveRaceFailure(ex);
            return;
        }
        catch (RuntimeException ex) {
            this.reportSaveRaceFailure(ex);
            return;
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRaceResultsBySplitting() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        RaceSeries candidateRaces = this.myApp().getCandidateRacesToSplit(selectedRace);
        if (candidateRaces.size() == 0) {
            MessageDialog.displayMessage("No Race Available to Split", "There are is no race data available for splitting out a subset of " + selectedRace.getType().name + " results at " + selectedRace.getLocation().fullName, this.frameWindow);
            return;
        }
        if (!this.confirmLoadRaceData(selectedRace)) {
            return;
        }
        RaceIdentifier raceToSplit = ChooseRaceDialog.openOn(candidateRaces, this.getMainWindow());
        if (raceToSplit == null) {
            return;
        }
        RaceResult splitResult = SplitRaceDialog.openOn(this.myApp().getRaceResult(raceToSplit), selectedRace, this.frameWindow);
        if (splitResult == null) {
            return;
        }
        if (splitResult.getNumberOfCompetitors() == 0) {
            MessageDialog.displayMessage("No Racers Selected", "You have not selected any racers to put into the split race.\n\nPlease try again.", this.frameWindow);
            return;
        }
        Cursor originalCursor = this.frameWindow.getCursor();
        try {
            this.frameWindow.setCursor(Cursor.getPredefinedCursor(3));
            this.myApp().saveRaceResult(splitResult);
        }
        catch (RaceDataIOException ex) {
            this.reportSaveRaceFailure(ex);
            return;
        }
        catch (RuntimeException ex) {
            this.reportSaveRaceFailure(ex);
            return;
        }
        finally {
            this.frameWindow.setCursor(originalCursor);
        }
    }

    protected void reportSaveRaceFailure(Exception ex) {
        String errorMessage = ex.getLocalizedMessage();
        if (errorMessage == null) {
            errorMessage = "" + ex;
        }
        DebugSupport.current().dump("****ERROR: " + errorMessage);
        DebugSupport.current().dumpStack(ex, 10);
        MessageDialog.displayError("Save Race Failed", errorMessage, this.frameWindow);
    }

    protected void showWorkingSetDirectory() {
        try {
            this.myApp().showWorkingSetDirectory();
        }
        catch (IOException ex) {
            MessageDialog.displayError("Unable to show working set directory", "I/O error: " + ex.getMessage(), this.frameWindow);
        }
    }

    protected void openCorrectionsLog() {
        try {
            this.myApp().openCorrectionsLog();
        }
        catch (IOException ex) {
            MessageDialog.displayError("Unable to open Corrections Log", "I/O error: " + ex.getMessage(), this.frameWindow);
        }
    }

    protected String raceDescriptionString(RaceIdentifier raceID) {
        return raceID.getLocation().name + " " + raceID.getType().name + " (" + raceID.getDate().toStandardString() + ")";
    }

    protected void deleteRace() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        if (this.mySessionManager().hasReferences(selectedRace)) {
            MessageDialog.displayWarning("Race Has References", "You cannot delete " + this.raceDescriptionString(selectedRace) + " - it is currently used for event scoring.", this.frameWindow);
            return;
        }
        boolean hasResultData = this.myApp().hasResultsAvailable(selectedRace);
        if (hasResultData) {
            String message = "Are you sure you want to delete the " + this.raceDescriptionString(selectedRace) + " race along with its results data?";
            if (!MessageDialog.confirm(message, this.frameWindow)) {
                return;
            }
            this.myApp().deleteRaceData(selectedRace);
        }
        try {
            this.myApp().deleteRace(selectedRace);
        }
        catch (RaceDataIOException ex) {
            MessageDialog.displayError("Delete Race Failed", "Unable to delete race from series calendar: " + ex.getMessage(), this.frameWindow);
        }
    }

    protected void deleteRaceData() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        if (this.mySessionManager().hasReferences(selectedRace)) {
            MessageDialog.displayWarning("Race Has References", "You cannot delete " + this.raceDescriptionString(selectedRace) + " - it is currently used for event scoring.", this.frameWindow);
            return;
        }
        String message = "Are you sure you want to delete the " + this.raceDescriptionString(selectedRace) + " results data?";
        if (!MessageDialog.confirm(message, this.frameWindow)) {
            return;
        }
        this.myApp().deleteRaceData(selectedRace);
        this.updateRaceDataOperations(selectedRace);
    }

    protected void deleteReports() {
        RaceIdentifier selectedRace = this.myApp().getSelectedRace();
        this.myApp().deleteRaceReports(selectedRace);
        this.updateReportOperationItems(selectedRace);
    }

    protected void editResults() {
        RacerList competitorInfo;
        RaceIdentifier raceID = this.myApp().getSelectedRace();
        if (raceID == null) {
            return;
        }
        RaceResult raceResult = this.myApp().getRaceResult(raceID);
        try {
            competitorInfo = this.myApp().getRaceResultCompetitorInfo(raceID);
        }
        catch (RaceDataIOException ex) {
            String shouldProceedMessage = "Unable to access competitor information associated with the race results.  Racer data changes made to the results info will not be propagated correctly when these results are incorporated into series standings.\n\nEdit results anyway?";
            if (!MessageDialog.confirm(shouldProceedMessage, this.frameWindow)) {
                return;
            }
            competitorInfo = null;
        }
        RaceResultEditor.findOrOpen(raceResult, competitorInfo);
    }

    protected void newRace() {
        RaceIdentifier newRace = EditRaceIdentifierDialog.openFor(this.myApp().getRaceSeries(), this.frameWindow);
        if (newRace == null) {
            return;
        }
        try {
            this.myApp().addRace(newRace);
        }
        catch (RaceDataIOException ex) {
            MessageDialog.displayError("Race Calendar Update Failed", ex.getMessage(), this.frameWindow);
            return;
        }
        this.myToolServices().scrollSelectionIntoView(this.seriesRacesTable);
    }

    protected void editRace() {
        RaceIdentifier raceID = this.myApp().getSelectedRace();
        RaceIdentifier updatedRaceID = EditRaceIdentifierDialog.openOn(raceID, this.myApp().getRaceSeries(), this.frameWindow);
        if (updatedRaceID == null) {
            return;
        }
        try {
            this.myApp().updateRace(raceID, updatedRaceID);
        }
        catch (RaceDataIOException ex) {
            MessageDialog.displayError("Race Calendar Update Failed", ex.getMessage(), this.frameWindow);
            return;
        }
    }

    protected void viewReports() {
        JFileChooser fd = this.getReportFilesChooser();
        int option = fd.showOpenDialog(this.frameWindow);
        if (option != 0) {
            return;
        }
        File[] selectedFiles = fd.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return;
        }
        for (int i = 0; i < selectedFiles.length; ++i) {
            this.myApp().viewReport(selectedFiles[i]);
        }
    }

    protected JFileChooser getReportFilesChooser() {
        if (this.reportFilesChooser == null) {
            this.reportFilesChooser = this.myToolServices().constructReportFilesChooser(this.myApp().getReportsDirectory());
        }
        return this.reportFilesChooser;
    }

    protected void updateScoringMenuEnablement() {
        this.seasonScoringMenuItem.setEnabled(this.myApp().allowsSeasonScoring());
    }

    public static void main(String[] args) {
        RaceResultsTool.initiateSession();
        try {
            RaceResultsTool appModel = new RaceResultsTool();
            appModel.openWindow(new RaceResultsToolWindow());
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            DebugSupport.printStackTrace(ex, 10);
            SessionManager.current.shutdown();
        }
    }
}

