/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.lang.SystemConstants;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.OperationAction;
import com.glaivestone.toolbox.mv.text.TextWindow;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.tools.foundation.models.ToolSessionRacerList;
import org.ussamasters.aces.tools.ui.EditRacerDialog;
import org.ussamasters.aces.tools.ui.NewRacerDialog;
import org.ussamasters.aces.tools.ui.RacerListEditorModel;
import org.ussamasters.aces.tools.ui.RacerListTableHolder;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;
import org.ussamasters.aces.tools.ui.swing.RacerListPanel;

public class RacerListEditorPanel
extends RSTPanel {
    protected RacerListEditorModel racerListEditor;
    protected JLabel competitorsListLabel;
    protected RacerListPanel racerListPanel;
    protected JButton createRacerButton;
    protected JButton editRacerButton;
    protected JButton removeRacerButton;
    protected JButton validateRacersButton;
    protected OperationAction addRacerAction;
    protected OperationAction editRacerAction;
    protected OperationAction removeRacerAction;
    protected OperationAction validateRacersAction;
    protected OperationAction findRacerAction;
    protected JPopupMenu racerListPanePopupMenu;

    public RacerListEditorPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    public void initSelf() {
        this.setName("racerListEditorPanel");
        this.setLayout(FramerFactory.current.newLayoutManager());
    }

    public void initChildComponents() {
        this.competitorsListLabel = new JLabel();
        this.competitorsListLabel.setName("competitorsListLabel");
        this.competitorsListLabel.setText("Competitors:");
        FramerFactory.current.installComponent(this.competitorsListLabel, this, 1, 136, 0.0f, 0.0f, 1215.0f, 255.0f);
        this.racerListPanel = new RacerListPanel();
        FramerFactory.current.installComponent(this.racerListPanel, this, 1, 170, 0.0f, 360.0f, 1065.0f, 0.0f);
        this.createRacerButton = new JButton();
        this.createRacerButton.setName("createRacerButton");
        this.createRacerButton.setText("New...");
        this.createRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.createRacerButton, this, 1, 40, 825.0f, 360.0f, 0.0f, 315.0f);
        this.editRacerButton = new JButton();
        this.editRacerButton.setName("editRacerButton");
        this.editRacerButton.setText("Edit...");
        this.editRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.editRacerButton, this, 1, 40, 825.0f, 825.0f, 0.0f, 315.0f);
        this.removeRacerButton = new JButton();
        this.removeRacerButton.setName("removeRacerButton");
        this.removeRacerButton.setText("Delete");
        this.removeRacerButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.removeRacerButton, this, 1, 40, 825.0f, 1245.0f, 0.0f, 315.0f);
        this.validateRacersButton = new JButton();
        this.validateRacersButton.setText("Validate");
        this.validateRacersButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.validateRacersButton, this, 1, 34, 825.0f, 315.0f, 0.0f, 960.0f);
    }

    public void ensureSelectionIsVisible() {
        this.racerListPanel.ensureSelectionIsVisible();
    }

    public void setEditor(RacerListEditorModel racerListEditor) {
        this.racerListEditor = racerListEditor;
        this.initializeWindow();
    }

    protected RacerListEditorModel myEditor() {
        return this.racerListEditor;
    }

    protected void initializeWindow() {
        this.initOperationActions();
        this.racerListPanel.setRacerListHolder(this.myEditor().getRacerListHolder());
        this.adjustTableColumnWidths(this.racerListPanel.racerListTable, RacerListTableHolder.COLUMN_WIDTHS);
        this.updateRacerOperationEnablements();
        this.racerListPanePopupMenu = this.buildRacerListPanePopupMenu();
        this.configureConnections();
    }

    protected void initOperationActions() {
        this.addRacerAction = new OperationAction("New...", "Add a new racer to the list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RacerListEditorPanel.this.newRacer();
            }
        });
        this.editRacerAction = new OperationAction("Edit", "Edit the data of the selected racer.", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RacerListEditorPanel.this.editRacerData();
            }
        });
        this.removeRacerAction = new OperationAction("Delete", "Remove the selected racer from the list.", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RacerListEditorPanel.this.removeRacer();
            }
        });
        this.findRacerAction = new OperationAction("Find...", "Find a racer to the list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RacerListEditorPanel.this.findRacer();
            }
        });
        this.validateRacersAction = new OperationAction("Validate", "Validate the information about the racers in the list", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RacerListEditorPanel.this.validateRacers();
            }
        });
    }

    protected void adjustTableColumnWidths(JTable aTable, int[] preferredWidths) {
        TableColumn aColumn = null;
        for (int i = 0; i < 8; ++i) {
            aColumn = aTable.getColumnModel().getColumn(i);
            aColumn.setPreferredWidth(preferredWidths[i]);
            aColumn.setWidth(preferredWidths[i]);
        }
        aTable.setAutoResizeMode(0);
    }

    public void appendRacerOperations(JMenu aMenu) {
        this.addRacerAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.editRacerAction.appendTo(aMenu);
        this.removeRacerAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.findRacerAction.appendTo(aMenu);
    }

    protected JPopupMenu buildRacerListPanePopupMenu() {
        JPopupMenu aMenu = new JPopupMenu();
        this.addRacerAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.editRacerAction.appendTo(aMenu);
        this.removeRacerAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.findRacerAction.appendTo(aMenu);
        return aMenu;
    }

    protected void configureConnections() {
        this.myEditor().getRacerListHolder().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                RacerListEditorPanel.this.updateRacerOperationEnablements();
            }
        });
        this.racerListPanel.registerListPopupMenu(this.racerListPanePopupMenu);
        this.racerListPanel.registerListDoubleClickedHandler(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RacerListEditorPanel.this.editRacerData();
            }
        });
        this.createRacerButton.setAction(this.addRacerAction);
        this.editRacerButton.setAction(this.editRacerAction);
        this.removeRacerButton.setAction(this.removeRacerAction);
        this.validateRacersButton.setAction(this.validateRacersAction);
    }

    protected void updateRacerOperationEnablements() {
        Racer selectedRacer = this.myEditor().getSelectedRacer();
        boolean hasRacerSelection = selectedRacer != null;
        this.editRacerAction.setEnabled(hasRacerSelection);
        this.removeRacerAction.setEnabled(hasRacerSelection);
    }

    protected void editRacerData() {
        Racer selectedRacer = this.myEditor().getSelectedRacer();
        if (selectedRacer == null) {
            return;
        }
        boolean changed = EditRacerDialog.openOn(selectedRacer, this.myEditor().getRacerList(), this.getMainWindow());
        if (changed) {
            this.myEditor().updateRacer(selectedRacer);
        }
    }

    protected void newRacer() {
        Racer newRacer = NewRacerDialog.openFor(this.getMainWindow(), this.myEditor().getRacerList());
        if (newRacer == null) {
            return;
        }
        this.myEditor().addRacer(newRacer);
        this.racerListPanel.ensureSelectionIsVisible();
    }

    protected void removeRacer() {
        Racer selectedRacer = this.myEditor().getSelectedRacer();
        if (selectedRacer == null) {
            return;
        }
        this.myEditor().removeRacer(selectedRacer);
    }

    protected void findRacer() {
        String findArg = JOptionPane.showInputDialog("Find racer (bib number or first chars of last name):", (Object)"");
        if (findArg == null || (findArg = findArg.trim()).length() == 0) {
            return;
        }
        this.racerListPanel.findRacer(findArg);
    }

    protected void validateRacers() {
        int nProblems = 0;
        StringBuffer problemReports = null;
        ToolSessionRacerList racerList = this.myEditor().getRacerList();
        SeasonIdentifier season = racerList.getSeason();
        for (Racer aRacer : this.myEditor().getRacerList().getRacers()) {
            int age;
            RaceClass<?> ageClass;
            if (!aRacer.isBirthYearKnown() || (ageClass = aRacer.getAgeClass()).includesAge(age = aRacer.computeAge(season))) continue;
            if (nProblems == 0) {
                problemReports = new StringBuffer();
                problemReports.append("Racer Validation Problems");
                problemReports.append(SystemConstants.NEW_LINE);
                problemReports.append(SystemConstants.NEW_LINE);
            }
            problemReports.append("Inconsistent age class: " + aRacer.getFirstName() + ", " + aRacer.getLastName() + " (bib " + aRacer.getBib() + ")  age class " + ageClass.name + " is incorrect for age " + age + " (born " + aRacer.getBirthYear() + ")");
            problemReports.append(SystemConstants.NEW_LINE);
            ++nProblems;
        }
        if (nProblems == 0) {
            MessageDialog.displayMessage("Racer List Validation", "No problems found (" + racerList.size() + " racers checked)", this.getMainWindow());
        } else {
            problemReports.append("(" + nProblems + " problems found in " + racerList.size() + " racer entries)");
            problemReports.append(SystemConstants.NEW_LINE);
            TextWindow tw = new TextWindow("Racer List Validation Problems");
            tw.setText(problemReports.toString());
            tw.openWindow();
        }
    }
}

