/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.ui.SeasonScoringTool;
import org.ussamasters.aces.tools.ui.swing.SeriesScoringToolWindow;

public class SeasonScoringToolWindow
extends SeriesScoringToolWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 8715.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 11000.0f;
    protected JMenuBar menuBar;

    public SeasonScoringToolWindow() {
    }

    public SeasonScoringToolWindow(String title) {
        super(title);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Season Scoring Tool");
        this.menuBar = new JMenuBar();
        this.setDefaultWindowSize();
    }

    @Override
    public void initChildComponents() {
        float rightInsetSeriesDescriptionPanel = 0.0f;
        float topInsetScoredRacesPanel = 960.0f;
        float scoringFormulaWidth = 3750.0f;
        this.initRaceSeriesDescriptionPanel(rightInsetSeriesDescriptionPanel);
        this.initScoredRaceSeriesPanel(topInsetScoredRacesPanel);
        this.initScoringOperationsPanel(scoringFormulaWidth);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 165.0f, 390.0f, 8715.0f, 11000.0f);
    }

    protected SeasonScoringTool myApp() {
        return (SeasonScoringTool)this.getAppModel();
    }

    @Override
    protected String seriesFlavor() {
        return "season";
    }

    @Override
    protected void initializeWindow() {
        this.initOperationActions();
        this.configureAppNameWindowTitle();
        this.raceSeriesDescriptionPanel.setAppModel(this.myApp());
        this.scoredRaceSeriesPanel.setModel(this.myApp().getRaceSeriesHolder());
        SwingPatches.installComboBoxModel(this.scoringPoliciesComboBox, this.myApp().getScoringPoliciesHolder());
        this.reportFormatOptionsPanel.generateHTMLReportsCheckBox.setSelected(this.myApp().getGenerateHTMLReportsHolder().getValue());
        this.reportFormatOptionsPanel.generateTextReportsCheckBox.setSelected(this.myApp().getGenerateTextReportsHolder().getValue());
        this.reportFormatOptionsPanel.generatePrintReportsCheckBox.setSelected(false);
        this.reportFormatOptionsPanel.generatePrintReportsCheckBox.setEnabled(false);
        this.viewReportOperationsPanel.viewPdfReportsButton.setEnabled(false);
        this.updateScoringPolicyItems();
        this.updateReportOperationItems();
        this.buildMenuBar();
        this.completeScoredRacesPanePopupMenu();
        this.configureConnections();
    }

    protected void configureConnections() {
        this.configureRaceSeriesItemConnections();
        this.configureScoringOperationItemConnections();
    }

    protected void buildMenuBar() {
        this.frameWindow.setJMenuBar(this.menuBar);
        this.menuBar.add(this.buildFileMenu());
        this.menuBar.add(this.scoredRaceSeriesPanel.buildSeriesMenu(null));
        this.menuBar.add(this.buildReportMenu());
        this.menuBar.add(this.myToolServices().buildStandardHelpMenu(this.frameWindow));
    }

    protected JMenu buildFileMenu() {
        JMenu aMenu = this.myToolServices().constructFileMenu();
        if (this.myApp().supportsWorkingSetSwitching()) {
            this.myToolServices().appendRaceSeriesWorkingSetItems(aMenu, this.frameWindow, this.myApp());
            aMenu.addSeparator();
        }
        this.openCorrectionsLogAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.myToolServices().appendApplicationCloseItem(aMenu, this.frameWindow);
        return aMenu;
    }

    protected JMenu buildReportMenu() {
        JMenu aMenu = new JMenu("Report");
        aMenu.setToolTipText("Season scoring report operations");
        this.generateReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.viewHTMLReportsAction.appendTo(aMenu);
        this.viewTextReportsAction.appendTo(aMenu);
        this.viewPdfReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.deleteReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.viewReportsAction.appendTo(aMenu);
        return aMenu;
    }

    protected void completeScoredRacesPanePopupMenu() {
        JPopupMenu aMenu = this.scoredRaceSeriesPanel.getScoredRacesPanePopupMenu();
        aMenu.addSeparator();
        this.generateReportsAction.appendTo(aMenu);
        this.viewHTMLReportsAction.appendTo(aMenu);
        this.viewTextReportsAction.appendTo(aMenu);
        this.deleteReportsAction.appendTo(aMenu);
        aMenu.addSeparator();
        this.openCorrectionsLogAction.appendTo(aMenu);
    }

    public static void main(String[] args) {
        SeasonScoringTool.initiateSession();
        try {
            SeasonScoringTool appModel = new SeasonScoringTool();
            appModel.openWindow(new SeasonScoringToolWindow());
        }
        catch (RaceDataIOException ex) {
            System.err.println("***ERROR LAUNCHING SeasonScoringTool***");
            ex.printStackTrace();
        }
    }
}

