/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingPatches;
import com.glaivestone.mv.swing.ConfigurableListCellRenderer;
import com.glaivestone.mv.swing.ValueRenderer;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.ussamasters.aces.tools.ui.SplitRaceDialog;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;
import org.ussamasters.aces.tools.ui.swing.RaceSpecificationPanel;

public class SplitRaceDialogWindow
extends RSTDialogWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 8000.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 6000.0f;
    protected static final ConfigurableListCellRenderer SPLIT_CATEGORY_RENDERER = new ConfigurableListCellRenderer(new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            if (aValue instanceof ConstantValueWithDescription) {
                return ((ConstantValueWithDescription)aValue).description;
            }
            return aValue.toString();
        }
    });
    protected RaceSpecificationPanel raceSpecificationPanel;
    protected JComboBox<String> splitCategoryComboBox;
    protected JScrollPane splitCategoriesScrollPane;
    protected JList<String> splitCategoriesListItem;
    protected OKCancelButtonsPanel operationButtonsPanel;

    public SplitRaceDialogWindow() {
    }

    public SplitRaceDialogWindow(Dialog arg1) {
        super(arg1);
    }

    public SplitRaceDialogWindow(Frame arg1) {
        super(arg1);
    }

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.setTitle("Split Race");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    protected void initChildComponents() {
        this.initRaceSpecificationPanel();
        this.initSplitSpecificationPanel();
        this.initOperationButtonsPanel();
    }

    protected void initRaceSpecificationPanel() {
        this.raceSpecificationPanel = new RaceSpecificationPanel();
        FramerFactory.current.installComponent(this.raceSpecificationPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, 2900.0f);
        this.raceSpecificationPanel.setMinimumSize(new Dimension(1040, 964));
        this.raceSpecificationPanel.setPreferredSize(new Dimension(1040, 964));
    }

    protected void initSplitSpecificationPanel() {
        JPanel splitSpecsPanel = new JPanel();
        splitSpecsPanel.setBorder(BorderFactory.createTitledBorder("Split Criteria"));
        FramerFactory.current.installComponent(splitSpecsPanel, this.contentPanel, 1, 170, 0.0f, 3000.0f, 0.0f, 510.0f);
        splitSpecsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.splitCategoryComboBox = new JComboBox();
        FramerFactory.current.installComponent(this.splitCategoryComboBox, splitSpecsPanel, 1, 136, 0.0f, 0.0f, 2000.0f, 315.0f);
        this.splitCategoriesScrollPane = new JScrollPane();
        FramerFactory.current.installComponent(this.splitCategoriesScrollPane, splitSpecsPanel, 1, 170, 0.0f, 400.0f, 2000.0f, 0.0f);
        this.splitCategoriesListItem = new JList();
        this.splitCategoriesListItem.setCellRenderer(SPLIT_CATEGORY_RENDERER);
        this.splitCategoriesScrollPane.setViewportView(this.splitCategoriesListItem);
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        this.operationButtonsPanel.setName("operationButtonsPanel");
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1050.0f, 990.0f, 8000.0f, 6000.0f);
    }

    protected SplitRaceDialog myApp() {
        return (SplitRaceDialog)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.raceSpecificationPanel.setModel(this.myApp().getRaceSpecificationModel());
        SwingPatches.installComboBoxModel(this.splitCategoryComboBox, this.myApp().getSplitCategoryOptionsModel());
        this.splitCategoriesListItem.setModel(this.myApp().getSplitCategoriesListHolder().getDataModel());
        this.splitCategoriesListItem.setSelectionModel(this.myApp().getSplitCategoriesListHolder().getSelectionModel());
        this.configureConnections();
    }

    protected void configureConnections() {
        this.splitCategoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SplitRaceDialogWindow.this.myApp().selectedSplitOption();
            }
        });
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SplitRaceDialogWindow.this.acceptResult();
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SplitRaceDialogWindow.this.requestCloseWindow();
            }
        });
    }

    protected void acceptResult() {
        List<Object> selectedCategories = this.myApp().getSelectedCategories();
        if (selectedCategories.size() == 0) {
            MessageDialog.displayWarning("No Categories Selected", "Please select the elements you wish to include in the split race and try again.", this.dialogWindow);
            return;
        }
        this.myApp().acceptResult();
        this.requestCloseWindow();
    }
}

