/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.javax.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConstantSpecifications {
    public static final List<String> EMPTY_FIELDS_LIST = Collections.emptyList();
    public static final List<String> EMPTY_SYNONYMS_LIST = Collections.emptyList();
    protected String constantType;
    protected List<String> fields;
    protected List<String> optionalFields;
    protected List<Object> values;
    protected Map<String, List<String>> synonyms;
    protected List<Map<String, Object>> entries;

    public String getConstantType() {
        return this.constantType;
    }

    public void setConstantType(String constantType) {
        this.constantType = constantType;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fieldNames) {
        this.fields = fieldNames;
    }

    public List<String> getOptionalFields() {
        return this.optionalFields;
    }

    public void setOptionalFields(List<String> fieldNames) {
        this.optionalFields = fieldNames;
    }

    public boolean hasOptionalFields() {
        return this.optionalFields != null && !this.optionalFields.isEmpty();
    }

    public List<String> getRequiredFields() {
        List<String> requiredFields;
        if (this.hasOptionalFields()) {
            requiredFields = new ArrayList<String>(this.fields.size() - this.optionalFields.size());
            for (String fieldName : this.fields) {
                if (this.optionalFields.contains(fieldName)) continue;
                requiredFields.add(fieldName);
            }
        } else {
            requiredFields = this.fields;
        }
        return requiredFields;
    }

    public List<Map<String, Object>> getEntries() {
        if (this.entries == null) {
            this.entries = this.constructEntries();
        }
        return this.entries;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> specifications) {
        this.values = specifications;
    }

    public List<String> getSynonyms(String constName) {
        List<String> synonymSpecs = this.synonyms.get(constName);
        return synonymSpecs != null ? synonymSpecs : EMPTY_SYNONYMS_LIST;
    }

    public Map<String, List<String>> getSynonymsMap() {
        return this.synonyms;
    }

    public void setSynonyms(Map<String, List<String>> synonymSpecs) {
        this.synonyms = synonymSpecs;
    }

    public boolean hasSynonyms() {
        return this.synonyms != null && !this.synonyms.isEmpty();
    }

    public String toString() {
        return String.format("%s<%s: %s defns, %s synonyms>", this.getClass().getSimpleName(), this.constantType, this.values.size(), this.hasSynonyms() ? Integer.valueOf(this.synonyms.size()) : "no");
    }

    public void ensureWellFormed(List<String> expectedFields) {
        this.checkExpectedFieldsSpecified(expectedFields);
        this.checkExpectedValuesSpecified();
    }

    protected void checkExpectedFieldsSpecified(List<String> expectedFields) {
        if (!this.fields.equals(expectedFields)) {
            throw new RuntimeException(String.format("Invalid specs for %s: expected fields %s but got %s", this.constantType, expectedFields, this.fields));
        }
    }

    protected void checkExpectedValuesSpecified() {
        for (Object specEntry : this.values) {
            Object entry;
            if (specEntry instanceof List) {
                entry = (List)specEntry;
                this.checkFields((List<Object>)entry);
                continue;
            }
            if (specEntry instanceof Map) {
                entry = (Map)specEntry;
                this.checkFields((Map<String, Object>)entry);
                continue;
            }
            throw new RuntimeException(String.format("Invalid spec for %s: unexpected entry format %s", this.constantType, specEntry));
        }
    }

    public void checkFields(List<Object> entry) {
        int nFieldsExpected;
        int nFields = entry.size();
        if (nFields != (nFieldsExpected = this.fields.size())) {
            throw new RuntimeException(String.format("Invalid spec for %s: expected fields %s but got entry %s", this.constantType, this.fields, entry));
        }
    }

    public void checkFields(Map<String, Object> entry) {
        int nFields = entry.size();
        int nFieldsExpected = this.fields.size();
        Set<String> actualFields = entry.keySet();
        if (!this.hasOptionalFields()) {
            if (nFields != nFieldsExpected) {
                throw new RuntimeException(String.format("Invalid spec for %s: expected fields %s but got entry %s", this.constantType, this.fields, entry));
            }
            if (!actualFields.containsAll(this.fields)) {
                throw new RuntimeException(String.format("Invalid spec for %s: expected fields %s but got entry %s", this.constantType, this.fields, entry));
            }
        } else {
            List<String> requiredFields = this.getRequiredFields();
            int nFieldsRequired = requiredFields.size();
            if (nFields < nFieldsRequired || nFields > nFieldsExpected) {
                throw new RuntimeException(String.format("Invalid spec for %s: expected fields %s but got entry %s", this.constantType, this.fields, entry));
            }
            if (!actualFields.containsAll(requiredFields)) {
                throw new RuntimeException(String.format("Invalid spec for %s: expected required fields %s but got entry %s", this.constantType, this.fields, entry));
            }
            if (!this.fields.containsAll(actualFields)) {
                throw new RuntimeException(String.format("Invalid spec for %s: expected fields %s but got entry %s", this.constantType, this.fields, entry));
            }
        }
    }

    protected List<Map<String, Object>> constructEntries() {
        int nEntries = this.values != null ? this.values.size() : 0;
        ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(nEntries);
        for (Object unprocessedEntry : this.values) {
            if (unprocessedEntry instanceof List) {
                entryList.add(this.toEntry((List)unprocessedEntry));
                continue;
            }
            if (!(unprocessedEntry instanceof Map)) continue;
            entryList.add(this.toEntry((Map)unprocessedEntry));
        }
        return entryList;
    }

    protected Map<String, Object> toEntry(List<Object> unprocessedEntry) {
        int nFields = this.fields.size();
        HashMap<String, Object> entry = new HashMap<String, Object>(nFields);
        for (int i = 0; i < nFields; ++i) {
            String fieldName = this.fields.get(i);
            Object value = unprocessedEntry.get(i);
            entry.put(fieldName, value);
        }
        return entry;
    }

    protected Map<String, Object> toEntry(Map<Object, Object> unprocessedEntry) {
        int nFields = this.fields.size();
        HashMap<String, Object> entry = new HashMap<String, Object>(nFields);
        for (Map.Entry<Object, Object> specEntry : unprocessedEntry.entrySet()) {
            String fieldName = (String)specEntry.getKey();
            Object value = specEntry.getValue();
            entry.put(fieldName, value);
        }
        return entry;
    }
}

