/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.awt;

import com.glaivestone.javax.awt.ImageX;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class ImageWindow
extends Window {
    public static final int DEFAULT_MEDIA_TRACKER_ID = 0;
    private Image image;
    private MediaTracker mediaTracker;
    private boolean imagePainted = false;

    public ImageWindow(Frame parent, Image image) {
        super(parent);
        this.initialize(image);
    }

    void initialize(Image image) {
        this.setImage(image);
        this.setSizeToImageSize();
    }

    public static ImageWindow newImageWindow(Frame parent, Image image) {
        return new ImageWindow(parent, image);
    }

    public static ImageWindow newForFilenameImage(Frame parent, String filename) {
        return ImageWindow.newImageWindow(parent, ImageX.getFilenameImage(filename));
    }

    public static ImageWindow newForSystemResourceImage(Frame parent, String filename) {
        return ImageWindow.newImageWindow(parent, ImageX.getSystemResourceImage(filename));
    }

    public void centerOnScreen() {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle windowDim = this.getBounds();
        this.setLocation((screenDim.width - windowDim.width) / 2, (screenDim.height - windowDim.height) / 2);
    }

    @Override
    public void paint(Graphics g) {
        if (this.getImage() != null) {
            g.drawImage(this.getImage(), 0, 0, this);
            this.isImagePainted(true);
        }
    }

    public void setSizeToImageSize(Image anImage) {
        if (anImage == null) {
            return;
        }
        this.setSizeCheck(anImage.getWidth(this), anImage.getHeight(this));
    }

    public void setSizeToImageSize() {
        this.setSizeToImageSize(this.getImage());
    }

    public boolean setSizeCheck(int width, int height) {
        if (height == -1 || width == -1) {
            return true;
        }
        this.setSize(width, height);
        return false;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return this.setSizeCheck(width, height);
    }

    public Image getImage() {
        return this.image;
    }

    public boolean hasMediaTracker() {
        return this.mediaTracker != null;
    }

    public MediaTracker getMediaTracker() {
        if (this.mediaTracker == null) {
            this.mediaTracker = new MediaTracker(this);
        }
        return this.mediaTracker;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setMediaTracker(MediaTracker mediaTracker) {
        this.mediaTracker = mediaTracker;
    }

    @Override
    public String toString() {
        return super.toString() + " [" + this.getImage() + "]";
    }

    public void waitForImage() {
        this.waitForImage(0);
    }

    public void waitForImage(int mediaTrackerID) {
        this.getMediaTracker().addImage(this.getImage(), mediaTrackerID);
        try {
            this.getMediaTracker().waitForID(mediaTrackerID);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isImagePainted() {
        return this.imagePainted;
    }

    void isImagePainted(boolean imagePainted) {
        this.imagePainted = imagePainted;
    }
}

