/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.execution;

public class ClassReference {
    protected String description;
    protected String targetClassName;
    protected Class<?> targetClass;

    protected ClassReference(String targetClassName, String description) {
        this.targetClassName = targetClassName;
        this.description = description;
    }

    public static ClassReference create(String className, String description) {
        return new ClassReference(className, description);
    }

    public static Class<?> resolve(String className, String description) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid class reference " + className + " (" + description + ")" + ": " + ex.getMessage());
        }
    }

    public Class<?> getReferencedClass() {
        if (!this.isResolved()) {
            this.targetClass = ClassReference.resolve(this.targetClassName, this.description);
        }
        return this.targetClass;
    }

    public boolean isResolved() {
        return this.targetClass != null;
    }

    public void resolve() {
        this.getReferencedClass();
    }
}

