/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.io;

import com.glaivestone.javax.io.FileConstants;
import com.glaivestone.javax.io.FileSystemServices;
import java.io.File;

public class FileSystemReference {
    private FileSystemReference() {
    }

    public static String computeRelativePath(File fsElement, File referenceDirectory) {
        String parentRelativePath;
        File parentDirectory;
        String directoryPathName;
        int nCharsDirectoryPath;
        String elementPathName = fsElement.getAbsolutePath();
        int nCharsElementPath = elementPathName.length();
        if (nCharsElementPath >= (nCharsDirectoryPath = (directoryPathName = referenceDirectory.getAbsolutePath()).length()) && elementPathName.toLowerCase().startsWith(directoryPathName.toLowerCase())) {
            if (nCharsElementPath == nCharsDirectoryPath) {
                return ".";
            }
            if (elementPathName.charAt(nCharsDirectoryPath) == FileConstants.NAME_SEPARATOR_CHAR) {
                return nCharsElementPath == nCharsDirectoryPath + 1 ? "." : elementPathName.substring(nCharsDirectoryPath + 1);
            }
        }
        if ((parentDirectory = referenceDirectory.getParentFile()) != null && (parentRelativePath = FileSystemReference.computeRelativePath(fsElement, parentDirectory)) != null) {
            return parentRelativePath.equals(".") ? ".." : ".." + FileConstants.NAME_SEPARATOR + parentRelativePath;
        }
        return null;
    }

    public static String getFileBaseName(File aFile) {
        FileSystemServices.getCurrent().validateFile(aFile);
        return FileSystemReference.getFileBaseName(aFile.getName());
    }

    public static String getFileBaseName(String aFileName) {
        int separatorIndex = aFileName.lastIndexOf(".");
        return separatorIndex == -1 ? aFileName : aFileName.substring(0, separatorIndex);
    }

    public static String getFileExtension(File aFile) {
        FileSystemServices.getCurrent().validateFile(aFile);
        return FileSystemReference.getFileExtension(aFile.getName());
    }

    public static String getFileExtension(String aFileName) {
        int separatorIndex = aFileName.lastIndexOf(".");
        return separatorIndex == -1 ? null : aFileName.substring(separatorIndex + 1, aFileName.length());
    }

    public static boolean hasFileExtension(File aFile, String extension) {
        return FileSystemReference.getFileExtension(aFile).equalsIgnoreCase(extension);
    }

    public static String mapPathSeparator(String aPathName, char separator) {
        char hostFileSystemSeparator = File.separatorChar;
        return separator == hostFileSystemSeparator ? aPathName : aPathName.replace(hostFileSystemSeparator, separator);
    }

    public static File resolveRelativePath(File referenceDirectory, String relativePathName) {
        File baseDirectory = new File(referenceDirectory.getAbsolutePath());
        char dot = '.';
        char separator = FileConstants.NAME_SEPARATOR_CHAR;
        int index = 0;
        int nChars = relativePathName.length();
        while (index < nChars && relativePathName.charAt(index) == dot) {
            if (++index == nChars) {
                return baseDirectory;
            }
            char nextChar = relativePathName.charAt(index);
            if (nextChar == separator) {
                ++index;
                continue;
            }
            if (nextChar != dot) continue;
            baseDirectory = baseDirectory.getParentFile();
            if (++index >= nChars || (nextChar = relativePathName.charAt(index)) != separator) continue;
            ++index;
        }
        return new File(baseDirectory, relativePathName.substring(index));
    }
}

