/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.io;

import com.glaivestone.javax.io.FileSystemReference;
import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.io.File;
import java.util.List;

public class FileType
extends ConstantValueWithDescription<FileType> {
    private static final Class<FileType> THIS_CLASS = FileType.class;
    public static final FileType TEXT = FileType.defineConstant("text", "txt", "text");
    public static final FileType HTML = FileType.defineConstant("HTML", "html", "HTML");
    public static final FileType XML = FileType.defineConstant("XML", "xml", "XML");
    public static final FileType GIF = FileType.defineConstant("GIF", "gif", "GIF image");
    public static final FileType JPEG = FileType.defineConstant("JPEG", "jpeg", "JPEG image");
    public static final FileType JAR = FileType.defineConstant("JAR", "jar", "Java Archive");
    public static final FileType ZIP = FileType.defineConstant("ZIP", "zip", "ZIP Archive");
    public final String extension;

    public static FileType defineConstant(String name, String extension, String description) {
        FileType aConstant = FileType.getConstant(name);
        if (aConstant != null) {
            aConstant.validateDefinitionConsistency(extension, description);
            return aConstant;
        }
        return new FileType(name, extension, description);
    }

    public static FileType getConstant(int ordinalValue) {
        return FileType.getConstant(ordinalValue, THIS_CLASS);
    }

    public static FileType getConstant(String name) {
        return FileType.getConstant(name, THIS_CLASS);
    }

    public static FileType valueOf(String name) {
        return FileType.valueOf(THIS_CLASS, name);
    }

    public static List<FileType> values() {
        return FileType.values(THIS_CLASS);
    }

    protected FileType(String name, String extension, String description) {
        super(name, description);
        this.extension = extension;
    }

    @Override
    protected boolean allowSynonyms() {
        return true;
    }

    public String composeFileName(String fileBaseName) {
        return fileBaseName + "." + this.extension;
    }

    public boolean sameExtension(File aFile) {
        return FileSystemReference.hasFileExtension(aFile, this.extension);
    }

    protected void validateDefinitionConsistency(String extension, String description) {
        if (!this.extension.equalsIgnoreCase(extension)) {
            throw new IllegalArgumentException("Conflicting FileType definition: cannot change extension " + this.extension + " of " + this.toConstantName() + " to " + extension);
        }
        if (!this.description.equalsIgnoreCase(description)) {
            throw new IllegalArgumentException("Conflicting FileType definition: cannot change description of " + this.toConstantName() + " to '" + description + "'");
        }
    }
}

