/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.io;

import java.io.InputStream;
import java.io.PrintStream;

public class SystemIOStreams {
    public static final InputStream CONSOLE_STDIN = System.in;
    public static final PrintStream CONSOLE_STDOUT = System.out;
    public static final PrintStream CONSOLE_STDERR = System.err;

    private SystemIOStreams() {
    }

    public static void bindConsoleReferences() {
    }

    public static void disconnectSysErr(PrintStream ps) {
        if (ps.equals(System.err)) {
            SystemIOStreams.resetSysErr();
        }
    }

    public static void disconnectSysOut(PrintStream ps) {
        if (ps.equals(System.out)) {
            SystemIOStreams.resetSysOut();
        }
    }

    public static boolean isSysErr(PrintStream ps) {
        return SystemIOStreams.isSystemStream(ps, System.err);
    }

    public static boolean isSysOut(PrintStream ps) {
        return SystemIOStreams.isSystemStream(ps, System.out);
    }

    protected static boolean isSystemStream(PrintStream ps, PrintStream sysStream) {
        return sysStream == ps;
    }

    public static void resetSysErr() {
        SystemIOStreams.setSysErr(CONSOLE_STDERR);
    }

    public static void resetSysOut() {
        SystemIOStreams.setSysOut(CONSOLE_STDOUT);
    }

    public static synchronized void resetSystemOutputStreams() {
        SystemIOStreams.resetSysOut();
        SystemIOStreams.resetSysErr();
    }

    public static synchronized void setSysErr(PrintStream ps) {
        if (ps == null) {
            SystemIOStreams.resetSysErr();
            return;
        }
        System.setErr(ps);
    }

    public static synchronized void setSysOut(PrintStream ps) {
        if (ps == null) {
            SystemIOStreams.resetSysOut();
            return;
        }
        System.setOut(ps);
    }

    public static synchronized void setSystemOutputStreams(PrintStream ps) {
        if (ps == null) {
            SystemIOStreams.resetSystemOutputStreams();
            return;
        }
        SystemIOStreams.setSysOut(ps);
        SystemIOStreams.setSysErr(ps);
    }

    static {
        SystemIOStreams.bindConsoleReferences();
    }
}

