/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing;

import com.glaivestone.javax.swing.ToolTipTextAccessor;
import com.glaivestone.javax.swing.ToolTipTextEventAccessor;
import com.glaivestone.javax.swing.tree.DefaultMutableTreeNodeX;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeX
extends JTree {
    private ToolTipTextEventAccessor toolTipTextEventAccessor;

    public JTreeX() {
        this.registerWithToolTipManager();
    }

    public JTreeX(Object[] value) {
        super(value);
        this.registerWithToolTipManager();
    }

    public JTreeX(Vector<?> value) {
        super(value);
        this.registerWithToolTipManager();
    }

    public JTreeX(Hashtable<?, ?> value) {
        super(value);
        this.registerWithToolTipManager();
    }

    public JTreeX(TreeNode root) {
        super(root);
        this.registerWithToolTipManager();
    }

    public JTreeX(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.registerWithToolTipManager();
    }

    public JTreeX(TreeModel newModel) {
        super(newModel);
        this.registerWithToolTipManager();
    }

    public static TreeNode getTreeNode(JTree tree, MouseEvent mouseEvent) {
        TreePath treePath = JTreeX.getTreePath(tree, mouseEvent);
        if (treePath == null) {
            return null;
        }
        return (TreeNode)treePath.getLastPathComponent();
    }

    public static TreePath getTreePath(JTree tree, MouseEvent mouseEvent) {
        if (mouseEvent == null || tree == null) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        if (point == null) {
            return null;
        }
        return tree.getClosestPathForLocation(point.x, point.y);
    }

    public static Object getUserObject(JTree tree, MouseEvent mouseEvent) {
        TreeNode treeNode = JTreeX.getTreeNode(tree, mouseEvent);
        if (treeNode == null || !(treeNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        return ((DefaultMutableTreeNode)treeNode).getUserObject();
    }

    public static MutableTreeNode newMutableTreeNode(Object userObject) {
        return new DefaultMutableTreeNode(userObject);
    }

    public static MutableTreeNode newMutableTreeNode(Object userObject, String toolTip) {
        return new DefaultMutableTreeNodeX(userObject, toolTip);
    }

    public static TreeModel newTreeModel(TreeNode treeNode) {
        return new DefaultTreeModel(treeNode);
    }

    public void collapseAll() {
        for (int rowIndex = this.getRowCount(); rowIndex >= 0; --rowIndex) {
            this.collapseRow(rowIndex);
        }
    }

    public void collapseAllBelowDepth(int depth) {
        for (int rowIndex = this.getRowCount(); rowIndex >= 0; --rowIndex) {
            TreePath treePath = this.getPathForRow(rowIndex);
            if (treePath == null || treePath.getPathCount() <= depth) continue;
            this.collapsePath(treePath);
        }
    }

    public void expandAll() {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            this.expandRow(rowIndex);
        }
    }

    public void expandAll(Class<?> typeToExpand) {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Object object = this.getPathForRow(rowIndex).getLastPathComponent();
            if (!typeToExpand.isInstance(object)) continue;
            this.expandRow(rowIndex);
        }
    }

    public void expandAllExcept(Class<?> typeToExclude) {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            Object object = this.getPathForRow(rowIndex).getLastPathComponent();
            if (typeToExclude.isInstance(object)) continue;
            this.expandRow(rowIndex);
        }
    }

    public String getToolTipFromNode(MouseEvent mouseEvent) {
        ToolTipTextAccessor accessor = this.getToolTipTextAccessor(mouseEvent);
        return accessor != null ? accessor.getToolTipText() : null;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipTextEventAccessor() != null ? this.getToolTipTextEventAccessor().getToolTipText(mouseEvent) : this.getToolTipFromNode(mouseEvent);
    }

    public ToolTipTextAccessor getToolTipTextAccessor(MouseEvent mouseEvent) {
        TreeNode treeNode = JTreeX.getTreeNode(this, mouseEvent);
        if (treeNode instanceof ToolTipTextAccessor) {
            return (ToolTipTextAccessor)((Object)treeNode);
        }
        return null;
    }

    public ToolTipTextEventAccessor getToolTipTextEventAccessor() {
        return this.toolTipTextEventAccessor;
    }

    public Object getUserObject(MouseEvent mouseEvent) {
        return JTreeX.getUserObject(this, mouseEvent);
    }

    public void registerWithToolTipManager() {
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public boolean hasSelection() {
        if (this.getSelectionModel() == null) {
            return false;
        }
        return !this.getSelectionModel().isSelectionEmpty();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public void setToolTipTextEventAccessor(ToolTipTextEventAccessor toolTipTextEventAccessor) {
        this.toolTipTextEventAccessor = toolTipTextEventAccessor;
    }
}

