/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class OperationAction
extends AbstractAction {
    protected ActionListener operationHandler;

    public OperationAction(String name, ActionListener operationHandler) {
        super(name);
        this.operationHandler = operationHandler;
    }

    public OperationAction(String name, char mnemonic, ActionListener operationHandler) {
        this(name, operationHandler);
        this.setMnemonic(mnemonic);
    }

    public OperationAction(String name, String operationDescription, ActionListener operationHandler) {
        this(name, operationHandler);
        this.setDescription(operationDescription);
    }

    public OperationAction(String name, char mnemonic, String shortDescription, ActionListener operationHandler) {
        this(name, shortDescription, operationHandler);
        this.setMnemonic(mnemonic);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.operationHandler.actionPerformed(event);
    }

    public JMenuItem appendTo(JMenu aMenu) {
        JMenuItem mi = new JMenuItem(this);
        aMenu.add(mi);
        this.installToolTip(mi);
        return mi;
    }

    public JMenuItem appendTo(JPopupMenu aMenu) {
        JMenuItem mi = new JMenuItem(this);
        aMenu.add(mi);
        this.installToolTip(mi);
        return mi;
    }

    @Deprecated
    public void attachTo(JButton aButton) {
        aButton.setAction(this);
    }

    public void attachTo(JMenuItem aMenuItem) {
        this.installMnemonic(aMenuItem);
        this.installAccelerator(aMenuItem);
    }

    protected PropertyChangeListener constructUpdateEnablementHandler(final JComponent aComponent) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("enabled")) {
                    aComponent.setEnabled((Boolean)event.getNewValue());
                }
            }
        };
    }

    public void installAccelerator(JMenuItem aComponent) {
        KeyStroke accelerator = (KeyStroke)this.getValue("AcceleratorKey");
        if (accelerator != null) {
            aComponent.setAccelerator(accelerator);
        }
    }

    public void installMnemonic(AbstractButton aComponent) {
        String mnemonic = (String)this.getValue("MnemonicKey");
        if (mnemonic != null) {
            aComponent.setMnemonic(mnemonic.charAt(0));
        }
    }

    public void installToolTip(JComponent aComponent) {
        String operationDescription = (String)this.getValue("ShortDescription");
        if (operationDescription != null) {
            aComponent.setToolTipText(operationDescription);
        }
    }

    public void setAccelerator(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public void setDescription(String operationDescription) {
        this.putValue("ShortDescription", operationDescription);
    }

    public void setMnemonic(char mnemonic) {
        this.putValue("MnemonicKey", "" + mnemonic);
    }
}

