/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing;

import com.glaivestone.javax.io.FileSystemReference;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class SplashScreenWindow
extends JWindow {
    protected JLabel imageComponent;

    public SplashScreenWindow(Icon anImage) {
        this(anImage, BorderFactory.createRaisedBevelBorder());
    }

    public SplashScreenWindow(Icon anImage, Border aBorder) {
        this.buildWindow(anImage, aBorder);
    }

    public static Border defaultBorder() {
        return BorderFactory.createLineBorder(Color.black);
    }

    public static SplashScreenWindow openOn(File aFile) {
        if (!aFile.exists()) {
            return null;
        }
        String aPathName = FileSystemReference.mapPathSeparator(aFile.getAbsolutePath(), '/');
        return SplashScreenWindow.openOn(aPathName);
    }

    public static SplashScreenWindow openOn(Icon anImage) {
        return SplashScreenWindow.openOn(anImage, SplashScreenWindow.defaultBorder());
    }

    public static SplashScreenWindow openOn(Icon anImage, Border aBorder) {
        SplashScreenWindow aSplashScreen = new SplashScreenWindow(anImage, aBorder);
        aSplashScreen.centerOnScreen();
        aSplashScreen.setVisible(true);
        return aSplashScreen;
    }

    public static SplashScreenWindow openOn(String aPathName) {
        return SplashScreenWindow.openOn(new ImageIcon(aPathName));
    }

    protected void buildWindow(Icon anImage, Border aBorder) {
        this.imageComponent = new JLabel(anImage);
        this.imageComponent.setBorder(aBorder);
        this.getContentPane().add((Component)this.imageComponent, "Center");
        this.pack();
    }

    public void centerOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension imageSize = this.imageComponent.getPreferredSize();
        this.setLocation(screenSize.width / 2 - imageSize.width / 2, screenSize.height / 2 - imageSize.height / 2);
    }
}

