/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Itr<E>
implements Iterator<E> {
    List<E> list;
    int modCount;
    int cursor = 0;
    int lastRet = -1;
    int expectedModCount = this.modCount;

    public Itr(List<E> list, int modCount) {
        this.list = list;
        this.modCount = modCount;
        this.expectedModCount = modCount;
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.list.size();
    }

    @Override
    public E next() {
        try {
            E next = this.list.get(this.cursor);
            this.checkForComodification();
            this.lastRet = this.cursor++;
            return next;
        }
        catch (IndexOutOfBoundsException e) {
            this.checkForComodification();
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        if (this.lastRet == -1) {
            throw new IllegalStateException();
        }
        this.checkForComodification();
        try {
            this.list.remove(this.lastRet);
            if (this.lastRet < this.cursor) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.expectedModCount = this.modCount;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
    }

    final void checkForComodification() {
        if (this.modCount != this.expectedModCount) {
            throw new ConcurrentModificationException("modCount " + this.modCount + " != expectedModCount" + this.expectedModCount);
        }
    }
}

