/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv;

import com.glaivestone.javax.util.EventListenerList;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;

public class AbstractValueHolder {
    public static final int NOTIFY_FIRST_TO_LAST = 0;
    public static final int NOTIFY_LAST_TO_FIRST = 1;
    public static int DEFAULT_NOTIFICATION_ORDER = 1;
    protected EventListenerList listenerList = this.constructValueChangeListenerList();
    protected int notificationOrder;

    protected AbstractValueHolder() {
        this(DEFAULT_NOTIFICATION_ORDER);
    }

    protected AbstractValueHolder(int notificationOrder) {
        this.setNotificationOrder(notificationOrder);
    }

    public void addChangeListener(ValueChangeListener aListener) {
        this.listenerList.add(aListener);
    }

    protected EventListenerList constructValueChangeListenerList() {
        return new EventListenerList(ValueChangeListener.class);
    }

    protected void fireValueChanged(Object oldValue, Object newValue) {
        ValueChangeEvent event = new ValueChangeEvent(this, oldValue, newValue);
        this.fireValueChanged(event);
    }

    protected void fireValueChanged(ValueChangeEvent event) {
        ValueChangeListener[] listeners = (ValueChangeListener[])this.listenerList.getListeners();
        switch (this.notificationOrder) {
            case 0: {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].valueChanged(event);
                }
                break;
            }
            case 1: {
                for (int i = listeners.length - 1; i >= 0; --i) {
                    listeners[i].valueChanged(event);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value change notification order: " + this.notificationOrder);
            }
        }
    }

    public void removeChangeListener(ValueChangeListener aListener) {
        this.listenerList.remove(aListener);
    }

    public void setNotificationOrder(int notificationOrder) {
        this.notificationOrder = notificationOrder;
    }
}

