/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv.swing;

import com.glaivestone.mv.ApplicationModel;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.FrameWindowApplicationModel;
import com.glaivestone.mv.StringHolder;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.mv.swing.SwingUISessionManager;
import java.awt.Image;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class JFrameApplicationView
extends JFrame
implements ApplicationView {
    protected ApplicationModel appModel;

    public JFrameApplicationView() {
    }

    public JFrameApplicationView(String title) {
        super(title);
    }

    @Override
    public void closeWindow() {
        this.getAppModel().closeWindow(this);
    }

    protected String composeWindowTitle(String appTitle, StringHolder subjectHolder) {
        return subjectHolder.getText() + " - " + appTitle;
    }

    public void configureAppNameWindowTitle() {
        FrameWindowApplicationModel myApp = (FrameWindowApplicationModel)this.getAppModel();
        final String appTitle = myApp.getTitle();
        final StringHolder subjectHolder = myApp.getSubjectDescriptionHolder();
        if (subjectHolder == null) {
            this.setTitle(appTitle);
        } else {
            this.setTitle(this.composeWindowTitle(appTitle, subjectHolder));
            subjectHolder.addChangeListener(new ValueChangeListener(){

                @Override
                public void valueChanged(ValueChangeEvent event) {
                    JFrameApplicationView.this.setTitle(JFrameApplicationView.this.composeWindowTitle(appTitle, subjectHolder));
                }
            });
        }
    }

    protected void configureWindowIcon() {
        FrameWindowApplicationModel myApp = (FrameWindowApplicationModel)this.getAppModel();
        URL iconReference = myApp.getIconReference();
        if (iconReference == null) {
            return;
        }
        Image icon = new ImageIcon(iconReference).getImage();
        if (icon == null) {
            return;
        }
        this.setIconImage(icon);
    }

    protected void configureWindowTitle() {
    }

    @Override
    public ApplicationModel getAppModel() {
        return this.appModel;
    }

    @Override
    public Window getMainWindow() {
        return this;
    }

    protected void initDefaultCloseOperation() {
        this.setDefaultCloseOperation(0);
    }

    protected void initializeMainWindow() {
        this.initDefaultCloseOperation();
        this.configureWindowTitle();
        this.configureWindowIcon();
    }

    protected void initializeWindow() {
    }

    @Override
    public boolean requestCloseWindow() {
        return this.getAppModel().requestCloseWindow(this);
    }

    @Override
    public void setAppModel(ApplicationModel aModel) {
        this.appModel = aModel;
        this.initializeMainWindow();
        this.initializeWindow();
    }

    static {
        SwingUISessionManager.installCurrent();
    }
}

