/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv.swing;

import com.glaivestone.mv.swing.ConfigurableTableCellRenderer;
import com.glaivestone.mv.swing.ValueRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;

public class ReadOnlyTableCellRenderer
extends ConfigurableTableCellRenderer {
    private Color unselectedForeground;
    private Color unselectedBackground;

    public ReadOnlyTableCellRenderer() {
    }

    public ReadOnlyTableCellRenderer(ValueRenderer aValueRenderer) {
        super(aValueRenderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        this.setValue(value);
        Color cellBC = this.getBackground();
        boolean colorMatch = cellBC != null && cellBC.equals(table.getBackground()) && table.isOpaque();
        this.setOpaque(!colorMatch);
        return this;
    }

    @Override
    public void setBackground(Color aColor) {
        super.setBackground(aColor);
        this.unselectedBackground = aColor;
    }

    @Override
    public void setForeground(Color aColor) {
        super.setForeground(aColor);
        this.unselectedForeground = aColor;
    }
}

