/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.mv.text.swing;

import com.glaivestone.mv.swing.JFrameApplicationView;
import com.glaivestone.toolbox.mv.text.BasicTextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;

public class SimpleTextWindowView
extends JFrameApplicationView {
    protected JScrollPane textPaneScroller;
    protected JTextComponent textPane;

    protected void configureConnections() {
    }

    @Override
    protected void configureWindowTitle() {
        this.configureAppNameWindowTitle();
    }

    protected void constructComponents() {
        JPanel contentPanel = this.constructContentPanel();
        this.textPane = this.constructTextComponent();
        this.textPaneScroller = new JScrollPane(this.textPane);
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add(this.textPaneScroller);
    }

    protected JPanel constructContentPanel() {
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(BorderFactory.createEtchedBorder());
        return contentPanel;
    }

    protected JTextComponent constructTextComponent() {
        String textType = (String)this.getTextApp().getTextSpecifications().get("textType");
        if (textType == "unstyled") {
            return this.constructUnstyledTextComponent();
        }
        if (textType == "styled") {
            return this.constructStyledTextComponent();
        }
        throw new IllegalStateException("Unknown text window text type: " + textType);
    }

    protected JTextComponent constructStyledTextComponent() {
        return new JTextPane((StyledDocument)this.getTextHolder());
    }

    protected JTextComponent constructUnstyledTextComponent() {
        JTextArea textComponent = new JTextArea(this.getTextHolder());
        textComponent.setLineWrap(true);
        textComponent.setWrapStyleWord(true);
        return textComponent;
    }

    protected BasicTextWindow getTextApp() {
        return (BasicTextWindow)this.getAppModel();
    }

    public JTextComponent getTextComponent() {
        return this.textPane;
    }

    protected Document getTextHolder() {
        return this.getTextApp().getTextHolder();
    }

    protected void initPreferredSize() {
        this.setSize(600, 500);
    }

    @Override
    protected void initializeWindow() {
        this.constructComponents();
        this.configureConnections();
        this.initPreferredSize();
    }
}

